/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.subsystem;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.migration.core.ServerMigrationTask;
import org.jboss.migration.core.ServerMigrationTaskContext;
import org.jboss.migration.wfly10.config.management.SubsystemsManagement;
import org.jboss.migration.wfly10.config.task.subsystem.WildFly10Subsystem;

public class Extension {
    private final String name;
    protected final List<WildFly10Subsystem> subsystems;

    public Extension(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        this.name = name;
        this.subsystems = new ArrayList<WildFly10Subsystem>();
    }

    public String getName() {
        return this.name;
    }

    public List<WildFly10Subsystem> getSubsystems() {
        return Collections.unmodifiableList(this.subsystems);
    }

    public void migrate(SubsystemsManagement subsystemsManagement, ServerMigrationTaskContext context) throws IOException {
        for (WildFly10Subsystem subsystem : this.subsystems) {
            ServerMigrationTask subsystemTask = subsystem.getServerMigrationTask(subsystemsManagement);
            if (subsystemTask == null) continue;
            context.execute(subsystemTask);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Extension that = (Extension)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }
}

