/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.subsystem;

import java.io.IOException;
import java.util.Set;
import org.jboss.migration.core.ServerMigrationTaskContext;
import org.jboss.migration.wfly10.config.management.ExtensionsManagement;
import org.jboss.migration.wfly10.config.management.SubsystemsManagement;
import org.jboss.migration.wfly10.config.task.subsystem.Extension;
import org.jboss.migration.wfly10.config.task.subsystem.WildFly10Subsystem;

public class LegacyExtension
extends Extension {
    public LegacyExtension(String name) {
        super(name);
    }

    @Override
    public void migrate(SubsystemsManagement subsystemsManagement, ServerMigrationTaskContext context) throws IOException {
        super.migrate(subsystemsManagement, context);
        ExtensionsManagement extensionsManagement = subsystemsManagement.getServerConfiguration().getExtensionsManagement();
        if (extensionsManagement.getResourceNames().contains(this.getName())) {
            Set<String> subsystems = extensionsManagement.getSubsystems();
            boolean remove = true;
            for (WildFly10Subsystem subsystem : this.getSubsystems()) {
                if (!subsystems.contains(subsystem.getName())) continue;
                remove = false;
                break;
            }
            if (remove) {
                extensionsManagement.removeResource(this.getName());
                context.getLogger().debugf("Extension %s removed.", (Object)this.getName());
            }
        }
    }
}

