/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.subsystem;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.ParentServerMigrationTask;
import org.jboss.migration.core.ServerMigrationTask;
import org.jboss.migration.core.ServerMigrationTaskContext;
import org.jboss.migration.core.ServerMigrationTaskName;
import org.jboss.migration.core.ServerMigrationTaskResult;
import org.jboss.migration.core.env.SkippableByEnvServerMigrationTask;
import org.jboss.migration.wfly10.config.management.HostConfiguration;
import org.jboss.migration.wfly10.config.management.HostControllerConfiguration;
import org.jboss.migration.wfly10.config.management.ManageableServerConfiguration;
import org.jboss.migration.wfly10.config.management.StandaloneServerConfiguration;
import org.jboss.migration.wfly10.config.management.SubsystemsManagement;
import org.jboss.migration.wfly10.config.task.executor.SubsystemsManagementSubtaskExecutor;
import org.jboss.migration.wfly10.config.task.executor.SubtaskExecutorAdapters;
import org.jboss.migration.wfly10.config.task.factory.DomainConfigurationTaskFactory;
import org.jboss.migration.wfly10.config.task.factory.HostConfigurationTaskFactory;
import org.jboss.migration.wfly10.config.task.factory.StandaloneServerConfigurationTaskFactory;
import org.jboss.migration.wfly10.config.task.subsystem.RemoveExtension;

public class MigrateSubsystemTaskFactory<S>
implements StandaloneServerConfigurationTaskFactory<S>,
DomainConfigurationTaskFactory<S>,
HostConfigurationTaskFactory<S> {
    private final String subsystemName;
    private final String taskNameName;
    private final String extensionModule;

    public MigrateSubsystemTaskFactory(String subsystemName) {
        this(subsystemName, null);
    }

    public MigrateSubsystemTaskFactory(String subsystemName, String extensionModule) {
        this.subsystemName = subsystemName;
        this.taskNameName = "migrate-subsystem";
        this.extensionModule = extensionModule;
    }

    @Override
    public ServerMigrationTask getTask(S source, HostConfiguration configuration) throws Exception {
        return this.getTask(source, configuration, SubtaskExecutorAdapters.of(source, configuration, new ConfigMigration(this.subsystemName)));
    }

    @Override
    public ServerMigrationTask getTask(S source, HostControllerConfiguration configuration) throws Exception {
        return this.getTask(source, configuration, SubtaskExecutorAdapters.of(source, configuration, new ConfigMigration(this.subsystemName)));
    }

    @Override
    public ServerMigrationTask getTask(S source, StandaloneServerConfiguration configuration) throws Exception {
        return this.getTask(source, configuration, SubtaskExecutorAdapters.of(source, configuration, new ConfigMigration(this.subsystemName)));
    }

    protected ServerMigrationTask getTask(S source, ManageableServerConfiguration configuration, ParentServerMigrationTask.SubtaskExecutor subtaskExecutor) throws Exception {
        ServerMigrationTaskName taskName = new ServerMigrationTaskName.Builder(this.taskNameName).addAttribute("name", this.subsystemName).build();
        ParentServerMigrationTask.Builder taskBuilder = new ParentServerMigrationTask.Builder(taskName).subtask(subtaskExecutor).eventListener(new ParentServerMigrationTask.EventListener(){

            public void started(ServerMigrationTaskContext context) {
                context.getLogger().infof("Migrating subsystem %s configurations...", (Object)MigrateSubsystemTaskFactory.this.subsystemName);
            }

            public void done(ServerMigrationTaskContext context) {
                context.getLogger().infof("Subsystem %s configurations migrated.", (Object)MigrateSubsystemTaskFactory.this.subsystemName);
            }
        });
        if (this.extensionModule != null) {
            taskBuilder.subtask(SubtaskExecutorAdapters.of(source, configuration, new RemoveExtension(this.extensionModule)));
        }
        return new SkippableByEnvServerMigrationTask((ServerMigrationTask)taskBuilder.build(), this.taskNameName + ".skip");
    }

    protected static class ConfigMigration<S>
    implements SubsystemsManagementSubtaskExecutor<S> {
        private final String subsystemName;

        protected ConfigMigration(String subsystemName) {
            this.subsystemName = subsystemName;
        }

        @Override
        public void executeSubtasks(S source, final SubsystemsManagement subsystemsManagement, ServerMigrationTaskContext context) throws Exception {
            final String configName = subsystemsManagement.getResourcePathAddress(this.subsystemName).toCLIStyleString();
            final ServerMigrationTaskName taskName = new ServerMigrationTaskName.Builder("migrate-config").addAttribute("name", configName).build();
            ServerMigrationTask task = new ServerMigrationTask(){

                public ServerMigrationTaskName getName() {
                    return taskName;
                }

                public ServerMigrationTaskResult run(ServerMigrationTaskContext context) throws Exception {
                    ModelNode subsystemConfig = subsystemsManagement.getResource(ConfigMigration.this.subsystemName);
                    if (subsystemConfig == null) {
                        return ServerMigrationTaskResult.SKIPPED;
                    }
                    context.getLogger().debugf("Migrating subsystem %s config %s...", (Object)ConfigMigration.this.subsystemName, (Object)configName);
                    PathAddress address = subsystemsManagement.getResourcePathAddress(ConfigMigration.this.subsystemName);
                    ModelNode op = Util.createEmptyOperation((String)"migrate", (PathAddress)address);
                    ModelNode result = subsystemsManagement.getServerConfiguration().getModelControllerClient().execute(op);
                    context.getLogger().debugf("Op result: %s", (Object)result.asString());
                    String outcome = result.get("outcome").asString();
                    if (!"success".equals(outcome)) {
                        throw new RuntimeException("Subsystem config " + configName + " migration failed: " + result.get("migration-error").asString());
                    }
                    ServerMigrationTaskResult.Builder resultBuilder = new ServerMigrationTaskResult.Builder().sucess();
                    ArrayList<String> migrateWarnings = new ArrayList<String>();
                    if (result.get("result").hasDefined("migration-warnings")) {
                        for (ModelNode modelNode : result.get("result").get("migration-warnings").asList()) {
                            migrateWarnings.add(modelNode.asString());
                        }
                    }
                    ConfigMigration.this.processWarnings(migrateWarnings, subsystemsManagement, context);
                    if (migrateWarnings.isEmpty()) {
                        context.getLogger().infof("Subsystem config %s migrated.", (Object)configName);
                    } else {
                        context.getLogger().infof("Subsystem config %s migrated with warnings: %s", (Object)configName, migrateWarnings);
                        resultBuilder.addAttribute("migration-warnings", migrateWarnings);
                    }
                    if (subsystemsManagement.getResourceNames().contains(ConfigMigration.this.subsystemName)) {
                        subsystemsManagement.removeResource(ConfigMigration.this.subsystemName);
                        context.getLogger().debugf("Subsystem config %s removed after migration.", (Object)configName);
                    }
                    return resultBuilder.build();
                }
            };
            context.execute(task);
        }

        protected void processWarnings(List<String> migrationWarnings, SubsystemsManagement subsystemsManagement, ServerMigrationTaskContext context) throws Exception {
        }
    }
}

