/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.subsystem;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.ServerMigrationTask;
import org.jboss.migration.core.ServerMigrationTaskContext;
import org.jboss.migration.core.ServerMigrationTaskName;
import org.jboss.migration.core.ServerMigrationTaskResult;
import org.jboss.migration.wfly10.config.management.ExtensionsManagement;
import org.jboss.migration.wfly10.config.task.executor.ExtensionsManagementSubtaskExecutor;

public class RemoveExtension<S>
implements ExtensionsManagementSubtaskExecutor<S> {
    private final String extensionModule;

    public RemoveExtension(String extensionModule) {
        this.extensionModule = extensionModule;
    }

    @Override
    public void executeSubtasks(S source, final ExtensionsManagement extensionsManagement, ServerMigrationTaskContext context) throws Exception {
        final ServerMigrationTaskName taskName = new ServerMigrationTaskName.Builder("remove-extension").addAttribute("name", this.extensionModule).build();
        ServerMigrationTask task = new ServerMigrationTask(){

            public ServerMigrationTaskName getName() {
                return taskName;
            }

            public ServerMigrationTaskResult run(ServerMigrationTaskContext context) throws Exception {
                if (extensionsManagement.getResourceNames().contains(RemoveExtension.this.extensionModule)) {
                    context.getLogger().debugf("Removing Extension %s...", (Object)RemoveExtension.this.extensionModule);
                    ModelNode op = Util.createRemoveOperation((PathAddress)extensionsManagement.getResourcePathAddress(RemoveExtension.this.extensionModule));
                    extensionsManagement.getServerConfiguration().executeManagementOperation(op);
                    context.getLogger().infof("Extension %s removed.", (Object)RemoveExtension.this.extensionModule);
                    return ServerMigrationTaskResult.SUCCESS;
                }
                context.getLogger().debugf("Skipped extension %s removal, doesn't exists in config.", (Object)RemoveExtension.this.extensionModule);
                return ServerMigrationTaskResult.SKIPPED;
            }
        };
        context.execute(task);
    }
}

