/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.subsystem;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jboss.migration.wfly10.config.task.subsystem.Extension;
import org.jboss.migration.wfly10.config.task.subsystem.ExtensionBuilder;
import org.jboss.migration.wfly10.config.task.subsystem.LegacyExtensionBuilder;

public class SupportedExtensions {
    public static final Extension JACORB = new LegacyExtensionBuilder("org.jboss.as.jacorb").addMigratedSubsystem("jacorb").build();
    public static final Extension WEB = new LegacyExtensionBuilder("org.jboss.as.web").addMigratedSubsystem("web").build();
    public static final Extension MESSAGING = new LegacyExtensionBuilder("org.jboss.as.messaging").addMigratedSubsystem("messaging").build();
    public static final Extension INFINISPAN = new ExtensionBuilder("org.jboss.as.clustering.infinispan").addSupportedSubsystem("infinispan").build();
    public static final Extension JGROUPS = new ExtensionBuilder("org.jboss.as.clustering.jgroups").addSupportedSubsystem("jgroups").build();
    public static final Extension CONNECTOR = new ExtensionBuilder("org.jboss.as.connector").addSupportedSubsystem("datasources").addSupportedSubsystem("jca").addSupportedSubsystem("resource-adapters").build();
    public static final Extension DEPLOYMENT_SCANNER = new ExtensionBuilder("org.jboss.as.deployment-scanner").addSupportedSubsystem("deployment-scanner").build();
    public static final Extension EE = new ExtensionBuilder("org.jboss.as.ee").addSupportedSubsystem("ee").build();
    public static final Extension EJB3 = new ExtensionBuilder("org.jboss.as.ejb3").addSupportedSubsystem("ejb3").build();
    public static final Extension JAXRS = new ExtensionBuilder("org.jboss.as.jaxrs").addSupportedSubsystem("jaxrs").build();
    public static final Extension JDR = new ExtensionBuilder("org.jboss.as.jdr").addSupportedSubsystem("jdr").build();
    public static final Extension JMX = new ExtensionBuilder("org.jboss.as.jmx").addSupportedSubsystem("jmx").build();
    public static final Extension JPA = new ExtensionBuilder("org.jboss.as.jpa").addSupportedSubsystem("jpa").build();
    public static final Extension JSF = new ExtensionBuilder("org.jboss.as.jsf").addSupportedSubsystem("jsf").build();
    public static final Extension JSR77 = new ExtensionBuilder("org.jboss.as.jsr77").addSupportedSubsystem("jsr77").build();
    public static final Extension LOGGING = new ExtensionBuilder("org.jboss.as.logging").addSupportedSubsystem("logging").build();
    public static final Extension MAIL = new ExtensionBuilder("org.jboss.as.mail").addSupportedSubsystem("mail").build();
    public static final Extension MODCLUSTER = new ExtensionBuilder("org.jboss.as.modcluster").addSupportedSubsystem("modcluster").build();
    public static final Extension NAMING = new ExtensionBuilder("org.jboss.as.naming").addSupportedSubsystem("naming").build();
    public static final Extension POJO = new ExtensionBuilder("org.jboss.as.pojo").addSupportedSubsystem("pojo").build();
    public static final Extension REMOTING = new ExtensionBuilder("org.jboss.as.remoting").addSupportedSubsystem("remoting").build();
    public static final Extension SAR = new ExtensionBuilder("org.jboss.as.sar").addSupportedSubsystem("sar").build();
    public static final Extension SECURITY = new ExtensionBuilder("org.jboss.as.security").addSupportedSubsystem("security").build();
    public static final Extension TRANSACTIONS = new ExtensionBuilder("org.jboss.as.transactions").addSupportedSubsystem("transactions").build();
    public static final Extension WEBSERVICES = new ExtensionBuilder("org.jboss.as.webservices").addSupportedSubsystem("webservices").build();
    public static final Extension WELD = new ExtensionBuilder("org.jboss.as.weld").addSupportedSubsystem("weld").build();
    public static final Extension BATCH_JBERET = new ExtensionBuilder("org.wildfly.extension.batch.jberet").addSupportedSubsystem("batch-jberet").build();
    public static final Extension BEAN_VALIDATION = new ExtensionBuilder("org.wildfly.extension.bean-validation").addSupportedSubsystem("bean-validation").build();
    public static final Extension SINGLETON = new ExtensionBuilder("org.wildfly.extension.clustering.singleton").addSupportedSubsystem("singleton").build();
    public static final Extension IO = new ExtensionBuilder("org.wildfly.extension.io").addSupportedSubsystem("io").build();
    public static final Extension MESSAGING_ACTIVEMQ = new ExtensionBuilder("org.wildfly.extension.messaging-activemq").addSupportedSubsystem("messaging-activemq").build();
    public static final Extension REQUEST_CONTROLLER = new ExtensionBuilder("org.wildfly.extension.request-controller").addSupportedSubsystem("request-controller").build();
    public static final Extension SECURITY_MANAGER = new ExtensionBuilder("org.wildfly.extension.security.manager").addSupportedSubsystem("security-manager").build();
    public static final Extension UNDERTOW = new ExtensionBuilder("org.wildfly.extension.undertow").addSupportedSubsystem("undertow").build();
    public static final Extension IIOP_OPENJDK = new ExtensionBuilder("org.wildfly.iiop-openjdk").addSupportedSubsystem("iiop-openjdk").build();

    public static List<Extension> all() {
        ArrayList<Extension> result = new ArrayList<Extension>();
        result.add(CONNECTOR);
        result.add(DEPLOYMENT_SCANNER);
        result.add(EE);
        result.add(EJB3);
        result.add(IIOP_OPENJDK);
        result.add(JACORB);
        result.add(JAXRS);
        result.add(JDR);
        result.add(JGROUPS);
        result.add(JMX);
        result.add(JPA);
        result.add(JSF);
        result.add(JSR77);
        result.add(LOGGING);
        result.add(MAIL);
        result.add(MESSAGING);
        result.add(MODCLUSTER);
        result.add(NAMING);
        result.add(POJO);
        result.add(REMOTING);
        result.add(SAR);
        result.add(SECURITY);
        result.add(TRANSACTIONS);
        result.add(WEBSERVICES);
        result.add(BATCH_JBERET);
        result.add(BEAN_VALIDATION);
        result.add(SINGLETON);
        result.add(INFINISPAN);
        result.add(IO);
        result.add(MESSAGING_ACTIVEMQ);
        result.add(REQUEST_CONTROLLER);
        result.add(SECURITY_MANAGER);
        result.add(UNDERTOW);
        result.add(WEB);
        result.add(WELD);
        return Collections.unmodifiableList(result);
    }

    public static List<Extension> allExcept(String ... extensionNames) {
        HashSet<String> excludeSet = new HashSet<String>();
        for (String extensionName : extensionNames) {
            excludeSet.add(extensionName);
        }
        ArrayList<Extension> result = new ArrayList<Extension>();
        for (Extension extension : SupportedExtensions.all()) {
            if (excludeSet.contains(extension.getName())) continue;
            result.add(extension);
        }
        return Collections.unmodifiableList(result);
    }
}

