/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.subsystem;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.ParentServerMigrationTask;
import org.jboss.migration.core.ServerMigrationTask;
import org.jboss.migration.core.ServerMigrationTaskContext;
import org.jboss.migration.core.ServerMigrationTaskName;
import org.jboss.migration.core.ServerMigrationTaskResult;
import org.jboss.migration.core.env.Environment;
import org.jboss.migration.core.env.TaskEnvironment;
import org.jboss.migration.wfly10.config.management.HostConfiguration;
import org.jboss.migration.wfly10.config.management.HostControllerConfiguration;
import org.jboss.migration.wfly10.config.management.StandaloneServerConfiguration;
import org.jboss.migration.wfly10.config.management.SubsystemsManagement;
import org.jboss.migration.wfly10.config.task.executor.SubsystemsManagementSubtaskExecutor;
import org.jboss.migration.wfly10.config.task.executor.SubtaskExecutorAdapters;
import org.jboss.migration.wfly10.config.task.factory.DomainConfigurationTaskFactory;
import org.jboss.migration.wfly10.config.task.factory.HostConfigurationTaskFactory;
import org.jboss.migration.wfly10.config.task.factory.StandaloneServerConfigurationTaskFactory;
import org.jboss.migration.wfly10.config.task.subsystem.EnvironmentProperties;

public class UpdateSubsystemTaskFactory<S>
implements StandaloneServerConfigurationTaskFactory<S>,
DomainConfigurationTaskFactory<S>,
HostConfigurationTaskFactory<S> {
    private final String name;
    private final String taskName;
    private final String extension;
    protected final List<SubtaskFactory> subsystemMigrationTasks;

    public UpdateSubsystemTaskFactory(Builder builder) {
        this.name = builder.name;
        this.taskName = builder.taskName != null ? builder.taskName : "update-subsystem";
        this.extension = builder.extension;
        this.subsystemMigrationTasks = Collections.unmodifiableList(builder.tasks);
    }

    public String getExtension() {
        return this.extension;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public ServerMigrationTask getTask(S source, HostControllerConfiguration configuration) throws Exception {
        return this.getTask(SubtaskExecutorAdapters.of(source, configuration, new SubtaskExecutor()));
    }

    @Override
    public ServerMigrationTask getTask(S source, HostConfiguration configuration) throws Exception {
        return this.getTask(SubtaskExecutorAdapters.of(source, configuration, new SubtaskExecutor()));
    }

    @Override
    public ServerMigrationTask getTask(S source, StandaloneServerConfiguration configuration) throws Exception {
        return this.getTask(SubtaskExecutorAdapters.of(source, configuration, new SubtaskExecutor()));
    }

    protected ServerMigrationTask getTask(final ParentServerMigrationTask.SubtaskExecutor subtaskExecutor) throws Exception {
        if (this.subsystemMigrationTasks == null || this.subsystemMigrationTasks.isEmpty()) {
            return null;
        }
        final ServerMigrationTaskName serverMigrationTaskName = new ServerMigrationTaskName.Builder(this.taskName).addAttribute("name", this.name).build();
        return new ServerMigrationTask(){

            public ServerMigrationTaskName getName() {
                return serverMigrationTaskName;
            }

            public ServerMigrationTaskResult run(ServerMigrationTaskContext context) throws Exception {
                if (UpdateSubsystemTaskFactory.this.skipExecution(context)) {
                    return ServerMigrationTaskResult.SKIPPED;
                }
                context.getLogger().infof("Updating subsystem %s configurations...", (Object)UpdateSubsystemTaskFactory.this.name);
                subtaskExecutor.executeSubtasks(context);
                context.getLogger().infof("Subsystem %s configurations updated.", (Object)UpdateSubsystemTaskFactory.this.name);
                return context.hasSucessfulSubtasks() ? ServerMigrationTaskResult.SUCCESS : ServerMigrationTaskResult.SKIPPED;
            }
        };
    }

    protected boolean skipExecution(ServerMigrationTaskContext context) {
        return new TaskEnvironment((Environment)context.getServerMigrationContext().getMigrationEnvironment(), EnvironmentProperties.getSubsystemTaskPropertiesPrefix(this.name)).isSkippedByEnvironment();
    }

    public static abstract class Subtask
    implements ServerMigrationTask {
        private final ModelNode config;
        private final UpdateSubsystemTaskFactory subsystem;
        private final SubsystemsManagement subsystemsManagement;

        protected Subtask(ModelNode config, UpdateSubsystemTaskFactory subsystem, SubsystemsManagement subsystemsManagement) {
            this.config = config;
            this.subsystem = subsystem;
            this.subsystemsManagement = subsystemsManagement;
        }

        public ServerMigrationTaskResult run(ServerMigrationTaskContext context) throws Exception {
            TaskEnvironment taskEnvironment = new TaskEnvironment((Environment)context.getServerMigrationContext().getMigrationEnvironment(), EnvironmentProperties.getSubsystemSubtaskPropertiesPrefix(this.subsystem.getName(), this.getName().getName()));
            if (taskEnvironment.isSkippedByEnvironment()) {
                return ServerMigrationTaskResult.SKIPPED;
            }
            return this.run(this.config, this.subsystem, this.subsystemsManagement, context, taskEnvironment);
        }

        protected abstract ServerMigrationTaskResult run(ModelNode var1, UpdateSubsystemTaskFactory var2, SubsystemsManagement var3, ServerMigrationTaskContext var4, TaskEnvironment var5) throws Exception;
    }

    public static class Builder {
        private final List<SubtaskFactory> tasks = new ArrayList<SubtaskFactory>();
        private final String extension;
        private final String name;
        private String taskName;

        public Builder(String name, String extension) {
            this.name = name;
            this.extension = extension;
        }

        public Builder taskName(String taskName) {
            this.taskName = taskName;
            return this;
        }

        public Builder subtask(SubtaskFactory subtaskFactory) {
            this.tasks.add(subtaskFactory);
            return this;
        }

        public Builder subtasks(SubtaskFactory ... subtaskFactories) {
            for (SubtaskFactory subtaskFactory : subtaskFactories) {
                this.subtask(subtaskFactory);
            }
            return this;
        }

        public UpdateSubsystemTaskFactory build() {
            return new UpdateSubsystemTaskFactory(this);
        }
    }

    public static interface SubtaskFactory {
        public ServerMigrationTask getServerMigrationTask(ModelNode var1, UpdateSubsystemTaskFactory var2, SubsystemsManagement var3);
    }

    class SubtaskExecutor<S>
    implements SubsystemsManagementSubtaskExecutor<S> {
        SubtaskExecutor() {
        }

        @Override
        public void executeSubtasks(S source, SubsystemsManagement subsystemsManagement, ServerMigrationTaskContext context) throws Exception {
            String configName = subsystemsManagement.getResourcePathAddress(UpdateSubsystemTaskFactory.this.name).toCLIStyleString();
            ModelNode subsystemConfig = subsystemsManagement.getResource(UpdateSubsystemTaskFactory.this.name);
            if (subsystemConfig != null) {
                context.getLogger().infof("Updating subsystem %s configuration...", (Object)configName);
            }
            for (SubtaskFactory subsystemMigrationTaskFactory : UpdateSubsystemTaskFactory.this.subsystemMigrationTasks) {
                context.execute(subsystemMigrationTaskFactory.getServerMigrationTask(subsystemConfig, UpdateSubsystemTaskFactory.this, subsystemsManagement));
            }
            if (subsystemConfig != null) {
                context.getLogger().infof("Subsystem %s configuration updated.", (Object)configName);
            }
        }
    }
}

