/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.subsystem.ejb3;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.ServerMigrationTask;
import org.jboss.migration.core.ServerMigrationTaskContext;
import org.jboss.migration.core.ServerMigrationTaskName;
import org.jboss.migration.core.ServerMigrationTaskResult;
import org.jboss.migration.core.env.TaskEnvironment;
import org.jboss.migration.wfly10.config.management.ManageableServerConfiguration;
import org.jboss.migration.wfly10.config.management.SubsystemsManagement;
import org.jboss.migration.wfly10.config.task.subsystem.UpdateSubsystemTaskFactory;

public class AddInfinispanPassivationStoreAndDistributableCache
implements UpdateSubsystemTaskFactory.SubtaskFactory {
    public static final AddInfinispanPassivationStoreAndDistributableCache INSTANCE = new AddInfinispanPassivationStoreAndDistributableCache();
    public static final ServerMigrationTaskName SERVER_MIGRATION_TASK_NAME = new ServerMigrationTaskName.Builder("add-infinispan-passivation-store-and-distributable-cache").build();
    private static final String CLUSTER_PASSIVATION_STORE = "cluster-passivation-store";
    private static final String FILE_PASSIVATION_STORE = "file-passivation-store";
    private static final String FILE_PASSIVATION_STORE_NAME = "file";
    private static final String PASSIVATION_STORE = "passivation-store";
    private static final String PASSIVATION_STORE_NAME = "infinispan";
    private static final String CACHE_CONTAINER_ATTR_NAME = "cache-container";
    private static final String CACHE_CONTAINER_ATTR_VALUE = "ejb";
    private static final String MAX_SIZE_ATTR_NAME = "max-size";
    private static final String MAX_SIZE_ATTR_VALUE = "10000";
    private static final String CACHE = "cache";
    private static final String CACHE_NAME_DISTRIBUTABLE = "distributable";
    private static final String CACHE_NAME_PASSIVATING = "passivating";
    private static final String CACHE_NAME_CLUSTERED = "clustered";
    private static final String ALIASES_ATTR_NAME = "aliases";
    private static final String[] ALIASES_ATTR_VALUE = new String[]{"passivating", "clustered"};
    public static final String TASK_RESULT_ATTR_LEGACY_FILE_PASSIVATION_STORE_REMOVED = "legacy-file-passivation-store-removed";
    public static final String TASK_RESULT_ATTR_LEGACY_CLUSTERED_PASSIVATION_STORE_REMOVED = "legacy-clustered-passivation-store-removed";
    public static final String TASK_RESULT_ATTR_INFINISPAN_PASSIVATION_STORE_ADDED = "infinispan-passivation-store-added";
    public static final String TASK_RESULT_ATTR_LEGACY_PASSIVATING_CACHE_REMOVED = "legacy-passivating-cache-removed";
    public static final String TASK_RESULT_ATTR_LEGACY_CLUSTERED_CACHE_REMOVED = "legacy-clustered-cache-removed";
    public static final String TASK_RESULT_ATTR_DISTRIBUTABLE_CACHE_ADDED = "distributable-cache-added";

    private AddInfinispanPassivationStoreAndDistributableCache() {
    }

    @Override
    public ServerMigrationTask getServerMigrationTask(ModelNode config, UpdateSubsystemTaskFactory subsystem, SubsystemsManagement subsystemsManagement) {
        return new UpdateSubsystemTaskFactory.Subtask(config, subsystem, subsystemsManagement){

            public ServerMigrationTaskName getName() {
                return SERVER_MIGRATION_TASK_NAME;
            }

            @Override
            protected ServerMigrationTaskResult run(ModelNode config, UpdateSubsystemTaskFactory subsystem, SubsystemsManagement subsystemsManagement, ServerMigrationTaskContext context, TaskEnvironment taskEnvironment) throws Exception {
                if (config == null) {
                    return ServerMigrationTaskResult.SKIPPED;
                }
                PathAddress subsystemPathAddress = subsystemsManagement.getResourcePathAddress(subsystem.getName());
                ManageableServerConfiguration configurationManagement = subsystemsManagement.getServerConfiguration();
                ServerMigrationTaskResult.Builder taskResultBuilder = new ServerMigrationTaskResult.Builder();
                boolean legacyFilePassivationStoreRemoved = false;
                boolean legacyClusteredPassivationStoreRemoved = false;
                boolean infinispanPassivationStoreAdded = false;
                boolean legacyPassivatingCacheRemoved = false;
                boolean legacyClusteredCacheRemoved = false;
                boolean distributableCacheAdded = false;
                boolean configUpdated = false;
                if (!config.hasDefined(new String[]{AddInfinispanPassivationStoreAndDistributableCache.PASSIVATION_STORE, AddInfinispanPassivationStoreAndDistributableCache.PASSIVATION_STORE_NAME})) {
                    ModelNode filePassivationStoreRemoveperation;
                    PathAddress filePassivationStorePathAddress;
                    if (config.hasDefined(new String[]{AddInfinispanPassivationStoreAndDistributableCache.FILE_PASSIVATION_STORE, AddInfinispanPassivationStoreAndDistributableCache.FILE_PASSIVATION_STORE_NAME})) {
                        filePassivationStorePathAddress = subsystemPathAddress.append(new PathElement[]{PathElement.pathElement((String)AddInfinispanPassivationStoreAndDistributableCache.FILE_PASSIVATION_STORE, (String)AddInfinispanPassivationStoreAndDistributableCache.FILE_PASSIVATION_STORE_NAME)});
                        filePassivationStoreRemoveperation = Util.createRemoveOperation((PathAddress)filePassivationStorePathAddress);
                        configurationManagement.executeManagementOperation(filePassivationStoreRemoveperation);
                        context.getLogger().infof("Legacy file passivation store removed from EJB3 subsystem configuration.", new Object[0]);
                        legacyFilePassivationStoreRemoved = true;
                    }
                    if (config.hasDefined(new String[]{AddInfinispanPassivationStoreAndDistributableCache.CLUSTER_PASSIVATION_STORE, AddInfinispanPassivationStoreAndDistributableCache.PASSIVATION_STORE_NAME})) {
                        filePassivationStorePathAddress = subsystemPathAddress.append(new PathElement[]{PathElement.pathElement((String)AddInfinispanPassivationStoreAndDistributableCache.CLUSTER_PASSIVATION_STORE, (String)AddInfinispanPassivationStoreAndDistributableCache.PASSIVATION_STORE_NAME)});
                        filePassivationStoreRemoveperation = Util.createRemoveOperation((PathAddress)filePassivationStorePathAddress);
                        configurationManagement.executeManagementOperation(filePassivationStoreRemoveperation);
                        context.getLogger().infof("Legacy 'clustered' passivation store removed from EJB3 subsystem configuration.", new Object[0]);
                        legacyClusteredPassivationStoreRemoved = true;
                    }
                    PathAddress passivationStorePathAddress = subsystemPathAddress.append(new PathElement[]{PathElement.pathElement((String)AddInfinispanPassivationStoreAndDistributableCache.PASSIVATION_STORE, (String)AddInfinispanPassivationStoreAndDistributableCache.PASSIVATION_STORE_NAME)});
                    ModelNode passivationStoreAddOperation = Util.createAddOperation((PathAddress)passivationStorePathAddress);
                    passivationStoreAddOperation.get(AddInfinispanPassivationStoreAndDistributableCache.CACHE_CONTAINER_ATTR_NAME).set(AddInfinispanPassivationStoreAndDistributableCache.CACHE_CONTAINER_ATTR_VALUE);
                    passivationStoreAddOperation.get(AddInfinispanPassivationStoreAndDistributableCache.MAX_SIZE_ATTR_NAME).set(AddInfinispanPassivationStoreAndDistributableCache.MAX_SIZE_ATTR_VALUE);
                    configurationManagement.executeManagementOperation(passivationStoreAddOperation);
                    configUpdated = true;
                    context.getLogger().infof("Infinispan passivation store added to EJB3 subsystem configuration.", new Object[0]);
                    infinispanPassivationStoreAdded = true;
                }
                if (!config.hasDefined(new String[]{AddInfinispanPassivationStoreAndDistributableCache.CACHE, AddInfinispanPassivationStoreAndDistributableCache.CACHE_NAME_DISTRIBUTABLE})) {
                    ModelNode cacheRemoveOperation;
                    PathAddress cachePathAddress;
                    if (config.hasDefined(new String[]{AddInfinispanPassivationStoreAndDistributableCache.CACHE, AddInfinispanPassivationStoreAndDistributableCache.CACHE_NAME_PASSIVATING})) {
                        cachePathAddress = subsystemPathAddress.append(new PathElement[]{PathElement.pathElement((String)AddInfinispanPassivationStoreAndDistributableCache.CACHE, (String)AddInfinispanPassivationStoreAndDistributableCache.CACHE_NAME_PASSIVATING)});
                        cacheRemoveOperation = Util.createRemoveOperation((PathAddress)cachePathAddress);
                        configurationManagement.executeManagementOperation(cacheRemoveOperation);
                        context.getLogger().infof("Legacy 'passivating' cache removed from EJB3 subsystem configuration.", new Object[0]);
                        legacyPassivatingCacheRemoved = true;
                    }
                    if (config.hasDefined(new String[]{AddInfinispanPassivationStoreAndDistributableCache.CACHE, AddInfinispanPassivationStoreAndDistributableCache.CACHE_NAME_CLUSTERED})) {
                        cachePathAddress = subsystemPathAddress.append(new PathElement[]{PathElement.pathElement((String)AddInfinispanPassivationStoreAndDistributableCache.CACHE, (String)AddInfinispanPassivationStoreAndDistributableCache.CACHE_NAME_CLUSTERED)});
                        cacheRemoveOperation = Util.createRemoveOperation((PathAddress)cachePathAddress);
                        configurationManagement.executeManagementOperation(cacheRemoveOperation);
                        context.getLogger().infof("Legacy 'clustered' cache removed from EJB3 subsystem configuration.", new Object[0]);
                        legacyClusteredCacheRemoved = true;
                    }
                    cachePathAddress = subsystemPathAddress.append(new PathElement[]{PathElement.pathElement((String)AddInfinispanPassivationStoreAndDistributableCache.CACHE, (String)AddInfinispanPassivationStoreAndDistributableCache.CACHE_NAME_DISTRIBUTABLE)});
                    ModelNode cacheAddOperation = Util.createAddOperation((PathAddress)cachePathAddress);
                    cacheAddOperation.get(AddInfinispanPassivationStoreAndDistributableCache.PASSIVATION_STORE).set(AddInfinispanPassivationStoreAndDistributableCache.PASSIVATION_STORE_NAME);
                    for (String alias : ALIASES_ATTR_VALUE) {
                        cacheAddOperation.get(AddInfinispanPassivationStoreAndDistributableCache.ALIASES_ATTR_NAME).add(alias);
                    }
                    configurationManagement.executeManagementOperation(cacheAddOperation);
                    configUpdated = true;
                    context.getLogger().infof("Distributable cache added to EJB3 subsystem configuration.", new Object[0]);
                    distributableCacheAdded = true;
                }
                if (configUpdated) {
                    taskResultBuilder.sucess();
                } else {
                    taskResultBuilder.skipped();
                }
                return taskResultBuilder.addAttribute(AddInfinispanPassivationStoreAndDistributableCache.TASK_RESULT_ATTR_LEGACY_FILE_PASSIVATION_STORE_REMOVED, (Object)legacyFilePassivationStoreRemoved).addAttribute(AddInfinispanPassivationStoreAndDistributableCache.TASK_RESULT_ATTR_LEGACY_CLUSTERED_PASSIVATION_STORE_REMOVED, (Object)legacyClusteredPassivationStoreRemoved).addAttribute(AddInfinispanPassivationStoreAndDistributableCache.TASK_RESULT_ATTR_INFINISPAN_PASSIVATION_STORE_ADDED, (Object)infinispanPassivationStoreAdded).addAttribute(AddInfinispanPassivationStoreAndDistributableCache.TASK_RESULT_ATTR_LEGACY_PASSIVATING_CACHE_REMOVED, (Object)legacyPassivatingCacheRemoved).addAttribute(AddInfinispanPassivationStoreAndDistributableCache.TASK_RESULT_ATTR_LEGACY_CLUSTERED_CACHE_REMOVED, (Object)legacyClusteredCacheRemoved).addAttribute(AddInfinispanPassivationStoreAndDistributableCache.TASK_RESULT_ATTR_DISTRIBUTABLE_CACHE_ADDED, (Object)distributableCacheAdded).build();
            }
        };
    }
}

