/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.subsystem.infinispan;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.ServerMigrationTask;
import org.jboss.migration.core.ServerMigrationTaskContext;
import org.jboss.migration.core.ServerMigrationTaskName;
import org.jboss.migration.core.ServerMigrationTaskResult;
import org.jboss.migration.core.env.TaskEnvironment;
import org.jboss.migration.wfly10.config.management.ManageableServerConfiguration;
import org.jboss.migration.wfly10.config.management.SubsystemsManagement;
import org.jboss.migration.wfly10.config.task.subsystem.UpdateSubsystemTaskFactory;

public class AddServerCache
implements UpdateSubsystemTaskFactory.SubtaskFactory {
    public static final AddServerCache INSTANCE = new AddServerCache();
    public static final ServerMigrationTaskName SERVER_MIGRATION_TASK_NAME = new ServerMigrationTaskName.Builder("add-infinispan-server-cache").build();
    private static final String CACHE_CONTAINER = "cache-container";
    private static final String CACHE_NAME = "server";
    private static final String DEFAULT_CACHE_ATTR_NAME = "default-cache";
    private static final String DEFAULT_CACHE_ATTR_VALUE = "default";
    private static final String MODULE_ATTR_NAME = "module";
    private static final String MODULE_ATTR_VALUE = "org.wildfly.clustering.server";
    private static final String LOCAL_CACHE = "local-cache";
    private static final String LOCAL_CACHE_NAME = "default";
    private static final String COMPONENT = "component";
    private static final String COMPONENT_NAME = "transaction";
    private static final String MODE_ATTR_NAME = "mode";
    private static final String MODE_ATTR_VALUE = "BATCH";

    private AddServerCache() {
    }

    @Override
    public ServerMigrationTask getServerMigrationTask(ModelNode config, UpdateSubsystemTaskFactory subsystem, SubsystemsManagement subsystemsManagement) {
        return new UpdateSubsystemTaskFactory.Subtask(config, subsystem, subsystemsManagement){

            public ServerMigrationTaskName getName() {
                return SERVER_MIGRATION_TASK_NAME;
            }

            @Override
            protected ServerMigrationTaskResult run(ModelNode config, UpdateSubsystemTaskFactory subsystem, SubsystemsManagement subsystemsManagement, ServerMigrationTaskContext context, TaskEnvironment taskEnvironment) throws Exception {
                if (config == null) {
                    return ServerMigrationTaskResult.SKIPPED;
                }
                if (!config.hasDefined(AddServerCache.CACHE_CONTAINER)) {
                    context.getLogger().infof("No Cache container", new Object[0]);
                    return ServerMigrationTaskResult.SKIPPED;
                }
                if (config.hasDefined(new String[]{AddServerCache.CACHE_CONTAINER, AddServerCache.CACHE_NAME})) {
                    return ServerMigrationTaskResult.SKIPPED;
                }
                PathAddress subsystemPathAddress = subsystemsManagement.getResourcePathAddress(subsystem.getName());
                ManageableServerConfiguration configurationManagement = subsystemsManagement.getServerConfiguration();
                Operations.CompositeOperationBuilder compositeOperationBuilder = Operations.CompositeOperationBuilder.create();
                PathAddress cachePathAddress = subsystemPathAddress.append(new PathElement[]{PathElement.pathElement((String)AddServerCache.CACHE_CONTAINER, (String)AddServerCache.CACHE_NAME)});
                ModelNode cacheAddOperation = Util.createAddOperation((PathAddress)cachePathAddress);
                cacheAddOperation.get(AddServerCache.DEFAULT_CACHE_ATTR_NAME).set("default");
                cacheAddOperation.get(AddServerCache.MODULE_ATTR_NAME).set(AddServerCache.MODULE_ATTR_VALUE);
                compositeOperationBuilder.addStep(cacheAddOperation);
                PathAddress localCachePathAddress = cachePathAddress.append(AddServerCache.LOCAL_CACHE, "default");
                ModelNode localCacheAddOperation = Util.createAddOperation((PathAddress)localCachePathAddress);
                compositeOperationBuilder.addStep(localCacheAddOperation);
                PathAddress localCacheTransactionPathAddress = localCachePathAddress.append(AddServerCache.COMPONENT, AddServerCache.COMPONENT_NAME);
                ModelNode localCacheTransactionAddOperation = Util.createAddOperation((PathAddress)localCacheTransactionPathAddress);
                localCacheTransactionAddOperation.get(AddServerCache.MODE_ATTR_NAME).set(AddServerCache.MODE_ATTR_VALUE);
                compositeOperationBuilder.addStep(localCacheTransactionAddOperation);
                configurationManagement.executeManagementOperation(compositeOperationBuilder.build().getOperation());
                context.getLogger().infof("Server cache added to Infinispan subsystem configuration.", new Object[0]);
                return ServerMigrationTaskResult.SUCCESS;
            }
        };
    }
}

