/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.subsystem.undertow;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.ServerMigrationTask;
import org.jboss.migration.core.ServerMigrationTaskContext;
import org.jboss.migration.core.ServerMigrationTaskName;
import org.jboss.migration.core.ServerMigrationTaskResult;
import org.jboss.migration.core.env.TaskEnvironment;
import org.jboss.migration.wfly10.config.management.SubsystemsManagement;
import org.jboss.migration.wfly10.config.task.subsystem.UpdateSubsystemTaskFactory;

public class AddBufferCache
implements UpdateSubsystemTaskFactory.SubtaskFactory {
    public static final AddBufferCache INSTANCE = new AddBufferCache();
    public static final ServerMigrationTaskName SERVER_MIGRATION_TASK_NAME = new ServerMigrationTaskName.Builder("add-undertow-default-buffer-cache").build();
    private static final String BUFFER_CACHE = "buffer-cache";
    private static final String BUFFER_CACHE_NAME = "default";

    private AddBufferCache() {
    }

    @Override
    public ServerMigrationTask getServerMigrationTask(ModelNode config, UpdateSubsystemTaskFactory subsystem, SubsystemsManagement subsystemsManagement) {
        return new UpdateSubsystemTaskFactory.Subtask(config, subsystem, subsystemsManagement){

            public ServerMigrationTaskName getName() {
                return SERVER_MIGRATION_TASK_NAME;
            }

            @Override
            protected ServerMigrationTaskResult run(ModelNode config, UpdateSubsystemTaskFactory subsystem, SubsystemsManagement subsystemsManagement, ServerMigrationTaskContext context, TaskEnvironment taskEnvironment) throws Exception {
                if (config == null) {
                    return ServerMigrationTaskResult.SKIPPED;
                }
                if (!config.hasDefined(new String[]{AddBufferCache.BUFFER_CACHE, AddBufferCache.BUFFER_CACHE_NAME})) {
                    PathAddress pathAddress = subsystemsManagement.getResourcePathAddress(subsystem.getName()).append(new PathElement[]{PathElement.pathElement((String)AddBufferCache.BUFFER_CACHE, (String)AddBufferCache.BUFFER_CACHE_NAME)});
                    ModelNode addOp = Util.createEmptyOperation((String)"add", (PathAddress)pathAddress);
                    subsystemsManagement.getServerConfiguration().executeManagementOperation(addOp);
                    context.getLogger().infof("Undertow's default buffer cache added.", new Object[0]);
                    return ServerMigrationTaskResult.SUCCESS;
                }
                return ServerMigrationTaskResult.SKIPPED;
            }
        };
    }
}

