/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.update;

import java.util.ArrayList;
import java.util.Set;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ValueExpression;
import org.jboss.migration.core.ParentServerMigrationTask;
import org.jboss.migration.core.ServerMigrationTask;
import org.jboss.migration.core.ServerMigrationTaskContext;
import org.jboss.migration.core.ServerMigrationTaskName;
import org.jboss.migration.core.ServerMigrationTaskResult;
import org.jboss.migration.core.env.SkippableByEnvServerMigrationTask;
import org.jboss.migration.wfly10.config.management.InterfacesManagement;
import org.jboss.migration.wfly10.config.management.ManageableServerConfiguration;
import org.jboss.migration.wfly10.config.management.SocketBindingGroupManagement;
import org.jboss.migration.wfly10.config.management.SocketBindingGroupsManagement;
import org.jboss.migration.wfly10.config.management.SocketBindingsManagement;
import org.jboss.migration.wfly10.config.task.executor.InterfacesManagementSubtaskExecutor;
import org.jboss.migration.wfly10.config.task.executor.SocketBindingGroupsManagementSubtaskExecutor;
import org.jboss.migration.wfly10.config.task.executor.SubtaskExecutorAdapters;
import org.jboss.migration.wfly10.config.task.factory.ManageableServerConfigurationTaskFactory;

public class AddPrivateInterface<S>
implements ManageableServerConfigurationTaskFactory<S, ManageableServerConfiguration> {
    private static final String INTERFACE_NAME = "private";
    private static final String[] SOCKET_BINDING_NAMES = new String[]{"jgroups-mping", "jgroups-tcp", "jgroups-tcp-fd", "jgroups-udp", "jgroups-udp-fd"};
    private static final String TASK_NAME = "setup-private-interface";
    public static final AddPrivateInterface INSTANCE = new AddPrivateInterface();

    private AddPrivateInterface() {
    }

    @Override
    public ServerMigrationTask getTask(S source, ManageableServerConfiguration configuration) throws Exception {
        ParentServerMigrationTask parentTask = new ParentServerMigrationTask.Builder(new ServerMigrationTaskName.Builder(TASK_NAME).build()).eventListener(new ParentServerMigrationTask.EventListener(){

            public void started(ServerMigrationTaskContext context) {
                context.getLogger().debugf("Private interface setup starting...", new Object[0]);
            }

            public void done(ServerMigrationTaskContext context) {
                context.getLogger().debugf("Private interface setup done.", new Object[0]);
            }
        }).subtask(SubtaskExecutorAdapters.of(source, configuration, new AddInterface())).subtask(SubtaskExecutorAdapters.of(source, configuration, new UpdateSocketBindingGroups())).build();
        return new SkippableByEnvServerMigrationTask((ServerMigrationTask)parentTask, "setup-private-interface.skip");
    }

    static class UpdateSocketBindingGroups<S>
    implements SocketBindingGroupsManagementSubtaskExecutor<S> {
        private static final ServerMigrationTaskName SUBTASK_NAME = new ServerMigrationTaskName.Builder("update-socket-binding-groups").build();

        UpdateSocketBindingGroups() {
        }

        @Override
        public void executeSubtasks(S source, SocketBindingGroupsManagement socketBindingGroupsManagement, ServerMigrationTaskContext context) throws Exception {
            ParentServerMigrationTask.Builder taskBuilder = new ParentServerMigrationTask.Builder(SUBTASK_NAME);
            for (String socketBindingGroupName : socketBindingGroupsManagement.getResourceNames()) {
                ServerMigrationTask subtask = this.getResourceTask(source, socketBindingGroupsManagement.getSocketBindingGroupManagement(socketBindingGroupName));
                if (subtask == null) continue;
                taskBuilder.subtask(subtask);
            }
            context.execute((ServerMigrationTask)new SkippableByEnvServerMigrationTask((ServerMigrationTask)taskBuilder.build(), "setup-private-interface." + SUBTASK_NAME + ".skip"));
        }

        public ServerMigrationTask getResourceTask(S source, final SocketBindingGroupManagement socketBindingGroupManagement) throws Exception {
            final ServerMigrationTaskName subtaskName = new ServerMigrationTaskName.Builder("update-socket-binding-group").addAttribute("name", socketBindingGroupManagement.getSocketBindingGroupName()).build();
            ServerMigrationTask subtask = new ServerMigrationTask(){

                public ServerMigrationTaskName getName() {
                    return subtaskName;
                }

                public ServerMigrationTaskResult run(ServerMigrationTaskContext context) throws Exception {
                    ArrayList<String> updated = new ArrayList<String>();
                    SocketBindingsManagement resourceManagement = socketBindingGroupManagement.getSocketBindingsManagement();
                    for (String socketBinding : SOCKET_BINDING_NAMES) {
                        ModelNode config = resourceManagement.getResource(socketBinding);
                        if (config == null || config.hasDefined("interface") && config.get("interface").asString().equals(AddPrivateInterface.INTERFACE_NAME)) continue;
                        PathAddress pathAddress = resourceManagement.getResourcePathAddress(socketBinding);
                        ModelNode writeAttrOp = Util.createEmptyOperation((String)"write-attribute", (PathAddress)pathAddress);
                        writeAttrOp.get("name").set("interface");
                        writeAttrOp.get("value").set(AddPrivateInterface.INTERFACE_NAME);
                        resourceManagement.getServerConfiguration().executeManagementOperation(writeAttrOp);
                        context.getLogger().infof("Socket binding %s interface set to %s", (Object)pathAddress.toCLIStyleString(), (Object)AddPrivateInterface.INTERFACE_NAME);
                        updated.add(socketBinding);
                    }
                    if (updated.isEmpty()) {
                        return ServerMigrationTaskResult.SKIPPED;
                    }
                    return new ServerMigrationTaskResult.Builder().sucess().addAttribute("updated", (Object)((Object)updated).toString()).build();
                }
            };
            return subtask;
        }
    }

    static class AddInterface<S>
    implements InterfacesManagementSubtaskExecutor<S> {
        private static final ServerMigrationTaskName SUBTASK_NAME = new ServerMigrationTaskName.Builder("add-interface").build();

        AddInterface() {
        }

        @Override
        public void executeSubtasks(S source, final InterfacesManagement interfacesManagement, ServerMigrationTaskContext context) throws Exception {
            ServerMigrationTask task = new ServerMigrationTask(){

                public ServerMigrationTaskName getName() {
                    return SUBTASK_NAME;
                }

                public ServerMigrationTaskResult run(ServerMigrationTaskContext context) throws Exception {
                    if (interfacesManagement.getResourceNames().contains(AddPrivateInterface.INTERFACE_NAME)) {
                        context.getLogger().debugf("Skipping task to add private interface, the configuration already has it.", new Object[0]);
                        return ServerMigrationTaskResult.SKIPPED;
                    }
                    boolean addInterface = false;
                    SocketBindingGroupsManagement socketBindingGroupsManagement = interfacesManagement.getServerConfiguration().getSocketBindingGroupsManagement();
                    for (String socketBindingGroupName : socketBindingGroupsManagement.getResourceNames()) {
                        SocketBindingGroupManagement socketBindingGroupManagement = socketBindingGroupsManagement.getSocketBindingGroupManagement(socketBindingGroupName);
                        Set<String> socketBindings = socketBindingGroupManagement.getSocketBindingsManagement().getResourceNames();
                        for (String jgroupsSocketBinding : SOCKET_BINDING_NAMES) {
                            if (!socketBindings.contains(jgroupsSocketBinding)) continue;
                            addInterface = true;
                            break;
                        }
                        if (!addInterface) continue;
                        break;
                    }
                    if (!addInterface) {
                        context.getLogger().debugf("Skipping task to add private interface, the target socket bindings are not present in the configuration.", new Object[0]);
                        return ServerMigrationTaskResult.SKIPPED;
                    }
                    ModelNode addInterfaceOp = Util.createAddOperation((PathAddress)interfacesManagement.getResourcePathAddress(AddPrivateInterface.INTERFACE_NAME));
                    addInterfaceOp.get("inet-address").set(new ValueExpression("${jboss.bind.address.private:127.0.0.1}"));
                    interfacesManagement.getServerConfiguration().executeManagementOperation(addInterfaceOp);
                    context.getLogger().infof("Interface %s added.", (Object)AddPrivateInterface.INTERFACE_NAME);
                    return ServerMigrationTaskResult.SUCCESS;
                }
            };
            context.execute((ServerMigrationTask)new SkippableByEnvServerMigrationTask(task, "setup-private-interface." + SUBTASK_NAME + ".skip"));
        }
    }
}

