/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.update;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.ParentServerMigrationTask;
import org.jboss.migration.core.ServerMigrationTask;
import org.jboss.migration.core.ServerMigrationTaskContext;
import org.jboss.migration.core.ServerMigrationTaskName;
import org.jboss.migration.core.ServerMigrationTaskResult;
import org.jboss.migration.core.env.SkippableByEnvServerMigrationTask;
import org.jboss.migration.wfly10.config.management.HostConfiguration;
import org.jboss.migration.wfly10.config.management.HostControllerConfiguration;
import org.jboss.migration.wfly10.config.management.JVMsManagement;
import org.jboss.migration.wfly10.config.management.ServerGroupsManagement;
import org.jboss.migration.wfly10.config.task.executor.JVMsManagementSubtaskExecutor;
import org.jboss.migration.wfly10.config.task.factory.DomainConfigurationTaskFactory;
import org.jboss.migration.wfly10.config.task.factory.HostConfigurationTaskFactory;

public class RemovePermgenAttributesFromJVMs<S>
implements HostConfigurationTaskFactory<S>,
DomainConfigurationTaskFactory<S> {
    public static final RemovePermgenAttributesFromJVMs INSTANCE = new RemovePermgenAttributesFromJVMs();
    private static final String TASK_NAME_NAME = "remove-permgen-attributes-from-jvms";
    private static final ServerMigrationTaskName TASK_NAME = new ServerMigrationTaskName.Builder("remove-permgen-attributes-from-jvms").build();

    private RemovePermgenAttributesFromJVMs() {
    }

    @Override
    public ServerMigrationTask getTask(S source, HostConfiguration configuration) throws Exception {
        return this.getTask(this.getSubtasks(source, configuration.getJVMsManagement()));
    }

    protected ServerMigrationTask getTask(ParentServerMigrationTask.SubtaskExecutor subtaskExecutor) throws Exception {
        ParentServerMigrationTask parentTask = new ParentServerMigrationTask.Builder(TASK_NAME).subtask(subtaskExecutor).eventListener(new ParentServerMigrationTask.EventListener(){

            public void started(ServerMigrationTaskContext context) {
                context.getLogger().infof("Removal of permgen attributes from JVM configs starting...", new Object[0]);
            }

            public void done(ServerMigrationTaskContext context) {
                context.getLogger().infof("Removal of permgen attributes from JVM configs done.", new Object[0]);
            }
        }).build();
        return new SkippableByEnvServerMigrationTask((ServerMigrationTask)parentTask, TASK_NAME + ".skip");
    }

    protected ParentServerMigrationTask.SubtaskExecutor getSubtasks(final S source, final JVMsManagement jvMsManagement) throws Exception {
        return new ParentServerMigrationTask.SubtaskExecutor(){

            public void executeSubtasks(ServerMigrationTaskContext context) throws Exception {
                JVMsSubtaskExecutor.INSTANCE.executeSubtasks(source, jvMsManagement, context);
            }
        };
    }

    @Override
    public ServerMigrationTask getTask(S source, HostControllerConfiguration configuration) throws Exception {
        return this.getTask(this.getSubtasks(source, configuration.getServerGroupsManagement()));
    }

    protected ParentServerMigrationTask.SubtaskExecutor getSubtasks(final S source, final ServerGroupsManagement serverGroupsManagement) throws Exception {
        return new ParentServerMigrationTask.SubtaskExecutor(){

            public void executeSubtasks(ServerMigrationTaskContext context) throws Exception {
                for (String serverGroupName : serverGroupsManagement.getResourceNames()) {
                    RemovePermgenAttributesFromJVMs.this.getSubtasks(source, serverGroupsManagement.getServerGroupManagement(serverGroupName).getJVMsManagement()).executeSubtasks(context);
                }
            }
        };
    }

    public static class JVMsSubtaskExecutor<S>
    implements JVMsManagementSubtaskExecutor<S> {
        public static final JVMsSubtaskExecutor INSTANCE = new JVMsSubtaskExecutor();
        private static final String SUBTASK_NAME_NAME = "remove-permgen-attributes-from-jvm";

        private JVMsSubtaskExecutor() {
        }

        @Override
        public void executeSubtasks(S source, final JVMsManagement resourceManagement, ServerMigrationTaskContext context) throws Exception {
            for (final String resourceName : resourceManagement.getResourceNames()) {
                final ServerMigrationTaskName taskName = new ServerMigrationTaskName.Builder(SUBTASK_NAME_NAME).addAttribute("resource", resourceManagement.getResourcePathAddress(resourceName).toCLIStyleString()).build();
                ServerMigrationTask subtask = new ServerMigrationTask(){

                    public ServerMigrationTaskName getName() {
                        return taskName;
                    }

                    public ServerMigrationTaskResult run(ServerMigrationTaskContext context) throws Exception {
                        ModelNode op;
                        ModelNode config = resourceManagement.getResource(resourceName);
                        PathAddress pathAddress = resourceManagement.getResourcePathAddress(resourceName);
                        boolean updated = false;
                        if (config.hasDefined("permgen-size")) {
                            op = Util.getUndefineAttributeOperation((PathAddress)pathAddress, (String)"permgen-size");
                            resourceManagement.getServerConfiguration().executeManagementOperation(op);
                            updated = true;
                        }
                        if (config.hasDefined("max-permgen-size")) {
                            op = Util.getUndefineAttributeOperation((PathAddress)pathAddress, (String)"max-permgen-size");
                            resourceManagement.getServerConfiguration().executeManagementOperation(op);
                            updated = true;
                        }
                        if (!updated) {
                            return ServerMigrationTaskResult.SKIPPED;
                        }
                        context.getLogger().infof("Permgen removed from JVM %s", (Object)pathAddress.toCLIStyleString());
                        return ServerMigrationTaskResult.SUCCESS;
                    }
                };
                context.execute(subtask);
            }
        }
    }
}

