/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.management.extension;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.wfly10.config.management.ManageableServerConfiguration;
import org.jboss.migration.wfly10.config.task.management.configuration.ManageableServerConfigurationLeafTask;

public class AddExtensionTaskBuilder<S>
extends ManageableServerConfigurationLeafTask.Builder<S> {
    public AddExtensionTaskBuilder(String extensionModule) {
        this.name("extension." + extensionModule + ".add");
        this.runBuilder(params -> context -> {
            ManageableServerConfiguration extensionResourceParent = params.getServerConfiguration();
            if (!extensionResourceParent.getExtensionResourceNames().contains(extensionModule)) {
                context.getLogger().debugf("Adding Extension %s...", (Object)extensionModule);
                ModelNode op = Util.createAddOperation((PathAddress)extensionResourceParent.getExtensionResourcePathAddress(extensionModule));
                op.get("module").set(extensionModule);
                extensionResourceParent.getServerConfiguration().executeManagementOperation(op);
                context.getLogger().infof("Extension %s added.", (Object)extensionModule);
                return ServerMigrationTaskResult.SUCCESS;
            }
            context.getLogger().infof("Extension %s already exists in config.", (Object)extensionModule);
            return ServerMigrationTaskResult.SKIPPED;
        });
    }
}

