/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.subsystem.ee;

import java.util.HashMap;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.console.ConsoleWrapper;
import org.jboss.migration.core.console.UserChoiceWithOtherOption;
import org.jboss.migration.core.console.UserConfirmation;
import org.jboss.migration.core.env.MigrationEnvironment;
import org.jboss.migration.core.env.TaskEnvironment;
import org.jboss.migration.core.logger.ServerMigrationLogger;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.TaskContext;
import org.jboss.migration.wfly10.config.management.ManageableServerConfiguration;
import org.jboss.migration.wfly10.config.management.SubsystemResource;
import org.jboss.migration.wfly10.config.task.management.subsystem.UpdateSubsystemResourceSubtaskBuilder;

public class AddDefaultBindingsConfig<S>
extends UpdateSubsystemResourceSubtaskBuilder<S> {
    public static final String TASK_NAME = "setup-javaee7-default-bindings";
    public static final String TASK_RESULT_ATTR_CONTEXT_SERVICE = "default-context-service";
    public static final String TASK_RESULT_ATTR_MANAGED_THREAD_FACTORY = "default-managed-thread-factory";
    public static final String TASK_RESULT_ATTR_MANAGED_EXECUTOR_SERVICE = "default-managed-executor-service";
    public static final String TASK_RESULT_ATTR_MANAGED_SCHEDULED_EXECUTOR_SERVICE = "default-managed-scheduled-executor-service";
    public static final String TASK_RESULT_ATTR_DATA_SOURCE = "default-data-source";
    public static final String TASK_RESULT_ATTR_JMS_CONNECTION_FACTORY = "default-jms-connection-factory";
    private static final String SERVER = "server";
    private static final String CONNECTION_FACTORY = "connection-factory";
    private static final String POOLED_CONNECTION_FACTORY = "pooled-connection-factory";
    private static final String DATA_SOURCE = "data-source";
    private static final String DATA_SOURCE_JNDI_NAME = "jndi-name";

    public AddDefaultBindingsConfig() {
        this.subtaskName(TASK_NAME);
    }

    @Override
    protected ServerMigrationTaskResult updateConfiguration(ModelNode config, S source, SubsystemResource subsystemResource, TaskContext context, TaskEnvironment taskEnvironment) {
        PathAddress subsystemPathAddress = subsystemResource.getResourcePathAddress();
        ManageableServerConfiguration configurationManagement = subsystemResource.getServerConfiguration();
        MigrationEnvironment migrationEnvironment = context.getMigrationEnvironment();
        String defaultDataSourceJndiName = taskEnvironment.getPropertyAsString("defaultDataSourceJndiName");
        String defaultDataSourceName = taskEnvironment.getPropertyAsString("defaultDataSourceName");
        String defaultJmsConnectionFactoryJndiName = taskEnvironment.getPropertyAsString("defaultJmsConnectionFactoryJndiName");
        String defaultJmsConnectionFactoryName = taskEnvironment.getPropertyAsString("defaultJmsConnectionFactoryName");
        ServerMigrationTaskResult.Builder taskResultBuilder = new ServerMigrationTaskResult.Builder();
        PathAddress pathAddress = subsystemPathAddress.append(new PathElement[]{PathElement.pathElement((String)"service", (String)"default-bindings")});
        ModelNode addOp = Util.createEmptyOperation((String)"add", (PathAddress)pathAddress);
        ModelNode eeSubsystemConfig = subsystemResource.getParentResource().getSubsystemResourceConfiguration("ee");
        if (eeSubsystemConfig != null) {
            String jndiName;
            if (eeSubsystemConfig.hasDefined(new String[]{"context-service", "default", DATA_SOURCE_JNDI_NAME})) {
                jndiName = eeSubsystemConfig.get(new String[]{"context-service", "default", DATA_SOURCE_JNDI_NAME}).asString();
                addOp.get("context-service").set(jndiName);
                taskResultBuilder.addAttribute(TASK_RESULT_ATTR_CONTEXT_SERVICE, (Object)jndiName);
            }
            if (eeSubsystemConfig.hasDefined(new String[]{"managed-executor-service", "default", DATA_SOURCE_JNDI_NAME})) {
                jndiName = eeSubsystemConfig.get(new String[]{"managed-executor-service", "default", DATA_SOURCE_JNDI_NAME}).asString();
                addOp.get("managed-executor-service").set(jndiName);
                taskResultBuilder.addAttribute(TASK_RESULT_ATTR_MANAGED_EXECUTOR_SERVICE, (Object)jndiName);
            }
            if (eeSubsystemConfig.hasDefined(new String[]{"managed-scheduled-executor-service", "default", DATA_SOURCE_JNDI_NAME})) {
                jndiName = eeSubsystemConfig.get(new String[]{"managed-scheduled-executor-service", "default", DATA_SOURCE_JNDI_NAME}).asString();
                addOp.get("managed-scheduled-executor-service").set(jndiName);
                taskResultBuilder.addAttribute(TASK_RESULT_ATTR_MANAGED_SCHEDULED_EXECUTOR_SERVICE, (Object)jndiName);
            }
            if (eeSubsystemConfig.hasDefined(new String[]{"managed-thread-factory", "default", DATA_SOURCE_JNDI_NAME})) {
                jndiName = eeSubsystemConfig.get(new String[]{"managed-thread-factory", "default", DATA_SOURCE_JNDI_NAME}).asString();
                addOp.get("managed-thread-factory").set(jndiName);
                taskResultBuilder.addAttribute(TASK_RESULT_ATTR_MANAGED_THREAD_FACTORY, (Object)jndiName);
            }
        }
        this.setupDefaultDatasource(defaultDataSourceJndiName, defaultDataSourceName, addOp, subsystemResource.getParentResource(), context, taskEnvironment, taskResultBuilder);
        this.setupDefaultJMSConnectionFactory(defaultJmsConnectionFactoryJndiName, defaultJmsConnectionFactoryName, addOp, subsystemResource.getParentResource(), context, taskEnvironment, taskResultBuilder);
        configurationManagement.executeManagementOperation(addOp);
        context.getLogger().infof("Java EE Default Bindings configured.", new Object[0]);
        return taskResultBuilder.success().build();
    }

    private void setupDefaultJMSConnectionFactory(String defaultJmsConnectionFactoryJndiName, String defaultJmsConnectionFactoryName, final ModelNode addOp, SubsystemResource.Parent subsystemResources, final TaskContext context, final TaskEnvironment taskEnvironment, final ServerMigrationTaskResult.Builder taskResultBuilder) {
        SubsystemResource resource = subsystemResources.getSubsystemResource("messaging-activemq");
        if (resource == null) {
            return;
        }
        final ModelNode subsystemConfig = resource.getResourceConfiguration();
        if (defaultJmsConnectionFactoryJndiName == null) {
            if (defaultJmsConnectionFactoryName != null && !defaultJmsConnectionFactoryName.isEmpty() && subsystemConfig.hasDefined(SERVER)) {
                for (Object serverName : subsystemConfig.get(SERVER).keys()) {
                    ModelNode defaultJmsConnectionFactory = null;
                    if (subsystemConfig.hasDefined(new String[]{SERVER, serverName, POOLED_CONNECTION_FACTORY, defaultJmsConnectionFactoryName})) {
                        defaultJmsConnectionFactory = subsystemConfig.get(new String[]{SERVER, serverName, POOLED_CONNECTION_FACTORY, defaultJmsConnectionFactoryName});
                    } else if (subsystemConfig.hasDefined(new String[]{SERVER, serverName, CONNECTION_FACTORY, defaultJmsConnectionFactoryName})) {
                        defaultJmsConnectionFactory = subsystemConfig.get(new String[]{SERVER, serverName, CONNECTION_FACTORY, defaultJmsConnectionFactoryName});
                    }
                    if (defaultJmsConnectionFactory == null) continue;
                    defaultJmsConnectionFactoryJndiName = ((ModelNode)defaultJmsConnectionFactory.get("entries").asList().get(0)).asString();
                }
            }
        } else if (defaultJmsConnectionFactoryJndiName.isEmpty()) {
            defaultJmsConnectionFactoryJndiName = null;
        }
        if (defaultJmsConnectionFactoryJndiName != null) {
            addOp.get("jms-connection-factory").set(defaultJmsConnectionFactoryJndiName);
            taskResultBuilder.addAttribute(TASK_RESULT_ATTR_JMS_CONNECTION_FACTORY, (Object)defaultJmsConnectionFactoryJndiName);
            context.getLogger().infof("Java EE Default JMS Connection Builder configured with JNDI name %s.", (Object)defaultJmsConnectionFactoryJndiName);
        } else {
            if (!context.isInteractive()) {
                context.getLogger().infof("Default JMS Connection Builder not found, skipping its configuration due to non interactive mode", new Object[0]);
                return;
            }
            context.getLogger().infof("Default JMS Connection Builder not found", new Object[0]);
            final HashMap<String, ConfiguredJmsConnectionFactory> factoryNamesMap = new HashMap<String, ConfiguredJmsConnectionFactory>();
            if (subsystemConfig.hasDefined(SERVER)) {
                for (String serverName : subsystemConfig.get(SERVER).keys()) {
                    ConfiguredJmsConnectionFactory configuredJmsConnectionFactory;
                    if (subsystemConfig.hasDefined(new String[]{SERVER, serverName, CONNECTION_FACTORY})) {
                        for (String factoryName : subsystemConfig.get(new String[]{SERVER, serverName, CONNECTION_FACTORY}).keys()) {
                            configuredJmsConnectionFactory = new ConfiguredJmsConnectionFactory();
                            configuredJmsConnectionFactory.serverName = serverName;
                            configuredJmsConnectionFactory.factoryType = CONNECTION_FACTORY;
                            configuredJmsConnectionFactory.factoryName = factoryName;
                            factoryNamesMap.put(configuredJmsConnectionFactory.toString(), configuredJmsConnectionFactory);
                        }
                    }
                    if (!subsystemConfig.hasDefined(new String[]{SERVER, serverName, POOLED_CONNECTION_FACTORY})) continue;
                    for (String factoryName : subsystemConfig.get(new String[]{SERVER, serverName, POOLED_CONNECTION_FACTORY}).keys()) {
                        configuredJmsConnectionFactory = new ConfiguredJmsConnectionFactory();
                        configuredJmsConnectionFactory.serverName = serverName;
                        configuredJmsConnectionFactory.factoryType = POOLED_CONNECTION_FACTORY;
                        configuredJmsConnectionFactory.factoryName = factoryName;
                        factoryNamesMap.put(configuredJmsConnectionFactory.toString(), configuredJmsConnectionFactory);
                    }
                }
            }
            String[] factoryNames = factoryNamesMap.keySet().toArray(new String[factoryNamesMap.keySet().size()]);
            UserChoiceWithOtherOption.ResultHandler resultHandler = new UserChoiceWithOtherOption.ResultHandler(){

                public void onChoice(String choice) {
                    ConfiguredJmsConnectionFactory configuredJmsConnectionFactory = (ConfiguredJmsConnectionFactory)factoryNamesMap.get(choice);
                    ModelNode jmsConnectionFactory = subsystemConfig.get(new String[]{AddDefaultBindingsConfig.SERVER, configuredJmsConnectionFactory.serverName, configuredJmsConnectionFactory.factoryType, configuredJmsConnectionFactory.factoryName});
                    String jmsConnectionFactoryJndiName = ((ModelNode)jmsConnectionFactory.get("entries").asList().get(0)).asString();
                    this.processJmsConnectionFactoryJndiName(jmsConnectionFactoryJndiName);
                }

                public void onError() {
                }

                public void onOther(String otherChoice) {
                    this.processJmsConnectionFactoryJndiName(otherChoice);
                }

                private void processJmsConnectionFactoryJndiName(final String jmsConnectionFactoryJndiName) {
                    addOp.get("jms-connection-factory").set(jmsConnectionFactoryJndiName);
                    taskResultBuilder.addAttribute(AddDefaultBindingsConfig.TASK_RESULT_ATTR_JMS_CONNECTION_FACTORY, (Object)jmsConnectionFactoryJndiName);
                    context.getLogger().infof("Java EE Default JMS Connection Builder configured with JNDI name %s.", (Object)jmsConnectionFactoryJndiName);
                    UserConfirmation.ResultHandler resultHandler = new UserConfirmation.ResultHandler(){

                        public void onNo() {
                        }

                        public void onYes() {
                            taskEnvironment.setProperty("defaultJmsConnectionFactoryJndiName", jmsConnectionFactoryJndiName);
                        }

                        public void onError() {
                            this.processJmsConnectionFactoryJndiName(jmsConnectionFactoryJndiName);
                        }
                    };
                    ConsoleWrapper consoleWrapper = context.getConsoleWrapper();
                    consoleWrapper.printf("%n", new Object[0]);
                    new UserConfirmation(consoleWrapper, "Save this Java EE Default JMS Connection Builder JNDI name and use it when migrating other config files?", ServerMigrationLogger.ROOT_LOGGER.yesNo(), resultHandler).execute();
                }
            };
            new UserChoiceWithOtherOption(context.getConsoleWrapper(), factoryNames, "Unconfigured JMS Connection Builder, I want to enter the JNDI name...", "Please select Java EE's Default JMS Connection Builder: ", resultHandler).execute();
        }
    }

    private void setupDefaultDatasource(String defaultDataSourceJndiName, String defaultDataSourceName, final ModelNode addOp, SubsystemResource.Parent subsystemResources, final TaskContext context, final TaskEnvironment taskEnvironment, final ServerMigrationTaskResult.Builder taskResultBuilder) {
        SubsystemResource resource = subsystemResources.getSubsystemResource("datasources");
        if (resource == null) {
            return;
        }
        final ModelNode subsystemConfig = resource.getResourceConfiguration();
        if (defaultDataSourceJndiName == null) {
            if (defaultDataSourceName != null && !defaultDataSourceName.isEmpty() && subsystemConfig.hasDefined(new String[]{DATA_SOURCE, defaultDataSourceName})) {
                ModelNode defaultDatasource = subsystemConfig.get(new String[]{DATA_SOURCE, defaultDataSourceName});
                defaultDataSourceJndiName = defaultDatasource.get(DATA_SOURCE_JNDI_NAME).asString();
            }
        } else if (defaultDataSourceJndiName.isEmpty()) {
            defaultDataSourceJndiName = null;
        }
        if (defaultDataSourceJndiName != null) {
            addOp.get("datasource").set(defaultDataSourceJndiName);
            taskResultBuilder.addAttribute(TASK_RESULT_ATTR_DATA_SOURCE, (Object)defaultDataSourceJndiName);
            context.getLogger().infof("Java EE Default Datasource configured with JNDI name %s.", (Object)defaultDataSourceJndiName);
        } else {
            if (!context.isInteractive()) {
                context.getLogger().infof("Default datasource not found, skipping its configuration due to non interactive mode", new Object[0]);
                return;
            }
            context.getLogger().infof("Default datasource not found.", new Object[0]);
            String[] dataSourceNames = subsystemConfig.hasDefined(DATA_SOURCE) ? subsystemConfig.get(DATA_SOURCE).keys().toArray(new String[0]) : new String[]{};
            UserChoiceWithOtherOption.ResultHandler resultHandler = new UserChoiceWithOtherOption.ResultHandler(){

                public void onChoice(String choice) {
                    this.processDatasourceJndiName(subsystemConfig.get(new String[]{AddDefaultBindingsConfig.DATA_SOURCE, choice}).get(AddDefaultBindingsConfig.DATA_SOURCE_JNDI_NAME).asString());
                }

                public void onError() {
                }

                public void onOther(String otherChoice) {
                    this.processDatasourceJndiName(otherChoice);
                }

                private void processDatasourceJndiName(final String datasourceJndiName) {
                    addOp.get("datasource").set(datasourceJndiName);
                    taskResultBuilder.addAttribute(AddDefaultBindingsConfig.TASK_RESULT_ATTR_DATA_SOURCE, (Object)datasourceJndiName);
                    context.getLogger().infof("Java EE Default Datasource configured with JNDI name %s.", (Object)datasourceJndiName);
                    UserConfirmation.ResultHandler resultHandler = new UserConfirmation.ResultHandler(){

                        public void onNo() {
                        }

                        public void onYes() {
                            taskEnvironment.setProperty("defaultDataSourceJndiName", datasourceJndiName);
                        }

                        public void onError() {
                            this.processDatasourceJndiName(datasourceJndiName);
                        }
                    };
                    ConsoleWrapper consoleWrapper = context.getConsoleWrapper();
                    consoleWrapper.printf("%n", new Object[0]);
                    new UserConfirmation(consoleWrapper, "Save this Java EE Default Datasource JNDI name and use it when migrating other config files?", ServerMigrationLogger.ROOT_LOGGER.yesNo(), resultHandler).execute();
                }
            };
            new UserChoiceWithOtherOption(context.getConsoleWrapper(), dataSourceNames, "Unconfigured data source, I want to enter the JNDI name...", "Please select Java EE's Default Datasource: ", resultHandler).execute();
        }
    }

    private static class ConfiguredJmsConnectionFactory {
        private String serverName;
        private String factoryType;
        private String factoryName;

        private ConfiguredJmsConnectionFactory() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConfiguredJmsConnectionFactory that = (ConfiguredJmsConnectionFactory)o;
            if (!this.serverName.equals(that.serverName)) {
                return false;
            }
            if (!this.factoryType.equals(that.factoryType)) {
                return false;
            }
            return this.factoryName.equals(that.factoryName);
        }

        public int hashCode() {
            int result = this.serverName.hashCode();
            result = 31 * result + this.factoryType.hashCode();
            result = 31 * result + this.factoryName.hashCode();
            return result;
        }

        public String toString() {
            return "server = " + this.serverName + ", factory type = " + this.factoryType + ", factory name = " + this.factoryName;
        }
    }

    public static interface EnvironmentProperties {
        public static final String DEFAULT_DATA_SOURCE_JNDI_NAME = "defaultDataSourceJndiName";
        public static final String DEFAULT_DATA_SOURCE_NAME = "defaultDataSourceName";
        public static final String DEFAULT_JMS_CONNECTION_FACTORY_JNDI_NAME = "defaultJmsConnectionFactoryJndiName";
        public static final String DEFAULT_JMS_CONNECTION_FACTORY_NAME = "defaultJmsConnectionFactoryName";
    }
}

