/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.subsystem.undertow;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.env.TaskEnvironment;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.TaskContext;
import org.jboss.migration.wfly10.config.management.SubsystemResource;
import org.jboss.migration.wfly10.config.task.management.subsystem.UpdateSubsystemResourceSubtaskBuilder;

public class SetDefaultHostResponseHeader<S>
extends UpdateSubsystemResourceSubtaskBuilder<S> {
    public static final String TASK_NAME = "add-response-header";
    private static final String SERVER_NAME = "default-server";
    private static final String HOST_NAME = "default-host";
    private static final String FILTER_REF = "filter-ref";
    private static final String CONFIGURATION = "configuration";
    private static final String FILTER = "filter";
    private static final String RESPONSE_HEADER = "response-header";
    private static final String HEADER_NAME = "header-name";
    private static final String HEADER_VALUE = "header-value";
    protected final String filterName;
    protected final String headerName;
    protected final String headerValue;

    public SetDefaultHostResponseHeader(String filterName, String headerName) {
        this(filterName, headerName, null);
    }

    public SetDefaultHostResponseHeader(String filterName, String headerName, String headerValue) {
        this.subtaskName("add-response-header." + filterName);
        this.filterName = filterName;
        this.headerName = headerName;
        this.headerValue = headerValue;
    }

    protected String getHeaderValue(ModelNode config, SubsystemResource subsystemResource, TaskContext context, TaskEnvironment taskEnvironment) {
        return this.headerValue;
    }

    @Override
    protected ServerMigrationTaskResult updateConfiguration(ModelNode config, S source, SubsystemResource subsystemResource, TaskContext context, TaskEnvironment taskEnvironment) {
        ModelNode op;
        PathAddress configPathAddress = subsystemResource.getResourcePathAddress();
        PathAddress serverPathAddress = configPathAddress.append(new PathElement[]{PathElement.pathElement((String)"server", (String)SERVER_NAME)});
        if (!config.hasDefined(new String[]{"server", SERVER_NAME})) {
            context.getLogger().debugf("Skipping task, server '%s' not found in Undertow's config %s", (Object)serverPathAddress.toCLIStyleString(), (Object)configPathAddress.toCLIStyleString());
            return ServerMigrationTaskResult.SKIPPED;
        }
        ModelNode server = config.get(new String[]{"server", SERVER_NAME});
        PathAddress defaultHostPathAddress = serverPathAddress.append(new PathElement[]{PathElement.pathElement((String)"host", (String)HOST_NAME)});
        if (!server.hasDefined(new String[]{"host", HOST_NAME})) {
            context.getLogger().debugf("Skipping task, host '%s' not found in Undertow's config %s", (Object)defaultHostPathAddress.toCLIStyleString(), (Object)configPathAddress.toCLIStyleString());
            return ServerMigrationTaskResult.SKIPPED;
        }
        ModelNode defaultHost = server.get(new String[]{"host", HOST_NAME});
        String headerValue = this.getHeaderValue(config, subsystemResource, context, taskEnvironment);
        if (headerValue == null) {
            context.getLogger().debugf("Skipping task, null header-value", new Object[0]);
            return ServerMigrationTaskResult.SKIPPED;
        }
        PathAddress responseHeaderPathAddress = configPathAddress.append(CONFIGURATION, FILTER).append(RESPONSE_HEADER, this.filterName);
        if (!config.hasDefined(new String[]{CONFIGURATION, FILTER, RESPONSE_HEADER, this.filterName})) {
            if (!config.hasDefined(new String[]{CONFIGURATION, FILTER})) {
                op = Util.createAddOperation((PathAddress)configPathAddress.append(CONFIGURATION, FILTER));
                subsystemResource.getServerConfiguration().executeManagementOperation(op);
            }
            op = Util.createAddOperation((PathAddress)responseHeaderPathAddress);
            op.get(HEADER_NAME).set(this.headerName);
            op.get(HEADER_VALUE).set(headerValue);
            subsystemResource.getServerConfiguration().executeManagementOperation(op);
        } else {
            op = Util.getWriteAttributeOperation((PathAddress)responseHeaderPathAddress, (String)HEADER_VALUE, (String)headerValue);
            subsystemResource.getServerConfiguration().executeManagementOperation(op);
        }
        if (!defaultHost.hasDefined(new String[]{FILTER_REF, this.filterName})) {
            PathAddress filterRefPathAddress = defaultHostPathAddress.append(FILTER_REF, this.filterName);
            ModelNode op2 = Util.createAddOperation((PathAddress)filterRefPathAddress);
            subsystemResource.getServerConfiguration().executeManagementOperation(op2);
        }
        context.getLogger().infof("Response header '%s' set as '%s: %s' in Undertow's config %s", new Object[]{this.filterName, this.headerName, headerValue, configPathAddress.toCLIStyleString()});
        return new ServerMigrationTaskResult.Builder().success().addAttribute(HEADER_NAME, (Object)this.headerName).addAttribute(HEADER_VALUE, (Object)headerValue).build();
    }
}

