/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.update;

import java.util.List;
import java.util.stream.Collectors;
import org.jboss.dmr.ModelNode;
import org.jboss.migration.core.ServerMigrationFailureException;
import org.jboss.migration.core.jboss.DeploymentOverlayLinkMatcher;
import org.jboss.migration.core.jboss.JBossServer;
import org.jboss.migration.core.jboss.JBossServerConfigurationPath;
import org.jboss.migration.core.task.ServerMigrationTaskName;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.component.TaskRunnable;
import org.jboss.migration.core.task.component.TaskSkipPolicy;
import org.jboss.migration.wfly10.config.management.DeploymentOverlayResource;
import org.jboss.migration.wfly10.config.management.DeploymentResource;
import org.jboss.migration.wfly10.config.management.HostControllerConfiguration;
import org.jboss.migration.wfly10.config.management.ManageableResourceSelectors;
import org.jboss.migration.wfly10.config.management.ServerGroupResource;
import org.jboss.migration.wfly10.config.task.management.configuration.ManageableServerConfigurationCompositeTask;
import org.jboss.migration.wfly10.config.task.management.configuration.ManageableServerConfigurationLeafTask;

public class MigrateDeploymentOverlays<S extends JBossServer<S>>
extends ManageableServerConfigurationCompositeTask.Builder<JBossServerConfigurationPath<S>> {
    public MigrateDeploymentOverlays() {
        this.name("deployments.overlays.migrate");
        this.skipPolicy(TaskSkipPolicy.skipIfDefaultTaskSkipPropertyIsSet());
        this.runBuilder(params -> context -> {
            context.getLogger().debugf("Retrieving the configuration's deployment overlays...", new Object[0]);
            List overlays = params.getServerConfiguration().getChildResources(DeploymentOverlayResource.RESOURCE_TYPE);
            if (overlays.isEmpty()) {
                context.getLogger().debugf("No deployment overlays found.", new Object[0]);
                return ServerMigrationTaskResult.SKIPPED;
            }
            context.getLogger().infof("Deployment overlays found: %s", overlays.stream().map(overlay -> overlay.getResourceName()).collect(Collectors.toList()));
            DeploymentOverlayLinkMatcher matcher = new DeploymentOverlayLinkMatcher();
            for (DeploymentOverlayResource overlay2 : overlays) {
                boolean migrateResource = false;
                String[] deploymentLinks = overlay2.getDeploymentLinks();
                List deployments = params.getServerConfiguration().getChildResources(DeploymentResource.RESOURCE_TYPE);
                for (DeploymentResource deployment : deployments) {
                    if (!DeploymentOverlayLinkMatcher.matches((String)deployment.getResourceName(), (String[])deploymentLinks)) continue;
                    context.getLogger().infof("Migrating deployment overlay '%s', it's linked to deployment %s", (Object)overlay2.getResourceName(), (Object)deployment.getResourceName());
                    migrateResource = true;
                    break;
                }
                if (migrateResource) continue;
                RemoveResourceSubtask subtaskBuilder = new RemoveResourceSubtask(overlay2);
                context.execute(subtaskBuilder.build(params));
            }
            return context.hasSucessfulSubtasks() ? ServerMigrationTaskResult.SUCCESS : ServerMigrationTaskResult.SKIPPED;
        });
    }

    public static class RemoveResourceSubtask<S extends JBossServer<S>>
    extends ManageableServerConfigurationLeafTask.Builder<JBossServerConfigurationPath<S>> {
        protected RemoveResourceSubtask(DeploymentOverlayResource resource) {
            this.nameBuilder(parameters -> new ServerMigrationTaskName.Builder("deployments.overlay." + resource.getResourceName() + ".remove").addAttribute("resource", resource.getResourceAbsoluteName()).build());
            TaskRunnable.Builder runnableBuilder = params -> context -> {
                if (params.getServerConfiguration() instanceof HostControllerConfiguration) {
                    for (DeploymentOverlayResource serverGroupDeploymentResource : ManageableResourceSelectors.selectResources(ServerGroupResource.class).andThen(ManageableResourceSelectors.selectResources(DeploymentOverlayResource.class, resource.getResourceName())).fromResources(params.getServerConfiguration())) {
                        serverGroupDeploymentResource.removeResource();
                        context.getLogger().infof("Removed deployment overlay from server group %s", (Object)resource.getResourceAbsoluteName());
                    }
                }
                resource.removeResource();
                context.getLogger().infof("Removed deployment overlay from configuration %s", (Object)resource.getResourceAbsoluteName());
                return ServerMigrationTaskResult.SUCCESS;
            };
            this.runBuilder(runnableBuilder);
        }
    }

    public static class MigrateResourceSubtask<S extends JBossServer<S>>
    extends ManageableServerConfigurationLeafTask.Builder<JBossServerConfigurationPath<S>> {
        protected MigrateResourceSubtask(DeploymentOverlayResource resource) {
            this.nameBuilder(parameters -> new ServerMigrationTaskName.Builder("deployments.overlay." + resource.getResourceName() + ".migrate").addAttribute("resource", resource.getResourceAbsoluteName()).build());
            TaskRunnable.Builder runnableBuilder = params -> context -> {
                ModelNode resourceConfig = resource.getResourceConfiguration();
                if (!resourceConfig.hasDefined("content")) {
                    throw new ServerMigrationFailureException("Unexpected deployment overlay " + resource.getResourceName() + " configuration: " + resourceConfig.asString());
                }
                for (ModelNode modelNode : resourceConfig.get("content").asList()) {
                }
                return ServerMigrationTaskResult.SUCCESS;
            };
            this.runBuilder(runnableBuilder);
        }
    }
}

