/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.update;

import java.nio.file.Path;
import org.jboss.migration.core.ServerMigrationFailureException;
import org.jboss.migration.core.jboss.JBossServerConfigurationPath;
import org.jboss.migration.core.jboss.ResolvablePath;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.TaskContext;
import org.jboss.migration.core.task.component.TaskRunnable;
import org.jboss.migration.wfly10.config.management.ManageableServerConfiguration;
import org.jboss.migration.wfly10.config.task.update.MigratePath;

public class MigrateResolvablePath
implements TaskRunnable {
    private final ResolvablePath path;
    private final JBossServerConfigurationPath sourceConfiguration;
    private final ManageableServerConfiguration targetConfiguration;

    public MigrateResolvablePath(ResolvablePath path, JBossServerConfigurationPath sourceConfiguration, ManageableServerConfiguration targetConfiguration) {
        this.path = path;
        this.sourceConfiguration = sourceConfiguration;
        this.targetConfiguration = targetConfiguration;
    }

    public ServerMigrationTaskResult run(TaskContext context) {
        if (this.path.getRelativeTo() != null) {
            Path sourcePath = this.sourceConfiguration.resolvePath(this.path);
            Path targetPath = this.targetConfiguration.resolvePath(this.path);
            if (sourcePath == null) {
                if (targetPath == null) {
                    throw new ServerMigrationFailureException("Failed to resolve path " + this.path);
                }
                sourcePath = targetPath.startsWith(this.targetConfiguration.getServer().getBaseDir()) ? this.sourceConfiguration.getServer().getBaseDir().resolve(this.targetConfiguration.getServer().getBaseDir().relativize(targetPath)) : targetPath;
            } else if (targetPath == null) {
                targetPath = sourcePath.startsWith(this.sourceConfiguration.getServer().getBaseDir()) ? this.targetConfiguration.getServer().getBaseDir().resolve(this.sourceConfiguration.getServer().getBaseDir().relativize(sourcePath)) : sourcePath;
            }
            return new MigratePath(sourcePath, targetPath).run(context);
        }
        return ServerMigrationTaskResult.SKIPPED;
    }
}

