/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly10.config.task.update;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.migration.core.ServerMigrationFailureException;
import org.jboss.migration.core.console.BasicResultHandlers;
import org.jboss.migration.core.console.UserConfirmation;
import org.jboss.migration.core.env.Environment;
import org.jboss.migration.core.env.EnvironmentProperties;
import org.jboss.migration.core.env.EnvironmentProperty;
import org.jboss.migration.core.env.TaskEnvironment;
import org.jboss.migration.core.jboss.JBossServer;
import org.jboss.migration.core.jboss.JBossServerConfigurationPath;
import org.jboss.migration.core.jboss.ResolvablePath;
import org.jboss.migration.core.task.ServerMigrationTaskName;
import org.jboss.migration.core.task.ServerMigrationTaskResult;
import org.jboss.migration.core.task.component.TaskSkipPolicy;
import org.jboss.migration.wfly10.config.management.ManageableServerConfiguration;
import org.jboss.migration.wfly10.config.management.SubsystemResource;
import org.jboss.migration.wfly10.config.task.management.configuration.ManageableServerConfigurationLeafTask;
import org.jboss.migration.wfly10.config.task.update.MigratePath;

public class MigrateScannerDeployments<S extends JBossServer<S>>
extends ManageableServerConfigurationLeafTask.Builder<JBossServerConfigurationPath<S>> {
    private static final EnvironmentProperty<List<String>> ENV_PROPERTY_PROCESSED_DEPLOYMENT_SCANNER_DIRS = EnvironmentProperties.newStringListProperty((String)"processedDeploymentScannerDirs", new ArrayList());
    private static final String SCANNER = "scanner";

    public MigrateScannerDeployments() {
        this.name("deployments.migrate-deployment-scanner-deployments");
        this.skipPolicy(TaskSkipPolicy.skipIfDefaultTaskSkipPropertyIsSet());
        this.runBuilder(params -> context -> {
            JBossServerConfigurationPath sourceConfiguration = (JBossServerConfigurationPath)params.getSource();
            ManageableServerConfiguration targetConfiguration = params.getServerConfiguration();
            for (SubsystemResource subsystemResource : targetConfiguration.findResources(SubsystemResource.class, "deployment-scanner")) {
                context.getLogger().debugf("Deployment-scanner found, analysing its configuration %s...", (Object)subsystemResource.getResourceAbsoluteName());
                ModelNode subsystemConfig = subsystemResource.getResourceConfiguration();
                if (subsystemConfig == null || !subsystemConfig.hasDefined(SCANNER)) continue;
                for (Property property : subsystemConfig.get(SCANNER).asPropertyList()) {
                    boolean confirmEachDeployment;
                    List deployments;
                    ModelNode scannerConfig = property.getValue();
                    if (!scannerConfig.hasDefined("path")) continue;
                    ResolvablePath scannerConfigPath = new ResolvablePath(scannerConfig);
                    Path sourceDeploymentsDir = sourceConfiguration.resolvePath(scannerConfigPath);
                    Path targetDeploymentsDir = targetConfiguration.resolvePath(scannerConfigPath);
                    if (sourceDeploymentsDir == null) {
                        if (targetDeploymentsDir == null) {
                            throw new ServerMigrationFailureException("Failed to resolve deployment scanner path " + scannerConfig);
                        }
                        sourceDeploymentsDir = targetDeploymentsDir.startsWith(targetConfiguration.getServer().getBaseDir()) ? sourceConfiguration.getServer().getBaseDir().resolve(targetConfiguration.getServer().getBaseDir().relativize(targetDeploymentsDir)) : targetDeploymentsDir;
                    } else if (targetDeploymentsDir == null) {
                        targetDeploymentsDir = sourceDeploymentsDir.startsWith(sourceConfiguration.getServer().getBaseDir()) ? targetConfiguration.getServer().getBaseDir().resolve(sourceConfiguration.getServer().getBaseDir().relativize(sourceDeploymentsDir)) : sourceDeploymentsDir;
                    }
                    TaskEnvironment taskEnvironment = new TaskEnvironment(context);
                    List processedDeploymentScannerDirs = (List)ENV_PROPERTY_PROCESSED_DEPLOYMENT_SCANNER_DIRS.getValue((Environment)taskEnvironment);
                    String sourceDeploymentsDirAsString = sourceDeploymentsDir.toString();
                    if (processedDeploymentScannerDirs.contains(sourceDeploymentsDirAsString)) {
                        context.getLogger().debugf("Already processed source's deployments directory '%s', skipping it...", (Object)sourceDeploymentsDir);
                        continue;
                    }
                    processedDeploymentScannerDirs.add(sourceDeploymentsDirAsString);
                    ENV_PROPERTY_PROCESSED_DEPLOYMENT_SCANNER_DIRS.setValue((Object)processedDeploymentScannerDirs, (Environment)taskEnvironment);
                    context.getLogger().infof("Found deployment scanner '%s' watching directory '%s', searching for deployments in it...", (Object)property.getName(), (Object)sourceDeploymentsDir);
                    try {
                        deployments = Files.list(sourceDeploymentsDir).filter(path -> Files.exists(path.resolveSibling(path.getFileName().toString() + ".deployed"), new LinkOption[0])).map(path -> path.getFileName()).collect(Collectors.toList());
                    }
                    catch (IOException e) {
                        throw new ServerMigrationFailureException("Failed to read the scanner's deployments directory", (Throwable)e);
                    }
                    if (deployments.isEmpty()) {
                        context.getLogger().debugf("No deployments found in '%s'.", (Object)sourceDeploymentsDir);
                        continue;
                    }
                    context.getLogger().infof("Deployments found: %s", (Object)sourceDeploymentsDir, deployments);
                    if (context.isInteractive()) {
                        if (deployments.size() > 1) {
                            BasicResultHandlers.UserConfirmation userConfirmation = new BasicResultHandlers.UserConfirmation();
                            new UserConfirmation(context.getConsoleWrapper(), "Migrate all deployments found?", "yes/no?", (UserConfirmation.ResultHandler)userConfirmation).execute();
                            confirmEachDeployment = userConfirmation.getResult() == BasicResultHandlers.UserConfirmation.Result.NO;
                        } else {
                            confirmEachDeployment = true;
                        }
                    } else {
                        confirmEachDeployment = false;
                    }
                    for (Path deployment : deployments) {
                        boolean migrateDeployment;
                        if (confirmEachDeployment) {
                            BasicResultHandlers.UserConfirmation userConfirmation = new BasicResultHandlers.UserConfirmation();
                            new UserConfirmation(context.getConsoleWrapper(), "Migrate deployment '" + deployment + "'?", "yes/no?", (UserConfirmation.ResultHandler)userConfirmation).execute();
                            migrateDeployment = userConfirmation.getResult() == BasicResultHandlers.UserConfirmation.Result.YES;
                        } else {
                            migrateDeployment = true;
                        }
                        if (!migrateDeployment) continue;
                        Path sourcePath = sourceDeploymentsDir.resolve(deployment);
                        Path targetPath = targetDeploymentsDir.resolve(deployment);
                        ServerMigrationTaskName subtaskName = new ServerMigrationTaskName.Builder("deployments.migrate-not-persistent-deployment").addAttribute("source", sourcePath.toString()).addAttribute("target", targetPath.toString()).build();
                        context.execute(subtaskName, subtaskContext -> new MigratePath(sourcePath, targetPath).run(subtaskContext));
                    }
                }
            }
            return context.hasSucessfulSubtasks() ? ServerMigrationTaskResult.SUCCESS : ServerMigrationTaskResult.SKIPPED;
        });
    }
}

