/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly11.task.subsystem.elytron;

import java.util.Properties;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;

public class ConfigurableSaslServerFactoryAddOperation {
    private final PathAddress subsystemPathAddress;
    private final String configurableSaslServerFactory;
    private String saslServerFactory;
    private Properties properties;

    public ConfigurableSaslServerFactoryAddOperation(PathAddress subsystemPathAddress, String configurableSaslServerFactory) {
        this.subsystemPathAddress = subsystemPathAddress;
        this.configurableSaslServerFactory = configurableSaslServerFactory;
        this.properties = new Properties();
    }

    public ConfigurableSaslServerFactoryAddOperation saslServerFactory(String saslServerFactory) {
        this.saslServerFactory = saslServerFactory;
        return this;
    }

    public ConfigurableSaslServerFactoryAddOperation addProperty(String propertyName, String propertyValue) {
        this.properties.setProperty(propertyName, propertyValue);
        return this;
    }

    public ModelNode toModelNode() {
        PathAddress pathAddress = this.subsystemPathAddress.append("configurable-sasl-server-factory", this.configurableSaslServerFactory);
        ModelNode operation = Util.createAddOperation((PathAddress)pathAddress);
        if (this.saslServerFactory != null) {
            operation.get("sasl-server-factory").set(this.saslServerFactory);
        }
        if (this.properties != null && !this.properties.isEmpty()) {
            ModelNode propertiesNode = operation.get("properties");
            for (String propertyName : this.properties.stringPropertyNames()) {
                propertiesNode.get(propertyName).set(this.properties.getProperty(propertyName));
            }
        }
        return operation;
    }
}

