/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.migration.wfly9;

import java.io.IOException;
import java.nio.file.Path;
import org.jboss.migration.core.AbstractServerProvider;
import org.jboss.migration.core.ManifestProductInfo;
import org.jboss.migration.core.ProductInfo;
import org.jboss.migration.core.Server;
import org.jboss.migration.wfly9.WildFly9Server;

public class WildFly9ServerProvider
extends AbstractServerProvider {
    protected ProductInfo getProductInfo(Path baseDir) throws IllegalArgumentException, IOException {
        Path manifestPath = WildFly9Server.getModulesSystemLayersBaseDir(baseDir).resolve("org").resolve("jboss").resolve("as").resolve("product").resolve("wildfly-full").resolve("dir").resolve("META-INF").resolve("MANIFEST.MF");
        ManifestProductInfo productInfo = ManifestProductInfo.from((Path)manifestPath);
        return productInfo;
    }

    protected String getProductNameRegex() {
        return "WildFly Full";
    }

    protected String getProductVersionRegex() {
        return "9\\..*";
    }

    protected Server constructServer(ProductInfo productInfo, Path baseDir) {
        return new WildFly9Server(productInfo, baseDir);
    }

    public String getName() {
        return "WildFly Full 9.x";
    }
}

