/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jboss.modules.ConcurrentClassLoader;
import org.jboss.modules.FastCopyHashSet;
import org.jboss.modules.PropertyReadAction;
import org.jboss.modules.StreamUtil;

final class JDKSpecific {
    static final Set<String> MODULES_PACKAGES = new HashSet<String>(Arrays.asList("org/jboss/modules", "org/jboss/modules/filter", "org/jboss/modules/log", "org/jboss/modules/management", "org/jboss/modules/ref"));
    static final StackWalker STACK_WALKER = AccessController.doPrivileged(() -> StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE));

    JDKSpecific() {
    }

    static Class<?> getCallingUserClass() {
        return STACK_WALKER.walk(stream -> ((StackWalker.StackFrame)stream.skip(1L).findFirst().get()).getDeclaringClass());
    }

    static Class<?> getCallingClass() {
        return STACK_WALKER.walk(JDKSpecific::processFrame);
    }

    static boolean isParallelCapable(ConcurrentClassLoader cl) {
        return ConcurrentClassLoader.getLockForClass((ConcurrentClassLoader)cl, (String)"$TEST$") != cl;
    }

    static Package getPackage(ClassLoader cl, String packageName) {
        return cl.getDefinedPackage(packageName);
    }

    static Enumeration<URL> getPlatformResources(String name) throws IOException {
        int index = name.lastIndexOf(47);
        if (index > 0 && MODULES_PACKAGES.contains(name.substring(0, index))) {
            return JDKSpecific.class.getClassLoader().getResources(name);
        }
        return ClassLoader.getPlatformClassLoader().getResources(name);
    }

    static Set<String> getJDKPaths() {
        FastCopyHashSet pathSet = new FastCopyHashSet(1024);
        JDKSpecific.processRuntimeImages((Set<String>)pathSet);
        String javaClassPath = (String)AccessController.doPrivileged(new PropertyReadAction("java.class.path"));
        JDKSpecific.processClassPathItem(javaClassPath, (Set<String>)new FastCopyHashSet(1024), (Set<String>)pathSet);
        pathSet.addAll(MODULES_PACKAGES);
        return pathSet;
    }

    private static Class<?> processFrame(Stream<StackWalker.StackFrame> stream) {
        Iterator iterator = stream.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        iterator.next();
        if (!iterator.hasNext()) {
            return null;
        }
        iterator.next();
        if (!iterator.hasNext()) {
            return null;
        }
        Class<?> testClass = ((StackWalker.StackFrame)iterator.next()).getDeclaringClass();
        while (iterator.hasNext()) {
            Class<?> item = ((StackWalker.StackFrame)iterator.next()).getDeclaringClass();
            if (testClass == item) continue;
            return item;
        }
        return null;
    }

    private static void processRuntimeImages(Set<String> jarSet) {
        try {
            for (Path root : FileSystems.getFileSystem(new URI("jrt:/")).getRootDirectories()) {
                Files.walkFileTree(root, new JrtFileVisitor(jarSet));
            }
        }
        catch (IOException | URISyntaxException e) {
            throw new IllegalStateException("Unable to process java runtime images");
        }
    }

    private static void processClassPathItem(String classPath, Set<String> jarSet, Set<String> pathSet) {
        int e;
        if (classPath == null) {
            return;
        }
        int s = 0;
        do {
            String item;
            String string = item = (e = classPath.indexOf(File.pathSeparatorChar, s)) == -1 ? classPath.substring(s) : classPath.substring(s, e);
            if (!jarSet.contains(item)) {
                File file = new File(item);
                if (file.isDirectory()) {
                    JDKSpecific.processDirectory0(pathSet, file);
                } else {
                    try {
                        JDKSpecific.processJar(pathSet, file);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            s = e + 1;
        } while (e != -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processJar(Set<String> pathSet, File file) throws IOException {
        ZipFile zipFile = new ZipFile(file);
        try {
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                int lastSlash = name.lastIndexOf(47);
                if (lastSlash == -1) continue;
                pathSet.add(name.substring(0, lastSlash));
            }
            zipFile.close();
        }
        finally {
            StreamUtil.safeClose((Closeable)zipFile);
        }
    }

    private static void processDirectory0(Set<String> pathSet, File file) {
        for (File entry : file.listFiles()) {
            if (entry.isDirectory()) {
                JDKSpecific.processDirectory1(pathSet, entry, file.getPath());
                continue;
            }
            String parent = entry.getParent();
            if (parent == null) continue;
            pathSet.add(parent);
        }
    }

    private static void processDirectory1(Set<String> pathSet, File file, String pathBase) {
        for (File entry : file.listFiles()) {
            if (entry.isDirectory()) {
                JDKSpecific.processDirectory1(pathSet, entry, pathBase);
                continue;
            }
            String packagePath = entry.getParent();
            if (packagePath == null) continue;
            if ((packagePath = packagePath.substring(pathBase.length()).replace('\\', '/')).startsWith("/")) {
                packagePath = packagePath.substring(1);
            }
            pathSet.add(packagePath);
        }
    }

    private static class JrtFileVisitor
    implements FileVisitor<Path> {
        private static final String SLASH = "/";
        private static final String PACKAGES = "/packages";
        private final Set<String> pathSet;

        private JrtFileVisitor(Set<String> pathSet) {
            this.pathSet = pathSet;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            String d = dir.toString();
            return d.equals(SLASH) || d.startsWith(PACKAGES) ? FileVisitResult.CONTINUE : FileVisitResult.SKIP_SUBTREE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            String f = file.toString();
            this.pathSet.add(f.substring(PACKAGES.length() + 1, f.lastIndexOf(SLASH)).replace('.', '/'));
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }
    }
}

