/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.util.ArrayList;
import java.util.List;
import org.jboss.modules.ExportFilter;
import org.jboss.modules.ExportFilterable;
import org.jboss.modules.ModuleIdentifier;

public final class DependencySpec {
    private final ModuleIdentifier moduleIdentifier;
    private final boolean export;
    private final boolean optional;
    private final String[] exportIncludes;
    private final String[] exportExcludes;

    public DependencySpec(ModuleIdentifier moduleIdentifier, boolean export, boolean optional, String[] exportIncludes, String[] exportExcludes) {
        this.moduleIdentifier = moduleIdentifier;
        this.export = export;
        this.optional = optional;
        this.exportIncludes = exportIncludes;
        this.exportExcludes = exportExcludes;
    }

    public boolean isExport() {
        return this.export;
    }

    public ModuleIdentifier getModuleIdentifier() {
        return this.moduleIdentifier;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public ExportFilter getExportFilter() {
        return new ExportFilter(this.exportIncludes, this.exportExcludes);
    }

    public static Builder build(final ModuleIdentifier moduleIdentifier) {
        return new Builder(){
            private boolean export;
            private boolean optional;
            private final List<String> exportIncludes = new ArrayList<String>();
            private final List<String> exportExcludes = new ArrayList<String>();

            @Override
            public Builder setExport(boolean export) {
                this.export = export;
                return this;
            }

            @Override
            public Builder setOptional(boolean optional) {
                this.optional = optional;
                return this;
            }

            @Override
            public Builder addExportInclude(String path) {
                this.exportIncludes.add(path);
                return this;
            }

            @Override
            public Builder addExportExclude(String path) {
                this.exportExcludes.add(path);
                return this;
            }

            @Override
            public DependencySpec create() {
                return new DependencySpec(moduleIdentifier, this.export, this.optional, this.exportIncludes.toArray(new String[this.exportIncludes.size()]), this.exportExcludes.toArray(new String[this.exportExcludes.size()]));
            }
        };
    }

    public static interface Builder
    extends ExportFilterable<Builder> {
        public Builder setExport(boolean var1);

        public Builder setOptional(boolean var1);

        @Override
        public Builder addExportInclude(String var1);

        @Override
        public Builder addExportExclude(String var1);

        public DependencySpec create();
    }
}

