/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExportFilter {
    private static final Pattern GLOB_PATTERN = Pattern.compile("(\\*\\*?)|(\\?)|(\\\\.)|(/+)|([^*?]+)");
    private static final Pattern META_INF_PATTERN = ExportFilter.getGlobPattern("META-INF");
    private static final Pattern META_INF_CHILD_PATTERN = ExportFilter.getGlobPattern("META-INF/**");
    private final Pattern[] includes;
    private final Pattern[] excludes;

    public ExportFilter(String[] includes, String[] excludes) {
        this.includes = new Pattern[includes.length];
        int i = 0;
        for (String includeGlob : includes) {
            this.includes[i++] = ExportFilter.getGlobPattern(includeGlob);
        }
        this.excludes = new Pattern[excludes.length + 2];
        i = 0;
        for (String excludeGlob : excludes) {
            this.excludes[i++] = ExportFilter.getGlobPattern(excludeGlob);
        }
        this.excludes[i++] = META_INF_PATTERN;
        this.excludes[i++] = META_INF_CHILD_PATTERN;
    }

    public boolean shouldExport(String path) {
        for (Pattern includePattern : this.includes) {
            if (!this.matches(includePattern, path)) continue;
            return true;
        }
        for (Pattern excludePatterns : this.excludes) {
            if (!this.matches(excludePatterns, path)) continue;
            return false;
        }
        return true;
    }

    private boolean matches(Pattern pattern, String path) {
        Matcher matcher = pattern.matcher(path);
        return matcher.matches();
    }

    private static Pattern getGlobPattern(String glob) {
        StringBuilder patternBuilder = new StringBuilder();
        patternBuilder.append("^");
        Matcher m = GLOB_PATTERN.matcher(glob);
        boolean lastWasSlash = false;
        while (m.find()) {
            lastWasSlash = false;
            String grp = m.group(1);
            if (grp != null) {
                if (grp.length() == 2) {
                    patternBuilder.append(".*");
                    continue;
                }
                patternBuilder.append("[^/]*");
                continue;
            }
            grp = m.group(2);
            if (grp != null) {
                patternBuilder.append("[^/]");
                continue;
            }
            grp = m.group(3);
            if (grp != null) {
                patternBuilder.append(grp.charAt(1));
                continue;
            }
            grp = m.group(4);
            if (grp != null) {
                patternBuilder.append("/+");
                lastWasSlash = true;
                continue;
            }
            patternBuilder.append(Pattern.quote(m.group()));
        }
        if (lastWasSlash) {
            patternBuilder.append(".*");
        }
        patternBuilder.append("$");
        return Pattern.compile(patternBuilder.toString());
    }
}

