/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jboss.modules.ConcurrentReferenceHashMap;
import org.jboss.modules.Dependency;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.ExportFilter;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleAlreadyExistsException;
import org.jboss.modules.ModuleContentLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLogger;
import org.jboss.modules.ModuleNotFoundException;
import org.jboss.modules.ModuleSpec;

public abstract class ModuleLoader {
    private static volatile ModuleLogger log = new ModuleLogger(){

        @Override
        public void moduleLoading(ModuleIdentifier identifier) {
        }

        @Override
        public void moduleLoaded(ModuleIdentifier identifier) {
        }

        @Override
        public void moduleLoadFailed(ModuleIdentifier identifier, Throwable cause) {
        }
    };
    private ThreadLocal<Set<ModuleIdentifier>> VISITED = new ThreadLocal<Set<ModuleIdentifier>>(){

        @Override
        protected Set<ModuleIdentifier> initialValue() {
            return new LinkedHashSet<ModuleIdentifier>();
        }
    };
    private final ConcurrentMap<ModuleIdentifier, FutureModule> moduleMap = new ConcurrentReferenceHashMap<ModuleIdentifier, FutureModule>(256, 0.5f, 32, ConcurrentReferenceHashMap.ReferenceType.STRONG, ConcurrentReferenceHashMap.ReferenceType.WEAK, EnumSet.noneOf(ConcurrentReferenceHashMap.Option.class));

    public static void setLogger(ModuleLogger moduleLogger) {
        log = moduleLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Module loadModule(ModuleIdentifier identifier) throws ModuleLoadException {
        FutureModule newFuture;
        if (identifier.equals(ModuleIdentifier.SYSTEM)) {
            return Module.SYSTEM;
        }
        Set<ModuleIdentifier> visited = this.VISITED.get();
        if (visited.contains(identifier)) {
            throw new ModuleLoadException("Failed to load " + identifier + "; module cycle discovered: " + visited);
        }
        FutureModule futureModule = (FutureModule)this.moduleMap.get(identifier);
        if (futureModule == null && (futureModule = this.moduleMap.putIfAbsent(identifier, newFuture = new FutureModule(identifier))) == null) {
            visited.add(identifier);
            try {
                log.moduleLoading(identifier);
                Module module = this.findModule(identifier);
                if (module == null) {
                    ModuleNotFoundException e = new ModuleNotFoundException(identifier.toString());
                    log.moduleLoadFailed(identifier, e);
                    throw e;
                }
                log.moduleLoaded(identifier);
                Module module2 = module;
                return module2;
            }
            finally {
                visited.remove(identifier);
            }
        }
        return futureModule.getModule();
    }

    protected abstract Module findModule(ModuleIdentifier var1) throws ModuleLoadException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Module defineModule(ModuleSpec moduleSpec) throws ModuleLoadException {
        FutureModule newFuture;
        ModuleIdentifier moduleIdentifier = moduleSpec.getIdentifier();
        FutureModule futureModule = (FutureModule)this.moduleMap.get(moduleIdentifier);
        if (futureModule == null && (futureModule = this.moduleMap.putIfAbsent(moduleIdentifier, newFuture = new FutureModule(moduleIdentifier))) == null) {
            futureModule = newFuture;
        }
        if (futureModule.module != null) {
            throw new ModuleAlreadyExistsException(moduleIdentifier.toString());
        }
        HashMap<String, List<Module.DependencyImport>> pathsToImports = new HashMap<String, List<Module.DependencyImport>>();
        HashSet<String> exportedPaths = new HashSet<String>();
        try {
            ArrayList<Dependency> dependencies = new ArrayList<Dependency>(moduleSpec.getDependencies().length);
            for (DependencySpec dependencySpec : moduleSpec.getDependencies()) {
                Module dependencyModule;
                try {
                    dependencyModule = this.loadModule(dependencySpec.getModuleIdentifier());
                }
                catch (ModuleLoadException e) {
                    if (dependencySpec.isOptional()) continue;
                    throw e;
                }
                Dependency dependency = new Dependency(dependencyModule, dependencySpec.isExport());
                dependencies.add(dependency);
                ExportFilter filter = dependencySpec.getExportFilter();
                Set<String> moduleExportedPaths = dependencyModule.getExportedPaths();
                boolean depExported = dependency.isExport();
                for (String exportedPath : moduleExportedPaths) {
                    boolean shouldExport;
                    boolean bl = shouldExport = depExported && filter.shouldExport(exportedPath);
                    if (shouldExport) {
                        exportedPaths.add(exportedPath);
                    }
                    if (!pathsToImports.containsKey(exportedPath)) {
                        pathsToImports.put(exportedPath, new ArrayList());
                    }
                    ((List)pathsToImports.get(exportedPath)).add(new Module.DependencyImport(dependency, shouldExport));
                }
            }
            ModuleContentLoader contentLoader = moduleSpec.getContentLoader();
            exportedPaths.addAll(contentLoader.getFilteredLocalPaths());
            Module module = new Module(moduleSpec, moduleSpec.getModuleFlags(), this, exportedPaths, pathsToImports);
            FutureModule futureModule2 = futureModule;
            synchronized (futureModule2) {
                futureModule.setModule(module);
            }
            return module;
        }
        catch (ModuleLoadException e) {
            futureModule.setModule(null);
            log.moduleLoadFailed(moduleIdentifier, e);
            throw e;
        }
        catch (RuntimeException e) {
            futureModule.setModule(null);
            log.moduleLoadFailed(moduleIdentifier, e);
            throw e;
        }
        catch (Error e) {
            futureModule.setModule(null);
            log.moduleLoadFailed(moduleIdentifier, e);
            throw e;
        }
    }

    public Module createAggregate(ModuleIdentifier moduleIdentifier, List<ModuleIdentifier> dependencies) throws ModuleLoadException {
        ModuleSpec.Builder moduleSpecBuilder = ModuleSpec.build(moduleIdentifier);
        for (ModuleIdentifier identifier : dependencies) {
            moduleSpecBuilder.addDependency(moduleIdentifier).setExport(true);
        }
        return this.defineModule(moduleSpecBuilder.create());
    }

    private static final class FutureModule {
        private static final Object NOT_FOUND = new Object();
        private final ModuleIdentifier identifier;
        private volatile Object module;

        FutureModule(ModuleIdentifier identifier) {
            this.identifier = identifier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Module getModule() throws ModuleNotFoundException {
            boolean intr = false;
            try {
                Object object;
                Object module = this.module;
                if (module == null) {
                    object = this;
                    synchronized (object) {
                        while ((module = this.module) == null) {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException e) {
                                intr = true;
                            }
                        }
                    }
                }
                if (module == NOT_FOUND) {
                    throw new ModuleNotFoundException(this.identifier.toString());
                }
                object = (Module)module;
                return object;
            }
            finally {
                if (intr) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setModule(Module m) throws ModuleAlreadyExistsException {
            FutureModule futureModule = this;
            synchronized (futureModule) {
                this.module = m == null ? NOT_FOUND : m;
                this.notifyAll();
            }
        }
    }
}

