/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.Resource;
import org.jboss.modules.ResourceIdentifier;

final class ModuleProtocolHandler
extends URLStreamHandler {
    ModuleProtocolHandler() {
    }

    @Override
    protected URLConnection openConnection(URL u) throws IOException {
        ResourceIdentifier identifier = ResourceIdentifier.fromURL(u);
        try {
            return new ResourceConnection(Module.getModule(identifier.getModuleIdentifier()).getExportedResource(identifier.getRoot(), identifier.getPath()), u);
        }
        catch (ModuleLoadException e) {
            throw new IOException("Cannot connect", e);
        }
    }

    private class ResourceConnection
    extends URLConnection {
        private Resource resource;

        public ResourceConnection(Resource resource, URL moduleUrl) {
            super(moduleUrl);
            this.resource = resource;
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.resource.openStream();
        }

        @Override
        public int getContentLength() {
            long size = this.resource.getSize();
            return size > Integer.MAX_VALUE || size < 1L ? -1 : (int)size;
        }
    }
}

