/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.modules.ClassSpec;
import org.jboss.modules.FileEntryResource;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.PackageSpec;
import org.jboss.modules.PathFilter;
import org.jboss.modules.Resource;
import org.jboss.modules.ResourceLoader;

final class FileResourceLoader
implements ResourceLoader {
    private static final String ARCH_NAME = AccessController.doPrivileged(new PrivilegedAction<String>(){

        @Override
        public String run() {
            String sysName = System.getProperty("os.name").toUpperCase();
            String sysArch = System.getProperty("os.arch").toUpperCase();
            String realName = sysName.startsWith("Linux") ? "linux" : (sysName.startsWith("MAC OS") ? "macosx" : (sysName.startsWith("WINDOWS") ? "win" : (sysName.startsWith("OS/2") ? "os2" : (sysName.startsWith("SOLARIS") || sysName.startsWith("SUNOS") ? "solaris" : (sysName.startsWith("MPE/IX") ? "mpeix" : (sysName.startsWith("HP-UX") ? "hpux" : (sysName.startsWith("AIX") ? "aix" : (sysName.startsWith("OS/390") ? "os390" : (sysName.startsWith("FREEBSD") ? "freebsd" : (sysName.startsWith("IRIX") ? "irix" : (sysName.startsWith("DIGITAL UNIX") ? "digitalunix" : (sysName.startsWith("OSF1") ? "osf1" : (sysName.startsWith("OPENVMS") ? "openvms" : "unknown")))))))))))));
            String realArch = sysArch.startsWith("SPARCV9") || sysArch.startsWith("SPARC64") ? "sparcv9" : (sysArch.startsWith("SPARC") ? "sparc" : (sysArch.startsWith("X86_64") ? "x86_64" : (sysArch.startsWith("I386") || sysArch.startsWith("I586") || sysArch.startsWith("I686") || sysArch.startsWith("X86") ? "i686" : (sysArch.startsWith("PPC64") ? "ppc64" : (sysArch.startsWith("PPC") || sysArch.startsWith("POWER") ? "ppc" : (sysArch.startsWith("ARM") ? "arm" : (sysArch.startsWith("PA_RISC") || sysArch.startsWith("PA-RISC") ? "parisc" : (sysArch.startsWith("ALPHA") ? "alpha" : (sysArch.startsWith("MIPS") ? "mips" : "unknown")))))))));
            return realName + "-" + realArch;
        }
    });
    private final String rootName;
    private final File root;
    private final Manifest manifest;
    private final PathFilter exportFilter;

    FileResourceLoader(ModuleIdentifier moduleIdentifier, File root, String rootName, PathFilter exportFilter) {
        if (moduleIdentifier == null) {
            throw new IllegalArgumentException("moduleIdentifier is null");
        }
        if (root == null) {
            throw new IllegalArgumentException("root is null");
        }
        if (rootName == null) {
            throw new IllegalArgumentException("rootName is null");
        }
        if (exportFilter == null) {
            throw new IllegalArgumentException("exportFilter is null");
        }
        this.rootName = rootName;
        this.root = root;
        this.exportFilter = exportFilter;
        File manifestFile = new File(root, "META-INF" + File.separator + "MANIFEST.MF");
        this.manifest = FileResourceLoader.readManifestFile(manifestFile);
    }

    private static Manifest readManifestFile(File manifestFile) {
        try {
            return new Manifest(new FileInputStream(manifestFile));
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public PathFilter getExportFilter() {
        return this.exportFilter;
    }

    @Override
    public String getRootName() {
        return this.rootName;
    }

    @Override
    public ClassSpec getClassSpec(String name) throws IOException {
        String fileName = Module.fileNameOfClass(name);
        File file = new File(this.root, fileName);
        if (!file.exists()) {
            return null;
        }
        long size = file.length();
        ClassSpec spec = new ClassSpec();
        FileInputStream is = new FileInputStream(file);
        try {
            if (size <= Integer.MAX_VALUE) {
                int res;
                int castSize = (int)size;
                byte[] bytes = new byte[castSize];
                int a = 0;
                while ((res = ((InputStream)is).read(bytes, a, castSize - a)) > 0) {
                    a += res;
                }
                ((InputStream)is).close();
                spec.setBytes(bytes);
                ClassSpec classSpec = spec;
                return classSpec;
            }
            throw new IOException("Resource is too large to be a valid class file");
        }
        finally {
            FileResourceLoader.safeClose(is);
        }
    }

    private static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public PackageSpec getPackageSpec(String name) throws IOException {
        PackageSpec spec = new PackageSpec();
        Manifest manifest = this.manifest;
        if (manifest == null) {
            return spec;
        }
        Attributes mainAttribute = manifest.getAttributes(name);
        Attributes entryAttribute = manifest.getAttributes(name);
        spec.setSpecTitle(FileResourceLoader.getDefinedAttribute(Attributes.Name.SPECIFICATION_TITLE, entryAttribute, mainAttribute));
        spec.setSpecVersion(FileResourceLoader.getDefinedAttribute(Attributes.Name.SPECIFICATION_VERSION, entryAttribute, mainAttribute));
        spec.setSpecVendor(FileResourceLoader.getDefinedAttribute(Attributes.Name.SPECIFICATION_VENDOR, entryAttribute, mainAttribute));
        spec.setImplTitle(FileResourceLoader.getDefinedAttribute(Attributes.Name.IMPLEMENTATION_TITLE, entryAttribute, mainAttribute));
        spec.setImplVersion(FileResourceLoader.getDefinedAttribute(Attributes.Name.IMPLEMENTATION_VERSION, entryAttribute, mainAttribute));
        spec.setImplVendor(FileResourceLoader.getDefinedAttribute(Attributes.Name.IMPLEMENTATION_VENDOR, entryAttribute, mainAttribute));
        if (Boolean.parseBoolean(FileResourceLoader.getDefinedAttribute(Attributes.Name.SEALED, entryAttribute, mainAttribute))) {
            spec.setSealBase(this.root.toURI().toURL());
        }
        return spec;
    }

    private static String getDefinedAttribute(Attributes.Name name, Attributes entryAttribute, Attributes mainAttribute) {
        String value;
        String string = value = entryAttribute == null ? null : entryAttribute.getValue(name);
        return value == null ? (mainAttribute == null ? null : mainAttribute.getValue(name)) : value;
    }

    @Override
    public String getLibrary(String name) {
        File file = new File(this.root, ARCH_NAME + "/" + name);
        return file.exists() ? file.getAbsolutePath() : null;
    }

    @Override
    public Resource getResource(String name) {
        try {
            File file = new File(this.root, name);
            if (!file.exists()) {
                return null;
            }
            return new FileEntryResource(name, file, file.toURI().toURL());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getPaths() {
        ArrayList<String> index = new ArrayList<String>();
        File indexFile = new File(this.root.getPath() + ".index");
        if (indexFile.exists()) {
            ArrayList<String> arrayList;
            BufferedReader r = new BufferedReader(new InputStreamReader(new FileInputStream(indexFile)));
            try {
                String s;
                while ((s = r.readLine()) != null) {
                    index.add(s.trim());
                }
                arrayList = index;
            }
            catch (Throwable throwable) {
                try {
                    r.close();
                    throw throwable;
                }
                catch (IOException e) {
                    index.clear();
                }
            }
            r.close();
            return arrayList;
        }
        index.add("");
        this.buildIndex(index, this.root, "");
        boolean ok = false;
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(indexFile)));
            try {
                for (String name : index) {
                    writer.write(name);
                    writer.write(10);
                }
                writer.close();
                ok = true;
            }
            finally {
                try {
                    writer.close();
                }
                catch (IOException e) {}
            }
        }
        catch (IOException e) {
        }
        finally {
            if (!ok) {
                indexFile.delete();
            }
        }
        return index;
    }

    private void buildIndex(List<String> index, File root, String pathBase) {
        for (File file : root.listFiles()) {
            if (!file.isDirectory()) continue;
            index.add(pathBase + file.getName());
            this.buildIndex(index, file, pathBase + file.getName() + "/");
        }
    }
}

