/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.util.ArrayList;
import java.util.List;
import org.jboss.modules.AssertionSetting;
import org.jboss.modules.Dependency;
import org.jboss.modules.LocalDependency;
import org.jboss.modules.LocalDependencySpec;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleDependency;
import org.jboss.modules.ModuleDependencySpec;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.PathFilters;
import org.jboss.modules.ResourceLoader;

public final class ModuleSpec {
    private final ModuleIdentifier moduleIdentifier;
    private final String mainClass;
    private final AssertionSetting assertionSetting;
    private final ResourceLoader[] resourceLoaders;
    private final SpecifiedDependency[] dependencies;

    private ModuleSpec(ModuleIdentifier moduleIdentifier, String mainClass, AssertionSetting assertionSetting, ResourceLoader[] resourceLoaders, SpecifiedDependency[] dependencies) {
        this.moduleIdentifier = moduleIdentifier;
        this.mainClass = mainClass;
        this.assertionSetting = assertionSetting;
        this.resourceLoaders = resourceLoaders;
        this.dependencies = dependencies;
    }

    public ModuleIdentifier getModuleIdentifier() {
        return this.moduleIdentifier;
    }

    String getMainClass() {
        return this.mainClass;
    }

    AssertionSetting getAssertionSetting() {
        return this.assertionSetting;
    }

    ResourceLoader[] getResourceLoaders() {
        return this.resourceLoaders;
    }

    SpecifiedDependency[] getDependencies() {
        return this.dependencies;
    }

    public static Builder build(final ModuleIdentifier moduleIdentifier) {
        return new Builder(){
            private boolean localAdded;
            private String mainClass;
            private AssertionSetting assertionSetting = AssertionSetting.INHERIT;
            private final List<ResourceLoader> resourceLoaders = new ArrayList<ResourceLoader>(0);
            private final List<SpecifiedDependency> dependencies = new ArrayList<SpecifiedDependency>(0);

            @Override
            public Builder addLocalDependency(LocalDependencySpec spec) {
                this.dependencies.add(new ImmediateSpecifiedDependency(new LocalDependency(spec.getExportFilter(), spec.getImportFilter(), spec.getLocalLoader(), spec.getLoaderPaths())));
                return this;
            }

            @Override
            public Builder addLocalDependency() {
                if (this.localAdded) {
                    throw new IllegalStateException("Local dependency already added");
                }
                this.localAdded = true;
                this.dependencies.add(new SpecifiedDependency(){

                    @Override
                    public Dependency getDependency(Module module) {
                        ModuleClassLoader moduleClassLoader = module.getClassLoaderPrivate();
                        return new LocalDependency(moduleClassLoader.getExportPathFilter(), PathFilters.acceptAll(), moduleClassLoader.getLocalLoader(), moduleClassLoader.getPaths());
                    }
                });
                return this;
            }

            @Override
            public Builder addModuleDependency(final ModuleDependencySpec dependencySpec) {
                final ModuleIdentifier identifier = dependencySpec.getModuleIdentifier();
                this.dependencies.add(new SpecifiedDependency(){

                    @Override
                    public Dependency getDependency(Module module) {
                        return new ModuleDependency(dependencySpec.getExportFilter(), dependencySpec.getImportFilter(), identifier, dependencySpec.isOptional());
                    }
                });
                return this;
            }

            @Override
            public Builder setMainClass(String mainClass) {
                this.mainClass = mainClass;
                return this;
            }

            @Override
            public Builder setAssertionSetting(AssertionSetting assertionSetting) {
                this.assertionSetting = assertionSetting;
                return this;
            }

            @Override
            public Builder addResourceRoot(ResourceLoader resourceLoader) {
                this.resourceLoaders.add(resourceLoader);
                return this;
            }

            @Override
            public ModuleSpec create() {
                if (!this.localAdded) {
                    this.addLocalDependency();
                }
                return new ModuleSpec(moduleIdentifier, this.mainClass, this.assertionSetting, this.resourceLoaders.toArray(new ResourceLoader[this.resourceLoaders.size()]), this.dependencies.toArray(new SpecifiedDependency[this.dependencies.size()]));
            }

            @Override
            public ModuleIdentifier getIdentifier() {
                return moduleIdentifier;
            }
        };
    }

    static final class ImmediateSpecifiedDependency
    implements SpecifiedDependency {
        private final Dependency dependency;

        ImmediateSpecifiedDependency(Dependency dependency) {
            this.dependency = dependency;
        }

        @Override
        public Dependency getDependency(Module module) {
            return this.dependency;
        }
    }

    static interface SpecifiedDependency {
        public Dependency getDependency(Module var1);
    }

    public static interface Builder {
        public Builder setMainClass(String var1);

        public Builder setAssertionSetting(AssertionSetting var1);

        public Builder addLocalDependency(LocalDependencySpec var1);

        public Builder addLocalDependency();

        public Builder addModuleDependency(ModuleDependencySpec var1);

        public Builder addResourceRoot(ResourceLoader var1);

        public ModuleSpec create();

        public ModuleIdentifier getIdentifier();
    }
}

