/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.jboss.modules.ModuleIdentifier;

final class ResourceIdentifier
implements Serializable {
    private static final long serialVersionUID = -2181205071871484104L;
    private final ModuleIdentifier moduleIdentifier;
    private final String root;
    private final String path;

    public ResourceIdentifier(ModuleIdentifier moduleIdentifier, String root, String path) {
        if (moduleIdentifier == null) {
            throw new IllegalArgumentException("mI is null");
        }
        if (root == null) {
            throw new IllegalArgumentException("root is null");
        }
        if (path == null) {
            throw new IllegalArgumentException("path is null");
        }
        this.moduleIdentifier = moduleIdentifier;
        this.root = root;
        this.path = path;
    }

    public ModuleIdentifier getModuleIdentifier() {
        return this.moduleIdentifier;
    }

    public String getRoot() {
        return this.root;
    }

    public String getPath() {
        return this.path;
    }

    public boolean equals(Object o) {
        return o instanceof ResourceIdentifier && this.equals((ResourceIdentifier)o);
    }

    public boolean equals(ResourceIdentifier o) {
        return o == this || o != null && this.moduleIdentifier.equals(o.moduleIdentifier) && this.root.equals(o.root) && this.path.equals(o.path);
    }

    public int hashCode() {
        int result = this.moduleIdentifier.hashCode();
        result = 31 * result + this.root.hashCode();
        result = 31 * result + this.path.hashCode();
        return result;
    }

    public static ResourceIdentifier fromURL(URL url) throws MalformedURLException {
        ModuleIdentifier moduleIdentifier = ModuleIdentifier.fromURL(url);
        String moduleRootSpec = url.getPath();
        int si = moduleRootSpec.indexOf(47);
        String rootSpec = si == -1 ? "" : moduleRootSpec.substring(si + 1);
        String pathSpec = url.getQuery();
        return new ResourceIdentifier(moduleIdentifier, rootSpec, pathSpec == null ? "" : pathSpec);
    }

    public static ResourceIdentifier fromURI(URI uri) throws URISyntaxException {
        String pathSpec;
        String rootSpec;
        ModuleIdentifier moduleIdentifier = ModuleIdentifier.fromURI(uri);
        String moduleFullSpec = uri.getSchemeSpecificPart();
        int si = moduleFullSpec.indexOf(47);
        int qi = moduleFullSpec.indexOf(63);
        if (qi == -1) {
            if (si == -1) {
                rootSpec = "";
                pathSpec = "";
            } else {
                rootSpec = moduleFullSpec.substring(si + 1);
                pathSpec = "";
            }
        } else if (si == -1 || si > qi) {
            rootSpec = "";
            pathSpec = moduleFullSpec.substring(qi + 1);
        } else {
            rootSpec = moduleFullSpec.substring(si + 1, qi);
            pathSpec = moduleFullSpec.substring(qi + 1);
        }
        return new ResourceIdentifier(moduleIdentifier, rootSpec, pathSpec);
    }

    public URL toURL() throws MalformedURLException {
        return this.moduleIdentifier.toURL(this.root, this.path);
    }

    public String toString() {
        return this.moduleIdentifier.toString() + "/" + this.root + "?" + this.path;
    }
}

