/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.util.ArrayList;
import java.util.List;
import org.jboss.modules.Dependency;
import org.jboss.modules.LocalDependency;
import org.jboss.modules.LocalDependencySpec;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleDependency;
import org.jboss.modules.ModuleDependencySpec;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.PathFilters;

public final class DependencySpec {
    List<SpecifiedDependency> dependencies;

    DependencySpec(List<SpecifiedDependency> dependencies) {
        this.dependencies = dependencies;
    }

    public static DependencyBuilder build() {
        return new DependencyBuilderImpl();
    }

    static final class ImmediateSpecifiedDependency
    implements SpecifiedDependency {
        private final Dependency dependency;

        ImmediateSpecifiedDependency(Dependency dependency) {
            this.dependency = dependency;
        }

        @Override
        public Dependency getDependency(Module module) {
            return this.dependency;
        }
    }

    static interface SpecifiedDependency {
        public Dependency getDependency(Module var1);
    }

    static class DependencyBuilderImpl
    implements DependencyBuilder {
        private final List<SpecifiedDependency> dependencies = new ArrayList<SpecifiedDependency>(0);
        boolean localAdded;

        DependencyBuilderImpl() {
        }

        @Override
        public DependencyBuilder addLocalDependency() {
            if (this.localAdded) {
                throw new IllegalStateException("Local dependency already added");
            }
            this.localAdded = true;
            this.dependencies.add(new SpecifiedDependency(){

                @Override
                public Dependency getDependency(Module module) {
                    ModuleClassLoader moduleClassLoader = module.getClassLoaderPrivate();
                    return new LocalDependency(moduleClassLoader.getExportPathFilter(), PathFilters.acceptAll(), moduleClassLoader.getLocalLoader(), moduleClassLoader.getPaths());
                }
            });
            return this;
        }

        @Override
        public DependencyBuilder addLocalDependency(LocalDependencySpec spec) {
            this.dependencies.add(new ImmediateSpecifiedDependency(new LocalDependency(spec.getExportFilter(), spec.getImportFilter(), spec.getLocalLoader(), spec.getLoaderPaths())));
            return this;
        }

        @Override
        public DependencyBuilder addModuleDependency(final ModuleDependencySpec dependencySpec) {
            final ModuleIdentifier identifier = dependencySpec.getModuleIdentifier();
            this.dependencies.add(new SpecifiedDependency(){

                @Override
                public Dependency getDependency(Module module) {
                    return new ModuleDependency(dependencySpec.getExportFilter(), dependencySpec.getImportFilter(), identifier, dependencySpec.isOptional());
                }
            });
            return this;
        }

        @Override
        public DependencySpec create() {
            if (!this.localAdded) {
                this.addLocalDependency();
            }
            return new DependencySpec(this.dependencies);
        }
    }

    public static interface DependencyBuilder
    extends DependencyBuilderBase {
        @Override
        public DependencyBuilder addLocalDependency(LocalDependencySpec var1);

        @Override
        public DependencyBuilder addLocalDependency();

        @Override
        public DependencyBuilder addModuleDependency(ModuleDependencySpec var1);

        public DependencySpec create();
    }

    public static interface DependencyBuilderBase {
        public DependencyBuilderBase addLocalDependency(LocalDependencySpec var1);

        public DependencyBuilderBase addLocalDependency();

        public DependencyBuilderBase addModuleDependency(ModuleDependencySpec var1);
    }
}

