/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ServiceLoader;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.PropertyReadAction;

final class ModularURLStreamHandlerFactory
implements URLStreamHandlerFactory {
    private static final PrivilegedAction<String> URL_MODULES_LIST_ACTION = new PropertyReadAction("jboss.protocol.handler.modules");

    ModularURLStreamHandlerFactory() {
    }

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        int i;
        SecurityManager sm = System.getSecurityManager();
        String urlModulesList = sm != null ? AccessController.doPrivileged(URL_MODULES_LIST_ACTION) : URL_MODULES_LIST_ACTION.run();
        if (urlModulesList == null) {
            return null;
        }
        int f = 0;
        do {
            String moduleId;
            if ((moduleId = ((i = urlModulesList.indexOf(124, f)) == -1 ? urlModulesList.substring(f) : urlModulesList.substring(f, i)).trim()).length() > 0) {
                try {
                    ModuleIdentifier identifier = ModuleIdentifier.fromString(moduleId);
                    ServiceLoader<URLStreamHandlerFactory> loader = Module.getModuleFromDefaultLoader(identifier).loadService(URLStreamHandlerFactory.class);
                    for (URLStreamHandlerFactory factory : loader) {
                        URLStreamHandler handler = factory.createURLStreamHandler(protocol);
                        if (handler == null) continue;
                        return handler;
                    }
                }
                catch (RuntimeException e) {
                }
                catch (ModuleLoadException e) {
                    // empty catch block
                }
            }
            f = i + 1;
        } while (i != -1);
        return null;
    }
}

