/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.File;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleNotFoundException;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.ModuleXmlParser;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;

public final class LocalModuleLoader
extends ModuleLoader {
    private final File[] repoRoots;
    private final PathFilter pathFilter;
    private volatile ModuleLoader[] importLoaders = NO_LOADERS;
    private static final ModuleLoader[] NO_LOADERS = new ModuleLoader[0];

    public LocalModuleLoader(File[] repoRoots) {
        this(repoRoots, PathFilters.acceptAll());
    }

    public LocalModuleLoader(File[] repoRoots, PathFilter pathFilter) {
        this.repoRoots = repoRoots;
        this.pathFilter = pathFilter;
    }

    public LocalModuleLoader() {
        String modulePath = System.getProperty("module.path", System.getenv("MODULEPATH"));
        this.repoRoots = modulePath == null ? new File[0] : LocalModuleLoader.getFiles(modulePath, 0, 0);
        this.pathFilter = PathFilters.acceptAll();
    }

    private static File[] getFiles(String modulePath, int stringIdx, int arrayIdx) {
        File[] files;
        int i = modulePath.indexOf(File.pathSeparatorChar, stringIdx);
        if (i == -1) {
            files = new File[arrayIdx + 1];
            files[arrayIdx] = new File(modulePath.substring(stringIdx)).getAbsoluteFile();
        } else {
            files = LocalModuleLoader.getFiles(modulePath, i + 1, arrayIdx + 1);
            files[arrayIdx] = new File(modulePath.substring(stringIdx, i)).getAbsoluteFile();
        }
        return files;
    }

    @Override
    protected Module preloadModule(ModuleIdentifier identifier) throws ModuleLoadException {
        Module module = super.preloadModule(identifier);
        if (module == null) {
            ModuleLoader loader;
            ModuleLoader[] arr$ = this.importLoaders;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (module = LocalModuleLoader.preloadModule(identifier, loader = arr$[i$])) == null; ++i$) {
            }
        }
        return module;
    }

    void setImportLoaders(ModuleLoader[] loaders) {
        if (loaders == null) {
            throw new IllegalArgumentException("loaders is null");
        }
        this.importLoaders = (ModuleLoader[])loaders.clone();
    }

    @Override
    protected ModuleSpec findModule(ModuleIdentifier moduleIdentifier) throws ModuleLoadException {
        String child = LocalModuleLoader.toPathString(moduleIdentifier);
        if (this.pathFilter.accept(child)) {
            for (File root : this.repoRoots) {
                File file = new File(root, child);
                File moduleXml = new File(file, "module.xml");
                if (!moduleXml.exists()) continue;
                return this.parseModuleInfoFile(moduleIdentifier, file, moduleXml);
            }
        }
        throw new ModuleNotFoundException("Module " + moduleIdentifier + " is not found in " + this);
    }

    private static String toPathString(ModuleIdentifier moduleIdentifier) {
        StringBuilder builder = new StringBuilder(40);
        builder.append(moduleIdentifier.getName().replace('.', File.separatorChar));
        builder.append(File.separatorChar).append(moduleIdentifier.getSlot());
        builder.append(File.separatorChar);
        return builder.toString();
    }

    private ModuleSpec parseModuleInfoFile(ModuleIdentifier moduleIdentifier, File moduleRoot, File moduleInfoFile) throws ModuleLoadException {
        return ModuleXmlParser.parseModuleXml(moduleIdentifier, moduleRoot, moduleInfoFile);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("local module loader @").append(Integer.toHexString(this.hashCode())).append(" (roots: ");
        int repoRootsLength = this.repoRoots.length;
        for (int i = 0; i < repoRootsLength; ++i) {
            File root = this.repoRoots[i];
            b.append(root);
            if (i == repoRootsLength - 1) continue;
            b.append(',');
        }
        b.append(')');
        return b.toString();
    }
}

