/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.util.EnumMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class ModuleLoggerFinder
extends System.LoggerFinder {
    private final Supplier<System.LoggerFinder> defaultFinder = () -> new System.LoggerFinder(){

        @Override
        public System.Logger getLogger(String name, Module module) {
            return new JulSystemLogger(Logger.getLogger(name));
        }
    };
    private static volatile ClassLoader classLoader;
    private volatile System.LoggerFinder finder;

    @Override
    public System.Logger getLogger(String name, Module module) {
        return this.resolveFinder().getLogger(name, module);
    }

    static void setClassLoader(ClassLoader cl) {
        classLoader = cl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private System.LoggerFinder resolveFinder() {
        System.LoggerFinder result = this.finder;
        if (result == null) {
            ModuleLoggerFinder moduleLoggerFinder = this;
            synchronized (moduleLoggerFinder) {
                result = this.finder;
                if (result == null) {
                    try {
                        ClassLoader cl = classLoader;
                        ServiceLoader<System.LoggerFinder> loader = ServiceLoader.load(System.LoggerFinder.class, cl == null ? ClassLoader.getSystemClassLoader() : cl);
                        for (System.LoggerFinder lf : loader) {
                            if (this.getClass().equals(lf.getClass())) continue;
                            this.finder = result = lf;
                            break;
                        }
                        if (result == null) {
                            this.finder = result = this.defaultFinder.get();
                        }
                    }
                    catch (Throwable ignore) {
                        this.finder = result = this.defaultFinder.get();
                    }
                }
            }
        }
        return result;
    }

    private static class JulSystemLogger
    implements System.Logger {
        private static final Map<System.Logger.Level, Level> LEVELS = new EnumMap<System.Logger.Level, Level>(System.Logger.Level.class);
        private final Logger delegate;

        private JulSystemLogger(Logger delegate) {
            this.delegate = delegate;
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public boolean isLoggable(System.Logger.Level level) {
            return this.delegate.isLoggable(LEVELS.getOrDefault((Object)level, Level.INFO));
        }

        @Override
        public void log(System.Logger.Level level, ResourceBundle bundle, String msg, Throwable thrown) {
            this.delegate.logrb(LEVELS.getOrDefault((Object)level, Level.INFO), bundle, msg, thrown);
        }

        @Override
        public void log(System.Logger.Level level, ResourceBundle bundle, String format, Object ... params) {
            this.delegate.logrb(LEVELS.getOrDefault((Object)level, Level.INFO), bundle, format, params);
        }

        static {
            LEVELS.put(System.Logger.Level.ALL, Level.ALL);
            LEVELS.put(System.Logger.Level.TRACE, Level.FINER);
            LEVELS.put(System.Logger.Level.DEBUG, Level.FINE);
            LEVELS.put(System.Logger.Level.INFO, Level.INFO);
            LEVELS.put(System.Logger.Level.WARNING, Level.WARNING);
            LEVELS.put(System.Logger.Level.ERROR, Level.SEVERE);
            LEVELS.put(System.Logger.Level.OFF, Level.OFF);
        }
    }
}

