/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Queue;
import org.jboss.modules.Module;
import org.jboss.modules.PropertyReadAction;
import org.jboss.modules.UnlockedReadHashMap;
import sun.misc.Unsafe;

public abstract class ConcurrentClassLoader
extends ClassLoader {
    private static final boolean LOCKLESS;
    private static final boolean SAFE_JDK;
    private static final boolean JDK7_PLUS;
    private static final ClassLoader definingLoader;
    private static final ThreadLocal<Boolean> GET_PACKAGE_SUPPRESSOR;
    protected static final Enumeration<URL> EMPTY_ENUMERATION;
    private final UnlockedReadHashMap<String, Package> packages = new UnlockedReadHashMap(64);

    protected ConcurrentClassLoader(ConcurrentClassLoader parent) {
        super(parent == null ? ConcurrentClassLoader.class.getClassLoader() : parent);
        if (JDK7_PLUS && this.getClassLoadingLock("$TEST$") == this) {
            throw new Error("Cannot instantiate non-parallel subclass");
        }
    }

    protected ConcurrentClassLoader() {
        super(ConcurrentClassLoader.class.getClassLoader());
        if (JDK7_PLUS && this.getClassLoadingLock("$TEST$") == this) {
            throw new Error("Cannot instantiate non-parallel subclass");
        }
    }

    @Override
    public final Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.performLoadClass(className, false, false);
    }

    @Override
    public final Class<?> loadClass(String className, boolean resolve) throws ClassNotFoundException {
        return this.performLoadClass(className, false, resolve);
    }

    public final Class<?> loadExportedClass(String className) throws ClassNotFoundException {
        return this.performLoadClass(className, true, false);
    }

    public final Class<?> loadExportedClass(String className, boolean resolve) throws ClassNotFoundException {
        return this.performLoadClass(className, true, resolve);
    }

    protected Class<?> findClass(String className, boolean exportsOnly, boolean resolve) throws ClassNotFoundException {
        throw new ClassNotFoundException(className);
    }

    protected final Class<?> defineOrLoadClass(String className, byte[] bytes, int off, int len) {
        try {
            Class<?> definedClass = this.defineClass(className, bytes, off, len);
            return definedClass;
        }
        catch (LinkageError e) {
            Class<?> loadedClass = this.findLoadedClass(className);
            if (loadedClass != null) {
                return loadedClass;
            }
            throw e;
        }
    }

    protected final Class<?> defineOrLoadClass(String className, byte[] bytes, int off, int len, ProtectionDomain protectionDomain) {
        try {
            Class<?> definedClass = this.defineClass(className, bytes, off, len, protectionDomain);
            return definedClass;
        }
        catch (LinkageError e) {
            Class<?> loadedClass = this.findLoadedClass(className);
            if (loadedClass != null) {
                return loadedClass;
            }
            throw e;
        }
    }

    @Override
    protected final Class<?> findClass(String className) throws ClassNotFoundException {
        return this.findClass(className, false, false);
    }

    @Override
    public final URL getResource(String name) {
        for (String s : Module.systemPaths) {
            if (!name.startsWith(s)) continue;
            return definingLoader != null ? definingLoader.getResource(name) : ClassLoader.getSystemResource(name);
        }
        return this.findResource(name, false);
    }

    @Override
    public final Enumeration<URL> getResources(String name) throws IOException {
        for (String s : Module.systemPaths) {
            if (!name.startsWith(s)) continue;
            return definingLoader != null ? definingLoader.getResources(name) : ClassLoader.getSystemResources(name);
        }
        return this.findResources(name, false);
    }

    protected URL findResource(String name, boolean exportsOnly) {
        return null;
    }

    @Override
    protected final URL findResource(String name) {
        return null;
    }

    protected Enumeration<URL> findResources(String name, boolean exportsOnly) throws IOException {
        return EMPTY_ENUMERATION;
    }

    @Override
    protected final Enumeration<URL> findResources(String name) {
        return EMPTY_ENUMERATION;
    }

    protected InputStream findResourceAsStream(String name, boolean exportsOnly) {
        URL url = this.findResource(name, exportsOnly);
        try {
            return url == null ? null : url.openStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public final InputStream getResourceAsStream(String name) {
        for (String s : Module.systemPaths) {
            if (!name.startsWith(s)) continue;
            return definingLoader != null ? definingLoader.getResourceAsStream(name) : ClassLoader.getSystemResourceAsStream(name);
        }
        return this.findResourceAsStream(name, false);
    }

    private Class<?> performLoadClass(String className, boolean exportsOnly, boolean resolve) throws ClassNotFoundException {
        if (className == null) {
            throw new IllegalArgumentException("name is null");
        }
        for (String s : Module.systemPackages) {
            if (!className.startsWith(s)) continue;
            return definingLoader != null ? definingLoader.loadClass(className) : this.findSystemClass(className);
        }
        return this.performLoadClassChecked(className, exportsOnly, resolve);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> performLoadClassChecked(String className, boolean exportsOnly, boolean resolve) throws ClassNotFoundException {
        if (SAFE_JDK) {
            return this.performLoadClassUnchecked(className, exportsOnly, resolve);
        }
        if (Thread.holdsLock(this)) {
            if (LOCKLESS) {
                Unsafe unsafe = UnsafeHolder.UNSAFE;
                unsafe.monitorExit(this);
                try {
                    Class<?> clazz = this.performLoadClassChecked(className, exportsOnly, resolve);
                    return clazz;
                }
                finally {
                    unsafe.monitorEnter(this);
                }
            }
            if (Thread.currentThread() != LoaderThreadHolder.LOADER_THREAD) {
                Queue<LoadRequest> queue;
                LoadRequest req = new LoadRequest(className, resolve, exportsOnly, this, AccessController.getContext());
                Queue<LoadRequest> queue2 = queue = LoaderThreadHolder.REQUEST_QUEUE;
                synchronized (queue2) {
                    queue.add(req);
                    queue.notify();
                }
                boolean intr = false;
                try {
                    while (!req.done) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            intr = true;
                        }
                    }
                }
                finally {
                    if (intr) {
                        Thread.currentThread().interrupt();
                    }
                }
                Class<?> result = req.result;
                if (result == null) {
                    String message = req.message;
                    throw new ClassNotFoundException(message == null ? className : message);
                }
                return result;
            }
        }
        return this.performLoadClassUnchecked(className, exportsOnly, resolve);
    }

    private Class<?> performLoadClassUnchecked(String className, boolean exportsOnly, boolean resolve) throws ClassNotFoundException {
        if (className.charAt(0) == '[') {
            Class<?> array = Class.forName(className, false, this);
            if (resolve) {
                this.resolveClass(array);
            }
            return array;
        }
        return this.findClass(className, exportsOnly, resolve);
    }

    @Override
    protected final Package getPackage(String name) {
        String packageName = name + ".";
        for (String s : Module.systemPackages) {
            if (!packageName.startsWith(s)) continue;
            return Package.getPackage(name);
        }
        if (GET_PACKAGE_SUPPRESSOR.get() == Boolean.TRUE) {
            return null;
        }
        return this.getPackageByName(name);
    }

    protected Package getPackageByName(String name) {
        Package parentPackage = super.getPackage(name);
        return parentPackage == null ? this.findLoadedPackage(name) : parentPackage;
    }

    @Override
    protected Package[] getPackages() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.addAll(this.packages.values());
        list.addAll(Arrays.asList(super.getPackages()));
        return list.toArray(new Package[list.size()]);
    }

    protected final Package findLoadedPackage(String name) {
        return this.packages.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Package definePackage(String name, String specTitle, String specVersion, String specVendor, String implTitle, String implVersion, String implVendor, URL sealBase) throws IllegalArgumentException {
        ThreadLocal<Boolean> suppressor = GET_PACKAGE_SUPPRESSOR;
        suppressor.set(Boolean.TRUE);
        try {
            Package existing = this.packages.get(name);
            if (existing != null) {
                Package package_ = existing;
                return package_;
            }
            Package pkg = super.definePackage(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
            existing = this.packages.putIfAbsent(name, pkg);
            Package package_ = existing != null ? existing : pkg;
            return package_;
        }
        finally {
            suppressor.remove();
        }
    }

    static {
        definingLoader = ConcurrentClassLoader.class.getClassLoader();
        GET_PACKAGE_SUPPRESSOR = new ThreadLocal();
        boolean jdk7plus = false;
        boolean parallelOk = true;
        try {
            jdk7plus = parallelOk = ClassLoader.registerAsParallelCapable();
        }
        catch (Throwable ignored) {
            // empty catch block
        }
        if (!parallelOk) {
            throw new Error("Failed to register " + ConcurrentClassLoader.class.getName() + " as parallel-capable");
        }
        Package.getPackages();
        boolean hasUnsafe = false;
        if (!jdk7plus) {
            try {
                Class.forName("sun.misc.Unsafe", false, null);
                hasUnsafe = true;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        boolean isJRockit = AccessController.doPrivileged(new PropertyReadAction("java.vm.name", "")).toUpperCase(Locale.US).contains("JROCKIT");
        LOCKLESS = Boolean.parseBoolean(AccessController.doPrivileged(new PropertyReadAction("jboss.modules.lockless", Boolean.toString(!jdk7plus && hasUnsafe && !isJRockit))));
        SAFE_JDK = Boolean.parseBoolean(AccessController.doPrivileged(new PropertyReadAction("jboss.modules.safe-jdk", Boolean.toString(jdk7plus || isJRockit))));
        JDK7_PLUS = jdk7plus;
        EMPTY_ENUMERATION = Collections.enumeration(Collections.emptySet());
    }

    private static final class UnsafeHolder {
        static Unsafe UNSAFE;

        private UnsafeHolder() {
        }

        static {
            try {
                Field field = Unsafe.class.getDeclaredField("theUnsafe");
                field.setAccessible(true);
                UNSAFE = (Unsafe)field.get(null);
            }
            catch (IllegalAccessException e) {
                throw new IllegalAccessError(e.getMessage());
            }
            catch (NoSuchFieldException e) {
                throw new NoSuchFieldError(e.getMessage());
            }
        }
    }

    static class LoaderThread
    extends Thread {
        LoaderThread() {
        }

        @Override
        public void interrupt() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Queue<LoadRequest> queue = LoaderThreadHolder.REQUEST_QUEUE;
            while (true) {
                try {
                    while (true) {
                        LoadRequest request;
                        Queue<LoadRequest> queue2 = queue;
                        synchronized (queue2) {
                            while ((request = queue.poll()) == null) {
                                queue.wait();
                            }
                        }
                        final ConcurrentClassLoader loader = request.requester;
                        Class result = null;
                        ConcurrentClassLoader concurrentClassLoader = loader;
                        synchronized (concurrentClassLoader) {
                            try {
                                SecurityManager sm = System.getSecurityManager();
                                if (sm != null) {
                                    final LoadRequest localRequest = request;
                                    result = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                                        @Override
                                        public Class<?> run() throws ClassNotFoundException {
                                            return loader.performLoadClassChecked(localRequest.className, localRequest.exportsOnly, localRequest.resolve);
                                        }
                                    }, request.context);
                                } else {
                                    try {
                                        result = loader.performLoadClassChecked(request.className, request.exportsOnly, request.resolve);
                                    }
                                    catch (ClassNotFoundException e) {
                                        request.message = e.getMessage();
                                    }
                                }
                            }
                            finally {
                                request.result = result;
                                request.done = true;
                                loader.notifyAll();
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    continue;
                }
                break;
            }
        }
    }

    static class LoadRequest {
        private final String className;
        private final boolean resolve;
        private final ConcurrentClassLoader requester;
        private final AccessControlContext context;
        Class<?> result;
        String message;
        private boolean exportsOnly;
        boolean done;

        LoadRequest(String className, boolean resolve, boolean exportsOnly, ConcurrentClassLoader requester, AccessControlContext context) {
            this.className = className;
            this.resolve = resolve;
            this.exportsOnly = exportsOnly;
            this.requester = requester;
            this.context = context;
        }
    }

    static final class LoaderThreadHolder {
        static final Thread LOADER_THREAD;
        static final Queue<LoadRequest> REQUEST_QUEUE;

        private LoaderThreadHolder() {
        }

        static {
            REQUEST_QUEUE = new ArrayDeque<LoadRequest>();
            LoaderThread thr = new LoaderThread();
            thr.setName("ClassLoader Thread");
            thr.setDaemon(true);
            thr.start();
            LOADER_THREAD = thr;
        }
    }
}

