/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.security.AccessController;
import java.security.Policy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.LogManager;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.modules.ClassPathModuleLoader;
import org.jboss.modules.DefaultBootModuleLoaderHolder;
import org.jboss.modules.DependencyTreeViewer;
import org.jboss.modules.JarFileResourceLoader;
import org.jboss.modules.JarModuleLoader;
import org.jboss.modules.LocalModuleFinder;
import org.jboss.modules.ModularContentHandlerFactory;
import org.jboss.modules.ModularURLStreamHandlerFactory;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleNotFoundException;
import org.jboss.modules.ModulesPolicy;
import org.jboss.modules.PreMain;
import org.jboss.modules.PropertyReadAction;
import org.jboss.modules.PropertyWriteAction;
import org.jboss.modules.SecurityActions;
import org.jboss.modules.StartTimeHolder;
import org.jboss.modules.StreamUtil;
import org.jboss.modules.log.JDKModuleLogger;

public final class Main {
    private static final String[] NO_STRINGS;
    private static final String JAR_NAME;
    private static final String VERSION_STRING;

    private Main() {
    }

    private static void usage() {
        System.out.println("Usage: java [-jvmoptions...] -jar " + Main.getJarName() + ".jar [-options...] <module-spec> [args...]");
        System.out.println("       java [-jvmoptions...] -jar " + Main.getJarName() + ".jar [-options...] -jar <jar-name> [args...]");
        System.out.println("       java [-jvmoptions...] -jar " + Main.getJarName() + ".jar [-options...] -cp <class-path> <class-name> [args...]");
        System.out.println("       java [-jvmoptions...] -jar " + Main.getJarName() + ".jar [-options...] -class <class-name> [args...]");
        System.out.println("       java [-jvmoptions...] -jar " + Main.getJarName() + ".jar -addindex [-modify] <jar-name> ");
        System.out.println("where <module-spec> is a valid module specification string");
        System.out.println("and options include:");
        System.out.println("    -help         Display this message");
        System.out.println("    -mp, -modulepath <search path of directories>");
        System.out.println("                  A list of directories, separated by '" + File.pathSeparator + "', where modules may be located");
        System.out.println("                  If not specified, the value of the \"module.path\" system property is used");
        System.out.println("    -class        Specify that the final argument is a");
        System.out.println("                  class to load from the class path; not compatible with -jar");
        System.out.println("    -cp,-classpath <search path of archives or directories>");
        System.out.println("                  A search path for class files; implies -class");
        System.out.println("    -dep,-dependencies <module-spec>[,<module-spec>,...]");
        System.out.println("                  A list of module dependencies to add to the class path;");
        System.out.println("                  requires -class or -cp");
        System.out.println("    -deptree      Print the dependency tree of the given module instead of running it");
        System.out.println("    -jar          Specify that the final argument is the name of a");
        System.out.println("                  JAR file to run as a module; not compatible with -class");
        System.out.println("    -secmgr       Run with a security manager installed; not compatible with -secmgrmodule");
        System.out.println("    -secmgrmodule <module-spec>");
        System.out.println("                  Run with a security manager module; not compatible with -secmgr");
        System.out.println("    -addindex     Specify that the final argument is a");
        System.out.println("                  jar to create an index for");
        System.out.println("    -modify       Modify the indexes jar in-place");
        System.out.println("    -version      Print version and exit\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Throwable {
        String mbeanServerBuilderName;
        String logManagerName;
        Module module;
        ModuleIdentifier moduleIdentifier;
        ModuleLoader loader;
        int argsLen = args.length;
        String deps = null;
        String[] moduleArgs = NO_STRINGS;
        String modulePath = null;
        String classpath = null;
        boolean jar = false;
        boolean classpathDefined = false;
        boolean classDefined = false;
        boolean depTree = false;
        String nameArgument = null;
        ModuleIdentifier jaxpModuleIdentifier = null;
        boolean defaultSecMgr = false;
        String secMgrModule = null;
        boolean addIndex = false;
        boolean modifyInPlace = false;
        int argsLength = argsLen;
        for (int i = 0; i < argsLength; ++i) {
            String arg = args[i];
            try {
                if (arg.charAt(0) == '-') {
                    if ("-version".equals(arg)) {
                        System.out.println("JBoss Modules version " + Main.getVersionString());
                        return;
                    }
                    if ("-help".equals(arg)) {
                        Main.usage();
                        return;
                    }
                    if ("-addindex".equals(arg)) {
                        addIndex = true;
                        continue;
                    }
                    if ("-modify".equals(arg)) {
                        modifyInPlace = true;
                        continue;
                    }
                    if ("-modulepath".equals(arg) || "-mp".equals(arg)) {
                        if (modulePath != null) {
                            System.err.println("Module path may only be specified once");
                            System.exit(1);
                        }
                        modulePath = args[++i];
                        System.setProperty("module.path", modulePath);
                        continue;
                    }
                    if ("-config".equals(arg)) {
                        System.err.println("Config files are no longer supported.  Use the -mp option instead");
                        System.exit(1);
                        continue;
                    }
                    if ("-deptree".equals(arg)) {
                        if (depTree) {
                            System.err.println("-deptree may only be specified once");
                            System.exit(1);
                        }
                        if (jar) {
                            System.err.println("-deptree may not be specified with -jar");
                            System.exit(1);
                        }
                        if (classDefined) {
                            System.err.println("-deptree may not be specified with -class");
                            System.exit(1);
                        }
                        if (classpathDefined) {
                            System.err.println("-deptree may not be specified with -classpath");
                            System.exit(1);
                        }
                        depTree = true;
                        continue;
                    }
                    if ("-jaxpmodule".equals(arg)) {
                        jaxpModuleIdentifier = ModuleIdentifier.fromString(args[++i]);
                        continue;
                    }
                    if ("-jar".equals(arg)) {
                        if (jar) {
                            System.err.println("-jar flag may only be specified once");
                            System.exit(1);
                        }
                        if (classpathDefined) {
                            System.err.println("-cp/-classpath may not be specified with -jar");
                            System.exit(1);
                        }
                        if (classDefined) {
                            System.err.println("-class may not be specified with -jar");
                            System.exit(1);
                        }
                        if (depTree) {
                            System.err.println("-deptree may not be specified with -jar");
                            System.exit(1);
                        }
                        jar = true;
                        continue;
                    }
                    if ("-cp".equals(arg) || "-classpath".equals(arg)) {
                        if (classpathDefined) {
                            System.err.println("-cp or -classpath may only be specified once.");
                            System.exit(1);
                        }
                        if (classDefined) {
                            System.err.println("-class may not be specified with -cp/classpath");
                            System.exit(1);
                        }
                        if (jar) {
                            System.err.println("-cp/-classpath may not be specified with -jar");
                            System.exit(1);
                        }
                        if (depTree) {
                            System.err.println("-deptree may not be specified with -classpath");
                            System.exit(1);
                        }
                        classpathDefined = true;
                        classpath = args[++i];
                        AccessController.doPrivileged(new PropertyWriteAction("java.class.path", classpath));
                        continue;
                    }
                    if ("-dep".equals(arg) || "-dependencies".equals(arg)) {
                        if (deps != null) {
                            System.err.println("-dep or -dependencies may only be specified once.");
                            System.exit(1);
                        }
                        deps = args[++i];
                        continue;
                    }
                    if ("-class".equals(arg)) {
                        if (classDefined) {
                            System.err.println("-class flag may only be specified once");
                            System.exit(1);
                        }
                        if (classpathDefined) {
                            System.err.println("-class may not be specified with -cp/classpath");
                            System.exit(1);
                        }
                        if (jar) {
                            System.err.println("-class may not be specified with -jar");
                            System.exit(1);
                        }
                        if (depTree) {
                            System.err.println("-deptree may not be specified with -class");
                            System.exit(1);
                        }
                        classDefined = true;
                        continue;
                    }
                    if ("-logmodule".equals(arg)) {
                        System.err.println("WARNING: -logmodule is deprecated. Please use the system property 'java.util.logging.manager' or the 'java.util.logging.LogManager' service loader.");
                        ++i;
                        continue;
                    }
                    if ("-secmgr".equals(arg)) {
                        if (defaultSecMgr) {
                            System.err.println("-secmgr may only be specified once");
                            System.exit(1);
                        }
                        if (secMgrModule != null) {
                            System.err.println("-secmgr may not be specified when -secmgrmodule is given");
                            System.exit(1);
                        }
                        defaultSecMgr = true;
                        continue;
                    }
                    if ("-secmgrmodule".equals(arg)) {
                        if (secMgrModule != null) {
                            System.err.println("-secmgrmodule may only be specified once");
                            System.exit(1);
                        }
                        if (defaultSecMgr) {
                            System.err.println("-secmgrmodule may not be specified when -secmgr is given");
                            System.exit(1);
                        }
                        secMgrModule = args[++i];
                        continue;
                    }
                    System.err.printf("Invalid option '%s'\n", arg);
                    Main.usage();
                    System.exit(1);
                    continue;
                }
                nameArgument = arg;
                int cnt = argsLen - i - 1;
                moduleArgs = new String[cnt];
                System.arraycopy(args, i + 1, moduleArgs, 0, cnt);
                break;
            }
            catch (IndexOutOfBoundsException e) {
                System.err.printf("Argument expected for option %s\n", arg);
                Main.usage();
                System.exit(1);
            }
        }
        if (modifyInPlace && !addIndex) {
            System.err.println("-modify requires -addindex");
            Main.usage();
            System.exit(1);
        }
        if (addIndex) {
            if (nameArgument == null) {
                System.err.println("-addindex requires a target JAR name");
                Main.usage();
                System.exit(1);
            }
            if (modulePath != null) {
                System.err.println("-mp may not be used with -addindex");
                Main.usage();
                System.exit(1);
            }
            if (jaxpModuleIdentifier != null) {
                System.err.println("-jaxpModuleIdentifier may not be used with -addindex");
                Main.usage();
                System.exit(1);
            }
            if (classpathDefined) {
                System.err.println("-cp or -classpath may not be used with -addindex");
                Main.usage();
                System.exit(1);
            }
            if (classDefined) {
                System.err.println("-class may not be used with -addindex");
                Main.usage();
                System.exit(1);
            }
            if (jar) {
                System.err.println("-jar may not be used with -addindex");
                Main.usage();
                System.exit(1);
            }
            if (deps != null) {
                System.err.println("-deps may not be used with -addindex");
                Main.usage();
                System.exit(1);
            }
            if (defaultSecMgr) {
                System.err.println("-secmgr may not be used with -addindex");
                Main.usage();
                System.exit(1);
            }
            if (secMgrModule != null) {
                System.err.println("-secmgrmodule may not be used with -addindex");
                Main.usage();
                System.exit(1);
            }
            if (depTree) {
                System.err.println("-deptree may not be used with -addindex");
                Main.usage();
                System.exit(1);
            }
            JarFileResourceLoader.addInternalIndex(new File(nameArgument), modifyInPlace);
            return;
        }
        if (deps != null && !classDefined && !classpathDefined) {
            System.err.println("-deps may only be specified when -cp/-classpath or -class is in use");
            System.exit(1);
        }
        if (nameArgument == null) {
            if (classDefined || classpathDefined) {
                System.err.println("No class name specified");
            } else if (jar) {
                System.err.println("No JAR specified");
            } else {
                System.err.println("No module specified");
            }
            Main.usage();
            System.exit(1);
        }
        if (depTree) {
            DependencyTreeViewer.print(new PrintWriter(System.out), ModuleIdentifier.fromString(nameArgument), LocalModuleFinder.getRepoRoots(true));
            System.exit(0);
        }
        ModuleLoader environmentLoader = DefaultBootModuleLoaderHolder.INSTANCE;
        if (jar) {
            loader = new JarModuleLoader(environmentLoader, new JarFile(nameArgument));
            moduleIdentifier = ((JarModuleLoader)loader).getMyIdentifier();
        } else if (classpathDefined || classDefined) {
            loader = new ClassPathModuleLoader(environmentLoader, nameArgument, classpath, deps);
            moduleIdentifier = ModuleIdentifier.CLASSPATH;
        } else {
            loader = environmentLoader;
            moduleIdentifier = ModuleIdentifier.fromString(nameArgument);
        }
        Module.initBootModuleLoader(loader);
        try {
            module = loader.loadModule(moduleIdentifier);
        }
        catch (ModuleNotFoundException e) {
            e.printStackTrace(System.err);
            System.exit(1);
            return;
        }
        String ourJavaVersion = AccessController.doPrivileged(new PropertyReadAction("java.specification.version", "1.6"));
        String requireJavaVersion = module.getProperty("jboss.require-java-version", ourJavaVersion);
        Pattern versionPattern = Pattern.compile("1\\.(\\d+)");
        Matcher requireMatcher = versionPattern.matcher(requireJavaVersion);
        Matcher ourMatcher = versionPattern.matcher(ourJavaVersion);
        if (requireMatcher.matches() && ourMatcher.matches() && Integer.valueOf(requireMatcher.group(1)) > Integer.valueOf(ourMatcher.group(1))) {
            System.err.printf("This application requires Java specification version %s or later to run (this Java virtual machine implements specification version %s)%n", requireJavaVersion, ourJavaVersion);
            System.exit(1);
        }
        ModularURLStreamHandlerFactory.addHandlerModule(module);
        ModularContentHandlerFactory.addHandlerModule(module);
        SecurityManager existingSecMgr = System.getSecurityManager();
        if (existingSecMgr != null) {
            System.err.println("An existing security manager was detected.  You must use the -secmgr switch to start with a security manager.");
            System.exit(1);
            return;
        }
        try {
            Iterator<Policy> iterator = module.loadService(Policy.class).iterator();
            if (iterator.hasNext()) {
                Policy.setPolicy(iterator.next());
            }
        }
        catch (Exception iterator) {
            // empty catch block
        }
        ModulesPolicy policy = new ModulesPolicy(Policy.getPolicy());
        Policy.setPolicy(policy);
        if (secMgrModule != null) {
            Module loadedModule;
            try {
                loadedModule = loader.loadModule(ModuleIdentifier.fromString(secMgrModule));
            }
            catch (ModuleNotFoundException e) {
                e.printStackTrace(System.err);
                System.exit(1);
                return;
            }
            Iterator<SecurityManager> iterator = ServiceLoader.load(SecurityManager.class, loadedModule.getClassLoaderPrivate()).iterator();
            if (iterator.hasNext()) {
                System.setSecurityManager(iterator.next());
            } else {
                System.err.println("No security manager found in module " + secMgrModule);
                System.exit(1);
            }
        }
        if (defaultSecMgr) {
            Iterator<SecurityManager> iterator = module.loadService(SecurityManager.class).iterator();
            if (iterator.hasNext()) {
                System.setSecurityManager(iterator.next());
            } else {
                System.setSecurityManager(new SecurityManager());
            }
        }
        ModuleClassLoader bootClassLoader = module.getClassLoaderPrivate();
        SecurityActions.setContextClassLoader(bootClassLoader);
        String serviceName = Main.getServiceName(bootClassLoader, "java.util.prefs.PreferencesFactory");
        if (serviceName != null) {
            String old = System.setProperty("java.util.prefs.PreferencesFactory", serviceName);
            try {
                Preferences.systemRoot();
            }
            finally {
                if (old == null) {
                    System.clearProperty("java.util.prefs.PreferencesFactory");
                } else {
                    System.setProperty("java.util.prefs.PreferencesFactory", old);
                }
            }
        }
        if ((logManagerName = Main.getServiceName(bootClassLoader, "java.util.logging.LogManager")) != null) {
            System.setProperty("java.util.logging.manager", logManagerName);
            if (LogManager.getLogManager().getClass() == LogManager.class) {
                System.err.println("WARNING: Failed to load the specified log manager class " + logManagerName);
            } else {
                Module.setModuleLogger(new JDKModuleLogger());
            }
        }
        if ((mbeanServerBuilderName = Main.getServiceName(bootClassLoader, "javax.management.MBeanServerBuilder")) != null) {
            System.setProperty("javax.management.builder.initial", mbeanServerBuilderName);
            ManagementFactory.getPlatformMBeanServer();
        }
        ModuleLoader.installMBeanServer();
        ArrayList<String> argsList = new ArrayList<String>(moduleArgs.length);
        Collections.addAll(argsList, moduleArgs);
        ServiceLoader<PreMain> preMainServiceLoader = ServiceLoader.load(PreMain.class, bootClassLoader);
        for (PreMain preMain : preMainServiceLoader) {
            preMain.run(argsList);
        }
        try {
            module.run(argsList.toArray(new String[argsList.size()]));
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getServiceName(ClassLoader classLoader, String className) throws IOException {
        InputStream stream = classLoader.getResourceAsStream("META-INF/services/" + className);
        if (stream == null) {
            return null;
        }
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            while ((line = reader.readLine()) != null) {
                int i = line.indexOf(35);
                if (i != -1) {
                    line = line.substring(0, i);
                }
                if ((line = line.trim()).length() == 0) continue;
                String string = line;
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            StreamUtil.safeClose(stream);
        }
    }

    public static String getJarName() {
        return JAR_NAME;
    }

    public static String getVersionString() {
        return VERSION_STRING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        long l = StartTimeHolder.START_TIME;
        NO_STRINGS = new String[0];
        String jarName = "(unknown)";
        String versionString = "(unknown)";
        try {
            Enumeration<URL> resources;
            ClassLoader classLoader = Main.class.getClassLoader();
            Enumeration<URL> enumeration = resources = classLoader == null ? ModuleClassLoader.getSystemResources("META-INF/MANIFEST.MF") : classLoader.getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                try {
                    InputStream stream = url.openStream();
                    if (stream == null) continue;
                    try {
                        Manifest manifest = new Manifest(stream);
                        Attributes mainAttributes = manifest.getMainAttributes();
                        if (mainAttributes == null || !"JBoss Modules".equals(mainAttributes.getValue("Specification-Title"))) continue;
                        jarName = mainAttributes.getValue("Jar-Name");
                        versionString = mainAttributes.getValue("Jar-Version");
                    }
                    finally {
                        StreamUtil.safeClose(stream);
                    }
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        JAR_NAME = jarName;
        VERSION_STRING = versionString;
    }
}

