/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.AccessController;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jboss.modules.FastCopyHashSet;
import org.jboss.modules.PropertyReadAction;
import org.jboss.modules.StreamUtil;

final class JDKPaths {
    static final Set<String> JDK;
    static final boolean isJDK9orAbove;
    private static final String JDK9_CLASS = "java.lang.reflect.Module";

    private JDKPaths() {
    }

    private static void processRuntimeImages(Set<String> jarSet) {
        try {
            for (Path root : FileSystems.getFileSystem(new URI("jrt:/")).getRootDirectories()) {
                Files.walkFileTree(root, new JrtFileVisitor(jarSet));
            }
        }
        catch (IOException | URISyntaxException e) {
            throw new IllegalStateException("Unable to process java runtime images");
        }
    }

    private static void processClassPathItem(String classPath, Set<String> jarSet, Set<String> pathSet) {
        int e;
        if (classPath == null) {
            return;
        }
        int s = 0;
        do {
            String item;
            String string = item = (e = classPath.indexOf(File.pathSeparatorChar, s)) == -1 ? classPath.substring(s) : classPath.substring(s, e);
            if (!jarSet.contains(item)) {
                File file = new File(item);
                if (file.isDirectory()) {
                    JDKPaths.processDirectory0(pathSet, file);
                } else {
                    try {
                        JDKPaths.processJar(pathSet, file);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            s = e + 1;
        } while (e != -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void processJar(Set<String> pathSet, File file) throws IOException {
        ZipFile zipFile = new ZipFile(file);
        try {
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                int lastSlash = name.lastIndexOf(47);
                if (lastSlash == -1) continue;
                pathSet.add(name.substring(0, lastSlash));
            }
            zipFile.close();
        }
        finally {
            StreamUtil.safeClose(zipFile);
        }
    }

    static void processDirectory0(Set<String> pathSet, File file) {
        for (File entry : file.listFiles()) {
            if (entry.isDirectory()) {
                JDKPaths.processDirectory1(pathSet, entry, file.getPath());
                continue;
            }
            String parent = entry.getParent();
            if (parent == null) continue;
            pathSet.add(parent);
        }
    }

    private static void processDirectory1(Set<String> pathSet, File file, String pathBase) {
        for (File entry : file.listFiles()) {
            if (entry.isDirectory()) {
                JDKPaths.processDirectory1(pathSet, entry, pathBase);
                continue;
            }
            String packagePath = entry.getParent();
            if (packagePath == null) continue;
            if ((packagePath = packagePath.substring(pathBase.length()).replace('\\', '/')).startsWith("/")) {
                packagePath = packagePath.substring(1);
            }
            pathSet.add(packagePath);
        }
    }

    static {
        Class<?> moduleClass = null;
        try {
            moduleClass = JDKPaths.class.getClassLoader().loadClass(JDK9_CLASS);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        isJDK9orAbove = moduleClass != null;
        FastCopyHashSet<String> pathSet = new FastCopyHashSet<String>(1024);
        FastCopyHashSet<String> jarSet = new FastCopyHashSet<String>(1024);
        if (isJDK9orAbove) {
            JDKPaths.processRuntimeImages(pathSet);
        } else {
            String sunBootClassPath = AccessController.doPrivileged(new PropertyReadAction("sun.boot.class.path"));
            JDKPaths.processClassPathItem(sunBootClassPath, jarSet, pathSet);
        }
        if (pathSet.size() == 0) {
            throw new IllegalStateException("Something went wrong with system paths set up");
        }
        String javaClassPath = AccessController.doPrivileged(new PropertyReadAction("java.class.path"));
        JDKPaths.processClassPathItem(javaClassPath, jarSet, pathSet);
        pathSet.add("org/jboss/modules");
        pathSet.add("org/jboss/modules/filter");
        pathSet.add("org/jboss/modules/log");
        pathSet.add("org/jboss/modules/management");
        pathSet.add("org/jboss/modules/ref");
        JDK = Collections.unmodifiableSet(pathSet);
    }

    private static class JrtFileVisitor
    implements FileVisitor<Path> {
        private final String SLASH = "/";
        private final String PACKAGES = "/packages";
        private final Set<String> jarSet;

        private JrtFileVisitor(Set<String> jarSet) {
            this.jarSet = jarSet;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            String d = dir.toString();
            return d.equals("/") || d.startsWith("/packages") ? FileVisitResult.CONTINUE : FileVisitResult.SKIP_SUBTREE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            String f = file.toString();
            String packageName = f.substring("/packages".length() + 1, f.lastIndexOf("/")).replace('.', '/');
            this.jarSet.add(packageName);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }
    }
}

