/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules.maven;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.jar.JarFile;
import org.jboss.modules.Module;
import org.jboss.modules.ResourceLoader;
import org.jboss.modules.ResourceLoaders;
import org.jboss.modules.maven.ArtifactCoordinates;
import org.jboss.modules.maven.JDKSpecific;
import org.jboss.modules.maven.MavenResolver;
import org.jboss.modules.maven.MavenSettings;

public final class MavenArtifactUtil {
    static final Object artifactLock = new Object();

    public static File resolveJarArtifact(ArtifactCoordinates coordinates) throws IOException {
        return MavenArtifactUtil.resolveArtifact(coordinates, "jar");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File resolveArtifact(ArtifactCoordinates coordinates, String packaging) throws IOException {
        String artifactRelativePath = coordinates.relativeArtifactPath(File.separatorChar);
        String artifactRelativeHttpPath = coordinates.relativeArtifactPath('/');
        MavenSettings settings = MavenSettings.getSettings();
        Path localRepository = settings.getLocalRepository();
        File localRepositoryFile = localRepository.toFile();
        String pomPath = artifactRelativePath + ".pom";
        Object object = artifactLock;
        synchronized (object) {
            if ("pom".equals(packaging)) {
                Path fp = localRepository.resolve(pomPath);
                if (Files.exists(fp, new LinkOption[0])) {
                    return fp.toFile();
                }
                List<String> remoteRepos = settings.getRemoteRepositories();
                if (remoteRepos.isEmpty()) {
                    return null;
                }
                File pomFile = new File(localRepositoryFile, pomPath);
                for (String remoteRepository : remoteRepos) {
                    try {
                        String remotePomPath = remoteRepository + artifactRelativeHttpPath + ".pom";
                        MavenArtifactUtil.downloadFile(coordinates + ":" + packaging, remotePomPath, pomFile);
                        if (!pomFile.exists()) continue;
                        return pomFile;
                    }
                    catch (IOException e) {
                        Module.getModuleLogger().trace((Throwable)e, "Could not download '%s' from '%s' repository", (Object)artifactRelativePath, (Object)remoteRepository);
                    }
                }
            } else {
                String coordinatesClassifier = coordinates.getClassifier();
                String classifier = coordinatesClassifier.isEmpty() ? "" : "-" + coordinatesClassifier;
                String artifactPath = artifactRelativePath + classifier + "." + packaging;
                Path fp = localRepository.resolve(artifactPath);
                if (Files.exists(fp, new LinkOption[0])) {
                    return fp.toFile();
                }
                List<String> remoteRepos = settings.getRemoteRepositories();
                if (remoteRepos.isEmpty()) {
                    return null;
                }
                File artifactFile = new File(localRepositoryFile, artifactPath);
                File pomFile = new File(localRepositoryFile, pomPath);
                for (String remoteRepository : remoteRepos) {
                    try {
                        String remotePomPath = remoteRepository + artifactRelativeHttpPath + ".pom";
                        String remoteArtifactPath = remoteRepository + artifactRelativeHttpPath + classifier + "." + packaging;
                        MavenArtifactUtil.downloadFile(coordinates + ":pom", remotePomPath, pomFile);
                        if (!pomFile.exists()) continue;
                        MavenArtifactUtil.downloadFile(coordinates + ":" + packaging, remoteArtifactPath, artifactFile);
                        if (!artifactFile.exists()) continue;
                        return artifactFile;
                    }
                    catch (IOException e) {
                        Module.getModuleLogger().trace((Throwable)e, "Could not download '%s' from '%s' repository", (Object)artifactRelativePath, (Object)remoteRepository);
                    }
                }
            }
            Module.getModuleLogger().trace("Could not find in any remote repository");
            return null;
        }
    }

    static void downloadFile(String artifact, String src, File dest) throws IOException {
        if (dest.exists()) {
            return;
        }
        URL url = new URL(src);
        URLConnection connection = url.openConnection();
        boolean message = Boolean.getBoolean("maven.download.message");
        try (InputStream bis = connection.getInputStream();){
            dest.getParentFile().mkdirs();
            if (message) {
                System.out.println("Downloading " + artifact);
            }
            Files.copy(bis, dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public static ResourceLoader createMavenArtifactLoader(String name) throws IOException {
        return MavenArtifactUtil.createMavenArtifactLoader(MavenResolver.createDefaultResolver(), name);
    }

    public static ResourceLoader createMavenArtifactLoader(MavenResolver mavenResolver, String name) throws IOException {
        File fp = mavenResolver.resolveJarArtifact(ArtifactCoordinates.fromString(name));
        if (fp == null) {
            return null;
        }
        JarFile jarFile = JDKSpecific.getJarFile(fp, true);
        return ResourceLoaders.createJarResourceLoader(name, jarFile);
    }

    static <T> T doIo(PrivilegedExceptionAction<T> action) throws IOException {
        try {
            return AccessController.doPrivileged(action);
        }
        catch (PrivilegedActionException e) {
            try {
                throw e.getCause();
            }
            catch (IOException | Error | RuntimeException e1) {
                throw e1;
            }
            catch (Throwable t) {
                throw new UndeclaredThrowableException(t);
            }
        }
    }

    static <T> T doIo(PrivilegedExceptionAction<T> action, AccessControlContext context) throws IOException {
        try {
            return AccessController.doPrivileged(action, context);
        }
        catch (PrivilegedActionException e) {
            try {
                throw e.getCause();
            }
            catch (IOException | Error | RuntimeException e1) {
                throw e1;
            }
            catch (Throwable t) {
                throw new UndeclaredThrowableException(t);
            }
        }
    }
}

