/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules.xml;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AllPermission;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jboss.modules.AssertionSetting;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.LocalDependencySpecBuilder;
import org.jboss.modules.ModuleDependencySpecBuilder;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.NativeLibraryResourceLoader;
import org.jboss.modules.PathUtils;
import org.jboss.modules.ResourceLoader;
import org.jboss.modules.ResourceLoaderSpec;
import org.jboss.modules.ResourceLoaders;
import org.jboss.modules.Version;
import org.jboss.modules.filter.MultiplePathFilterBuilder;
import org.jboss.modules.filter.PathFilter;
import org.jboss.modules.filter.PathFilters;
import org.jboss.modules.maven.ArtifactCoordinates;
import org.jboss.modules.maven.MavenArtifactUtil;
import org.jboss.modules.maven.MavenResolver;
import org.jboss.modules.security.FactoryPermissionCollection;
import org.jboss.modules.security.ModularPermissionFactory;
import org.jboss.modules.security.PermissionFactory;
import org.jboss.modules.xml.JDKSpecific;
import org.jboss.modules.xml.MXParser;
import org.jboss.modules.xml.PolicyExpander;
import org.jboss.modules.xml.SystemPropertyConditionBuilder;
import org.jboss.modules.xml.XmlPullParser;
import org.jboss.modules.xml.XmlPullParserException;

public final class ModuleXmlParser {
    private static final String MODULE_1_0 = "urn:jboss:module:1.0";
    private static final String MODULE_1_1 = "urn:jboss:module:1.1";
    private static final String MODULE_1_2 = "urn:jboss:module:1.2";
    private static final String MODULE_1_3 = "urn:jboss:module:1.3";
    private static final String MODULE_1_5 = "urn:jboss:module:1.5";
    private static final String MODULE_1_6 = "urn:jboss:module:1.6";
    private static final String MODULE_1_7 = "urn:jboss:module:1.7";
    private static final String E_MODULE = "module";
    private static final String E_ARTIFACT = "artifact";
    private static final String E_NATIVE_ARTIFACT = "native-artifact";
    private static final String E_DEPENDENCIES = "dependencies";
    private static final String E_RESOURCES = "resources";
    private static final String E_MAIN_CLASS = "main-class";
    private static final String E_RESOURCE_ROOT = "resource-root";
    private static final String E_PATH = "path";
    private static final String E_EXPORTS = "exports";
    private static final String E_IMPORTS = "imports";
    private static final String E_INCLUDE = "include";
    private static final String E_EXCLUDE = "exclude";
    private static final String E_INCLUDE_SET = "include-set";
    private static final String E_EXCLUDE_SET = "exclude-set";
    private static final String E_FILTER = "filter";
    private static final String E_SYSTEM = "system";
    private static final String E_PATHS = "paths";
    private static final String E_MODULE_ALIAS = "module-alias";
    private static final String E_MODULE_ABSENT = "module-absent";
    private static final String E_PROPERTIES = "properties";
    private static final String E_PROPERTY = "property";
    private static final String E_PERMISSIONS = "permissions";
    private static final String E_GRANT = "grant";
    private static final String E_CONDITIONS = "conditions";
    private static final String E_PROPERTY_EQUAL = "property-equal";
    private static final String E_PROPERTY_NOT_EQUAL = "property-not-equal";
    private static final String A_NAME = "name";
    private static final String A_SLOT = "slot";
    private static final String A_EXPORT = "export";
    private static final String A_SERVICES = "services";
    private static final String A_PATH = "path";
    private static final String A_OPTIONAL = "optional";
    private static final String A_TARGET_NAME = "target-name";
    private static final String A_TARGET_SLOT = "target-slot";
    private static final String A_VALUE = "value";
    private static final String A_PERMISSION = "permission";
    private static final String A_ACTIONS = "actions";
    private static final String A_VERSION = "version";
    private static final String D_NONE = "none";
    private static final String D_IMPORT = "import";
    private static final String D_EXPORT = "export";
    private static final List<String> LIST_A_NAME = Collections.singletonList("name");
    private static final List<String> LIST_A_PATH = Collections.singletonList("path");
    private static final List<String> LIST_A_NAME_A_SLOT = Arrays.asList("name", "slot");
    private static final List<String> LIST_A_NAME_A_TARGET_NAME = Arrays.asList("name", "target-name");
    private static final List<String> LIST_A_PERMISSION_A_NAME = Arrays.asList("permission", "name");
    private static final AllPermission ALL_PERMISSION = new AllPermission();
    static final Permissions DEFAULT_PERMISSION_COLLECTION = ModuleXmlParser.getAllPermission();

    private ModuleXmlParser() {
    }

    @Deprecated
    public static ModuleSpec parseModuleXml(ModuleLoader moduleLoader, ModuleIdentifier moduleIdentifier, File root, File moduleInfoFile) throws ModuleLoadException, IOException {
        return ModuleXmlParser.parseModuleXml(moduleLoader, moduleIdentifier.toString(), root, moduleInfoFile);
    }

    public static ModuleSpec parseModuleXml(ModuleLoader moduleLoader, String moduleName, File root, File moduleInfoFile) throws ModuleLoadException, IOException {
        return ModuleXmlParser.parseModuleXml(ResourceRootFactory.getDefault(), moduleLoader, moduleName, root, moduleInfoFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModuleSpec parseModuleXml(ResourceRootFactory factory, ModuleLoader moduleLoader, String moduleName, File root, File moduleInfoFile) throws ModuleLoadException, IOException {
        FileInputStream fis;
        try {
            fis = new FileInputStream(moduleInfoFile);
        }
        catch (FileNotFoundException e) {
            throw new ModuleLoadException("No module.xml file found at " + moduleInfoFile);
        }
        try {
            ModuleSpec moduleSpec = ModuleXmlParser.parseModuleXml(factory, root.getPath(), (InputStream)new BufferedInputStream(fis), moduleInfoFile.getPath(), moduleLoader, moduleName);
            return moduleSpec;
        }
        finally {
            ModuleXmlParser.safeClose(fis);
        }
    }

    @Deprecated
    public static ModuleSpec parseModuleXml(ResourceRootFactory factory, String rootPath, InputStream source, String moduleInfoFile, ModuleLoader moduleLoader, ModuleIdentifier moduleIdentifier) throws ModuleLoadException, IOException {
        return ModuleXmlParser.parseModuleXml(factory, MavenResolver.createDefaultResolver(), rootPath, source, moduleInfoFile, moduleLoader, moduleIdentifier);
    }

    public static ModuleSpec parseModuleXml(ResourceRootFactory factory, String rootPath, InputStream source, String moduleInfoFile, ModuleLoader moduleLoader, String moduleName) throws ModuleLoadException, IOException {
        return ModuleXmlParser.parseModuleXml(factory, MavenResolver.createDefaultResolver(), rootPath, source, moduleInfoFile, moduleLoader, moduleName);
    }

    @Deprecated
    public static ModuleSpec parseModuleXml(ResourceRootFactory factory, MavenResolver mavenResolver, String rootPath, InputStream source, String moduleInfoFile, ModuleLoader moduleLoader, ModuleIdentifier moduleIdentifier) throws ModuleLoadException, IOException {
        return ModuleXmlParser.parseModuleXml(factory, mavenResolver, rootPath, source, moduleInfoFile, moduleLoader, moduleIdentifier.toString());
    }

    public static ModuleSpec parseModuleXml(ResourceRootFactory factory, MavenResolver mavenResolver, String rootPath, InputStream source, String moduleInfoFile, ModuleLoader moduleLoader, String moduleName) throws ModuleLoadException, IOException {
        try {
            MXParser parser = new MXParser();
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            parser.setInput(source, null);
            ModuleSpec moduleSpec = ModuleXmlParser.parseDocument(mavenResolver, factory, rootPath, parser, moduleLoader, moduleName);
            return moduleSpec;
        }
        catch (XmlPullParserException e) {
            throw new ModuleLoadException("Error loading module from " + moduleInfoFile, e);
        }
        finally {
            ModuleXmlParser.safeClose(source);
        }
    }

    public static XmlPullParserException unexpectedContent(XmlPullParser reader) {
        String kind;
        switch (reader.getEventType()) {
            case 5: {
                kind = "cdata";
                break;
            }
            case 9: {
                kind = "comment";
                break;
            }
            case 10: {
                kind = "document decl";
                break;
            }
            case 1: {
                kind = "document end";
                break;
            }
            case 3: {
                kind = "element end";
                break;
            }
            case 6: {
                kind = "entity ref";
                break;
            }
            case 8: {
                kind = "processing instruction";
                break;
            }
            case 7: {
                kind = "whitespace";
                break;
            }
            case 0: {
                kind = "document start";
                break;
            }
            case 2: {
                kind = "element start";
                break;
            }
            case 4: {
                kind = "text";
                break;
            }
            default: {
                kind = "unknown";
            }
        }
        StringBuilder b = new StringBuilder("Unexpected content of type '").append(kind).append('\'');
        if (reader.getName() != null) {
            b.append(" named '").append(reader.getName()).append('\'');
        }
        if (reader.getText() != null) {
            b.append(", text is: '").append(reader.getText()).append('\'');
        }
        return new XmlPullParserException(b.toString(), reader, null);
    }

    public static XmlPullParserException endOfDocument(XmlPullParser reader) {
        return new XmlPullParserException("Unexpected end of document", reader, null);
    }

    private static XmlPullParserException invalidModuleName(XmlPullParser reader, String expected) {
        return new XmlPullParserException("Invalid/mismatched module name (expected " + expected + ")", reader, null);
    }

    private static XmlPullParserException missingAttributes(XmlPullParser reader, Set<String> required) {
        StringBuilder b = new StringBuilder("Missing one or more required attributes:");
        for (String attribute : required) {
            b.append(' ').append(attribute);
        }
        return new XmlPullParserException(b.toString(), reader, null);
    }

    static XmlPullParserException unknownAttribute(XmlPullParser parser, int index) {
        String namespace = parser.getAttributeNamespace(index);
        String prefix = parser.getAttributePrefix(index);
        String name = parser.getAttributeName(index);
        StringBuilder eb = new StringBuilder("Unknown attribute \"");
        if (prefix != null) {
            eb.append(prefix).append(':');
        }
        eb.append(name);
        if (namespace != null) {
            eb.append("\" from namespace \"").append(namespace);
        }
        eb.append('\"');
        return new XmlPullParserException(eb.toString(), parser, null);
    }

    private static XmlPullParserException unknownAttributeValue(XmlPullParser parser, int index) {
        String namespace = parser.getAttributeNamespace(index);
        String prefix = parser.getAttributePrefix(index);
        String name = parser.getAttributeName(index);
        StringBuilder eb = new StringBuilder("Unknown value \"");
        eb.append(parser.getAttributeValue(index));
        eb.append("\" for attribute \"");
        if (prefix != null && !prefix.isEmpty()) {
            eb.append(prefix).append(':');
        }
        eb.append(name);
        if (namespace != null && !namespace.isEmpty()) {
            eb.append("\" from namespace \"").append(namespace);
        }
        eb.append('\"');
        return new XmlPullParserException(eb.toString(), parser, null);
    }

    private static void validateNamespace(XmlPullParser reader) throws XmlPullParserException {
        switch (reader.getNamespace()) {
            case "urn:jboss:module:1.0": 
            case "urn:jboss:module:1.1": 
            case "urn:jboss:module:1.2": 
            case "urn:jboss:module:1.3": 
            case "urn:jboss:module:1.5": 
            case "urn:jboss:module:1.6": 
            case "urn:jboss:module:1.7": {
                break;
            }
            default: {
                throw ModuleXmlParser.unexpectedContent(reader);
            }
        }
    }

    private static boolean atLeast1_6(XmlPullParser reader) {
        return MODULE_1_6.equals(reader.getNamespace()) || MODULE_1_7.equals(reader.getNamespace());
    }

    private static boolean atLeast1_7(XmlPullParser reader) {
        return MODULE_1_7.equals(reader.getNamespace());
    }

    private static void assertNoAttributes(XmlPullParser reader) throws XmlPullParserException {
        int attributeCount = reader.getAttributeCount();
        if (attributeCount > 0) {
            throw ModuleXmlParser.unknownAttribute(reader, 0);
        }
    }

    private static void validateAttributeNamespace(XmlPullParser reader, int index) throws XmlPullParserException {
        if (!reader.getAttributeNamespace(index).isEmpty()) {
            throw ModuleXmlParser.unknownAttribute(reader, index);
        }
    }

    private static ModuleSpec parseDocument(MavenResolver mavenResolver, ResourceRootFactory factory, String rootPath, XmlPullParser reader, ModuleLoader moduleLoader, String moduleName) throws XmlPullParserException, IOException {
        int eventType = reader.nextTag();
        switch (eventType) {
            case 0: {
                return ModuleXmlParser.parseRootElement(mavenResolver, factory, rootPath, reader, moduleLoader, moduleName);
            }
            case 2: {
                String element;
                ModuleXmlParser.validateNamespace(reader);
                switch (element = reader.getName()) {
                    case "module": {
                        ModuleSpec.Builder specBuilder = ModuleSpec.build(moduleName);
                        ModuleXmlParser.parseModuleContents(mavenResolver, reader, factory, moduleLoader, moduleName, specBuilder, rootPath);
                        ModuleXmlParser.parseEndDocument(reader);
                        return specBuilder.create();
                    }
                    case "module-alias": {
                        ModuleSpec moduleSpec = ModuleXmlParser.parseModuleAliasContents(reader, moduleName);
                        ModuleXmlParser.parseEndDocument(reader);
                        return moduleSpec;
                    }
                    case "module-absent": {
                        ModuleXmlParser.parseModuleAbsentContents(reader, moduleName);
                        return null;
                    }
                }
                throw ModuleXmlParser.unexpectedContent(reader);
            }
        }
        throw ModuleXmlParser.unexpectedContent(reader);
    }

    private static ModuleSpec parseRootElement(MavenResolver mavenResolver, ResourceRootFactory factory, String rootPath, XmlPullParser reader, ModuleLoader moduleLoader, String moduleName) throws XmlPullParserException, IOException {
        ModuleXmlParser.assertNoAttributes(reader);
        int eventType = reader.nextTag();
        if (eventType != 1) {
            switch (eventType) {
                case 2: {
                    String element;
                    ModuleXmlParser.validateNamespace(reader);
                    switch (element = reader.getName()) {
                        case "module": {
                            ModuleSpec.Builder specBuilder = ModuleSpec.build(moduleName);
                            ModuleXmlParser.parseModuleContents(mavenResolver, reader, factory, moduleLoader, moduleName, specBuilder, rootPath);
                            ModuleXmlParser.parseEndDocument(reader);
                            return specBuilder.create();
                        }
                        case "module-alias": {
                            ModuleSpec moduleSpec = ModuleXmlParser.parseModuleAliasContents(reader, moduleName);
                            ModuleXmlParser.parseEndDocument(reader);
                            return moduleSpec;
                        }
                        case "module-absent": {
                            ModuleXmlParser.parseModuleAbsentContents(reader, moduleName);
                            return null;
                        }
                    }
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
            throw ModuleXmlParser.unexpectedContent(reader);
        }
        throw ModuleXmlParser.endOfDocument(reader);
    }

    private static ModuleSpec parseModuleAliasContents(XmlPullParser reader, String moduleName) throws XmlPullParserException, IOException {
        int count = reader.getAttributeCount();
        String name = null;
        String slot = null;
        String targetName = null;
        String targetSlot = null;
        boolean noSlots = ModuleXmlParser.atLeast1_6(reader);
        HashSet<String> required = new HashSet<String>(LIST_A_NAME_A_TARGET_NAME);
        block15: for (int i = 0; i < count; ++i) {
            ModuleXmlParser.validateAttributeNamespace(reader, i);
            String attribute = reader.getAttributeName(i);
            required.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = reader.getAttributeValue(i);
                    continue block15;
                }
                case "slot": {
                    if (noSlots) {
                        throw ModuleXmlParser.unknownAttribute(reader, i);
                    }
                    slot = reader.getAttributeValue(i);
                    continue block15;
                }
                case "target-name": {
                    targetName = reader.getAttributeValue(i);
                    continue block15;
                }
                case "target-slot": {
                    if (noSlots) {
                        throw ModuleXmlParser.unknownAttribute(reader, i);
                    }
                    targetSlot = reader.getAttributeValue(i);
                    continue block15;
                }
                default: {
                    throw ModuleXmlParser.unknownAttribute(reader, i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ModuleXmlParser.missingAttributes(reader, required);
        }
        if (noSlots ? !moduleName.equals(name) : !ModuleIdentifier.fromString(moduleName).equals(ModuleIdentifier.create(name, slot))) {
            throw ModuleXmlParser.invalidModuleName(reader, moduleName);
        }
        int eventType = reader.nextTag();
        switch (eventType) {
            case 3: {
                if (noSlots) {
                    return ModuleSpec.buildAlias(moduleName, targetName).create();
                }
                return ModuleSpec.buildAlias(ModuleIdentifier.fromString(moduleName), ModuleIdentifier.create(targetName, targetSlot)).create();
            }
        }
        throw ModuleXmlParser.unexpectedContent(reader);
    }

    private static void parseModuleAbsentContents(XmlPullParser reader, String moduleName) throws XmlPullParserException, IOException {
        int count = reader.getAttributeCount();
        String name = null;
        String slot = null;
        boolean noSlots = ModuleXmlParser.atLeast1_6(reader);
        HashSet<String> required = new HashSet<String>(LIST_A_NAME_A_SLOT);
        block11: for (int i = 0; i < count; ++i) {
            ModuleXmlParser.validateAttributeNamespace(reader, i);
            String attribute = reader.getAttributeName(i);
            required.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = reader.getAttributeValue(i);
                    continue block11;
                }
                case "slot": {
                    if (noSlots) {
                        throw ModuleXmlParser.unknownAttribute(reader, i);
                    }
                    slot = reader.getAttributeValue(i);
                    continue block11;
                }
                default: {
                    throw ModuleXmlParser.unknownAttribute(reader, i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ModuleXmlParser.missingAttributes(reader, required);
        }
        if (noSlots ? !name.equals(moduleName) : !ModuleIdentifier.fromString(moduleName).equals(ModuleIdentifier.create(name, slot))) {
            throw ModuleXmlParser.invalidModuleName(reader, moduleName);
        }
        int eventType = reader.nextTag();
        switch (eventType) {
            case 3: {
                return;
            }
        }
        throw ModuleXmlParser.unexpectedContent(reader);
    }

    private static Permissions getAllPermission() {
        Permissions permissions = new Permissions();
        permissions.add(ALL_PERMISSION);
        return permissions;
    }

    private static void parseModuleContents(MavenResolver mavenResolver, XmlPullParser reader, ResourceRootFactory factory, ModuleLoader moduleLoader, String moduleName, ModuleSpec.Builder specBuilder, String rootPath) throws XmlPullParserException, IOException {
        int count = reader.getAttributeCount();
        String name = null;
        String slot = null;
        boolean noSlots = ModuleXmlParser.atLeast1_6(reader);
        Version version = null;
        HashSet<String> required = noSlots ? new HashSet<String>(LIST_A_NAME) : new HashSet<String>(LIST_A_NAME);
        block32: for (int i = 0; i < count; ++i) {
            ModuleXmlParser.validateAttributeNamespace(reader, i);
            String attribute = reader.getAttributeName(i);
            required.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = reader.getAttributeValue(i);
                    continue block32;
                }
                case "slot": {
                    if (noSlots) {
                        throw ModuleXmlParser.unknownAttribute(reader, i);
                    }
                    slot = reader.getAttributeValue(i);
                    continue block32;
                }
                case "version": {
                    try {
                        version = Version.parse(reader.getAttributeValue(i));
                        continue block32;
                    }
                    catch (IllegalArgumentException ex) {
                        throw new XmlPullParserException(ex.getMessage(), reader, ex);
                    }
                }
                default: {
                    throw ModuleXmlParser.unknownAttribute(reader, i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ModuleXmlParser.missingAttributes(reader, required);
        }
        if (noSlots) {
            if (!specBuilder.getName().equals(name)) {
                throw ModuleXmlParser.invalidModuleName(reader, specBuilder.getName());
            }
        } else if (!specBuilder.getIdentifier().equals(ModuleIdentifier.create(name, slot))) {
            throw ModuleXmlParser.invalidModuleName(reader, specBuilder.getIdentifier().toString());
        }
        specBuilder.setVersion(version);
        MultiplePathFilterBuilder exportsBuilder = PathFilters.multiplePathFilterBuilder(true);
        ArrayList<DependencySpec> dependencies = new ArrayList<DependencySpec>();
        HashSet<String> visited = new HashSet<String>();
        boolean gotPerms = false;
        block33: while (true) {
            int eventType = reader.nextTag();
            switch (eventType) {
                case 3: {
                    specBuilder.addDependency(new LocalDependencySpecBuilder().setExportFilter(exportsBuilder.create()).build());
                    for (DependencySpec dependency : dependencies) {
                        specBuilder.addDependency(dependency);
                    }
                    if (!gotPerms) {
                        specBuilder.setPermissionCollection(DEFAULT_PERMISSION_COLLECTION);
                    }
                    return;
                }
                case 2: {
                    ModuleXmlParser.validateNamespace(reader);
                    String element = reader.getName();
                    if (visited.contains(element)) {
                        throw ModuleXmlParser.unexpectedContent(reader);
                    }
                    visited.add(element);
                    switch (element) {
                        case "exports": {
                            ModuleXmlParser.parseFilterList(reader, exportsBuilder);
                            continue block33;
                        }
                        case "dependencies": {
                            ModuleXmlParser.parseDependencies(reader, dependencies);
                            continue block33;
                        }
                        case "main-class": {
                            ModuleXmlParser.parseMainClass(reader, specBuilder);
                            continue block33;
                        }
                        case "resources": {
                            ModuleXmlParser.parseResources(mavenResolver, factory, rootPath, reader, specBuilder);
                            continue block33;
                        }
                        case "properties": {
                            ModuleXmlParser.parseProperties(reader, specBuilder);
                            continue block33;
                        }
                        case "permissions": {
                            ModuleXmlParser.parsePermissions(reader, moduleLoader, moduleName, specBuilder);
                            gotPerms = true;
                            continue block33;
                        }
                    }
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
            break;
        }
        throw ModuleXmlParser.unexpectedContent(reader);
    }

    private static void parseDependencies(XmlPullParser reader, ArrayList<DependencySpec> dependencies) throws XmlPullParserException, IOException {
        ModuleXmlParser.assertNoAttributes(reader);
        block12: while (true) {
            int eventType = reader.nextTag();
            switch (eventType) {
                case 3: {
                    return;
                }
                case 2: {
                    ModuleXmlParser.validateNamespace(reader);
                    switch (reader.getName()) {
                        case "module": {
                            ModuleXmlParser.parseModuleDependency(reader, dependencies);
                            continue block12;
                        }
                        case "system": {
                            ModuleXmlParser.parseSystemDependency(reader, dependencies);
                            continue block12;
                        }
                    }
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
            break;
        }
        throw ModuleXmlParser.unexpectedContent(reader);
    }

    private static void parseModuleDependency(XmlPullParser reader, ArrayList<DependencySpec> dependencies) throws XmlPullParserException, IOException {
        String name = null;
        String slot = null;
        boolean export = false;
        boolean optional = false;
        boolean noSlots = ModuleXmlParser.atLeast1_6(reader);
        String services = D_NONE;
        HashSet<String> required = new HashSet<String>(LIST_A_NAME);
        int count = reader.getAttributeCount();
        block34: for (int i = 0; i < count; ++i) {
            ModuleXmlParser.validateAttributeNamespace(reader, i);
            String attribute = reader.getAttributeName(i);
            required.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = reader.getAttributeValue(i);
                    continue block34;
                }
                case "slot": {
                    if (noSlots) {
                        throw ModuleXmlParser.unknownAttribute(reader, i);
                    }
                    slot = reader.getAttributeValue(i);
                    continue block34;
                }
                case "export": {
                    export = Boolean.parseBoolean(reader.getAttributeValue(i));
                    continue block34;
                }
                case "optional": {
                    optional = Boolean.parseBoolean(reader.getAttributeValue(i));
                    continue block34;
                }
                case "services": {
                    switch (services = reader.getAttributeValue(i)) {
                        case "none": 
                        case "import": 
                        case "export": {
                            continue block34;
                        }
                    }
                    throw ModuleXmlParser.unknownAttributeValue(reader, i);
                }
                default: {
                    throw ModuleXmlParser.unknownAttribute(reader, i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ModuleXmlParser.missingAttributes(reader, required);
        }
        MultiplePathFilterBuilder importBuilder = PathFilters.multiplePathFilterBuilder(true);
        MultiplePathFilterBuilder exportBuilder = PathFilters.multiplePathFilterBuilder(export);
        block35: while (true) {
            int eventType = reader.nextTag();
            switch (eventType) {
                case 3: {
                    PathFilter importFilter;
                    assert (services.equals(D_NONE) || services.equals("export") || services.equals(D_IMPORT));
                    if (services.equals("export")) {
                        exportBuilder.addFilter(PathFilters.getMetaInfServicesFilter(), true);
                    }
                    if (export) {
                        exportBuilder.addFilter(PathFilters.getMetaInfSubdirectoriesFilter(), false);
                        exportBuilder.addFilter(PathFilters.getMetaInfFilter(), false);
                    }
                    PathFilter exportFilter = exportBuilder.create();
                    if (importBuilder.isEmpty()) {
                        importFilter = services.equals(D_NONE) ? PathFilters.getDefaultImportFilter() : PathFilters.getDefaultImportFilterWithServices();
                    } else {
                        if (!services.equals(D_NONE)) {
                            importBuilder.addFilter(PathFilters.getMetaInfServicesFilter(), true);
                        }
                        importBuilder.addFilter(PathFilters.getMetaInfSubdirectoriesFilter(), false);
                        importBuilder.addFilter(PathFilters.getMetaInfFilter(), false);
                        importFilter = importBuilder.create();
                    }
                    dependencies.add(new ModuleDependencySpecBuilder().setImportFilter(importFilter).setExportFilter(exportFilter).setName(noSlots ? name : ModuleIdentifier.create(name, slot).toString()).setOptional(optional).build());
                    return;
                }
                case 2: {
                    ModuleXmlParser.validateNamespace(reader);
                    switch (reader.getName()) {
                        case "exports": {
                            ModuleXmlParser.parseFilterList(reader, exportBuilder);
                            continue block35;
                        }
                        case "imports": {
                            ModuleXmlParser.parseFilterList(reader, importBuilder);
                            continue block35;
                        }
                    }
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
            break;
        }
        throw ModuleXmlParser.unexpectedContent(reader);
    }

    private static void parseSystemDependency(XmlPullParser reader, ArrayList<DependencySpec> dependencies) throws XmlPullParserException, IOException {
        boolean export = false;
        int count = reader.getAttributeCount();
        block18: for (int i = 0; i < count; ++i) {
            String attribute;
            ModuleXmlParser.validateAttributeNamespace(reader, i);
            switch (attribute = reader.getAttributeName(i)) {
                case "export": {
                    export = Boolean.parseBoolean(reader.getAttributeValue(i));
                    continue block18;
                }
                default: {
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
        }
        Set<String> paths = Collections.emptySet();
        MultiplePathFilterBuilder exportBuilder = PathFilters.multiplePathFilterBuilder(export);
        while (true) {
            int eventType = reader.nextTag();
            block6 : switch (eventType) {
                case 3: {
                    PathFilter exportFilter = exportBuilder.create();
                    dependencies.add(DependencySpec.createSystemDependencySpec(PathFilters.acceptAll(), exportFilter, paths));
                    return;
                }
                case 2: {
                    ModuleXmlParser.validateNamespace(reader);
                    switch (reader.getName()) {
                        case "paths": {
                            paths = ModuleXmlParser.parseSet(reader);
                            break block6;
                        }
                        case "exports": {
                            ModuleXmlParser.parseFilterList(reader, exportBuilder);
                            break block6;
                        }
                    }
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
        }
    }

    private static void parseMainClass(XmlPullParser reader, ModuleSpec.Builder specBuilder) throws XmlPullParserException, IOException {
        String name = null;
        HashSet<String> required = new HashSet<String>(LIST_A_NAME);
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            ModuleXmlParser.validateAttributeNamespace(reader, i);
            String attribute = reader.getAttributeName(i);
            required.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = reader.getAttributeValue(i);
                    continue block6;
                }
                default: {
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ModuleXmlParser.missingAttributes(reader, required);
        }
        specBuilder.setMainClass(name);
        ModuleXmlParser.parseNoContent(reader);
    }

    private static void parseResources(MavenResolver mavenResolver, ResourceRootFactory factory, String rootPath, XmlPullParser reader, ModuleSpec.Builder specBuilder) throws XmlPullParserException, IOException {
        ModuleXmlParser.assertNoAttributes(reader);
        block14: while (true) {
            int eventType = reader.nextTag();
            switch (eventType) {
                case 3: {
                    specBuilder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec(new NativeLibraryResourceLoader(new File(rootPath, "lib")), PathFilters.rejectAll()));
                    return;
                }
                case 2: {
                    ModuleXmlParser.validateNamespace(reader);
                    switch (reader.getName()) {
                        case "resource-root": {
                            ModuleXmlParser.parseResourceRoot(factory, rootPath, reader, specBuilder);
                            continue block14;
                        }
                        case "artifact": {
                            ModuleXmlParser.parseArtifact(mavenResolver, reader, specBuilder);
                            continue block14;
                        }
                        case "native-artifact": {
                            ModuleXmlParser.parseNativeArtifact(mavenResolver, reader, specBuilder);
                            continue block14;
                        }
                    }
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
            break;
        }
        throw ModuleXmlParser.unexpectedContent(reader);
    }

    private static void createMavenNativeArtifactLoader(MavenResolver mavenResolver, String name, XmlPullParser reader, ModuleSpec.Builder specBuilder) throws IOException, XmlPullParserException {
        File fp = mavenResolver.resolveJarArtifact(ArtifactCoordinates.fromString(name));
        if (fp == null) {
            throw new XmlPullParserException(String.format("Failed to resolve native artifact '%s'", name), reader, null);
        }
        File lib = new File(fp.getParentFile(), "lib");
        if (!lib.exists()) {
            if (!fp.getParentFile().canWrite()) {
                throw new XmlPullParserException(String.format("Native artifact '%s' cannot be unpacked", name), reader, null);
            }
            ModuleXmlParser.unzip(fp, fp.getParentFile());
        }
        specBuilder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec(new NativeLibraryResourceLoader(lib), PathFilters.rejectAll()));
    }

    private static void parseNativeArtifact(MavenResolver mavenResolver, XmlPullParser reader, ModuleSpec.Builder specBuilder) throws XmlPullParserException, IOException {
        String name = null;
        HashSet<String> required = new HashSet<String>(LIST_A_NAME);
        int count = reader.getAttributeCount();
        block18: for (int i = 0; i < count; ++i) {
            ModuleXmlParser.validateAttributeNamespace(reader, i);
            String attribute = reader.getAttributeName(i);
            required.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = reader.getAttributeValue(i);
                    continue block18;
                }
                default: {
                    throw ModuleXmlParser.unknownAttribute(reader, i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ModuleXmlParser.missingAttributes(reader, required);
        }
        SystemPropertyConditionBuilder conditionBuilder = new SystemPropertyConditionBuilder();
        HashSet<String> encountered = new HashSet<String>();
        block19: while (true) {
            int eventType = reader.nextTag();
            switch (eventType) {
                case 3: {
                    try {
                        if (conditionBuilder.resolve()) {
                            ModuleXmlParser.createMavenNativeArtifactLoader(mavenResolver, name, reader, specBuilder);
                        }
                    }
                    catch (IOException e) {
                        throw new XmlPullParserException(String.format("Failed to add artifact '%s'", name), reader, e);
                    }
                    return;
                }
                case 2: {
                    ModuleXmlParser.validateNamespace(reader);
                    String element = reader.getName();
                    if (!encountered.add(element)) {
                        throw ModuleXmlParser.unexpectedContent(reader);
                    }
                    switch (element) {
                        case "conditions": {
                            ModuleXmlParser.parseConditions(reader, conditionBuilder);
                            continue block19;
                        }
                    }
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
            break;
        }
        throw ModuleXmlParser.unexpectedContent(reader);
    }

    private static void parseArtifact(MavenResolver mavenResolver, XmlPullParser reader, ModuleSpec.Builder specBuilder) throws XmlPullParserException, IOException {
        String name = null;
        HashSet<String> required = new HashSet<String>(LIST_A_NAME);
        int count = reader.getAttributeCount();
        block20: for (int i = 0; i < count; ++i) {
            ModuleXmlParser.validateAttributeNamespace(reader, i);
            String attribute = reader.getAttributeName(i);
            required.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = reader.getAttributeValue(i);
                    continue block20;
                }
                default: {
                    throw ModuleXmlParser.unknownAttribute(reader, i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ModuleXmlParser.missingAttributes(reader, required);
        }
        MultiplePathFilterBuilder filterBuilder = PathFilters.multiplePathFilterBuilder(true);
        SystemPropertyConditionBuilder conditionBuilder = new SystemPropertyConditionBuilder();
        HashSet<String> encountered = new HashSet<String>();
        block21: while (true) {
            int eventType = reader.nextTag();
            switch (eventType) {
                case 3: {
                    if (conditionBuilder.resolve()) {
                        ResourceLoader resourceLoader;
                        try {
                            resourceLoader = MavenArtifactUtil.createMavenArtifactLoader(mavenResolver, name);
                        }
                        catch (IOException e) {
                            throw new XmlPullParserException(String.format("Failed to add artifact '%s'", name), reader, e);
                        }
                        if (resourceLoader == null) {
                            throw new XmlPullParserException(String.format("Failed to resolve artifact '%s'", name), reader, null);
                        }
                        specBuilder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec(resourceLoader, filterBuilder.create()));
                    }
                    return;
                }
                case 2: {
                    ModuleXmlParser.validateNamespace(reader);
                    String element = reader.getName();
                    if (!encountered.add(element)) {
                        throw ModuleXmlParser.unexpectedContent(reader);
                    }
                    switch (element) {
                        case "filter": {
                            ModuleXmlParser.parseFilterList(reader, filterBuilder);
                            continue block21;
                        }
                        case "conditions": {
                            ModuleXmlParser.parseConditions(reader, conditionBuilder);
                            continue block21;
                        }
                    }
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
            break;
        }
        throw ModuleXmlParser.unexpectedContent(reader);
    }

    private static void parseResourceRoot(ResourceRootFactory factory, String rootPath, XmlPullParser reader, ModuleSpec.Builder specBuilder) throws XmlPullParserException, IOException {
        String name = null;
        String path = null;
        HashSet<String> required = new HashSet<String>(LIST_A_PATH);
        int count = reader.getAttributeCount();
        block22: for (int i = 0; i < count; ++i) {
            ModuleXmlParser.validateAttributeNamespace(reader, i);
            String attribute = reader.getAttributeName(i);
            required.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = reader.getAttributeValue(i);
                    continue block22;
                }
                case "path": {
                    path = reader.getAttributeValue(i);
                    continue block22;
                }
                default: {
                    throw ModuleXmlParser.unknownAttribute(reader, i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ModuleXmlParser.missingAttributes(reader, required);
        }
        if (name == null) {
            name = path;
        }
        MultiplePathFilterBuilder filterBuilder = PathFilters.multiplePathFilterBuilder(true);
        SystemPropertyConditionBuilder conditionBuilder = new SystemPropertyConditionBuilder();
        HashSet<String> encountered = new HashSet<String>();
        block23: while (true) {
            int eventType = reader.nextTag();
            switch (eventType) {
                case 3: {
                    if (conditionBuilder.resolve()) {
                        ResourceLoader resourceLoader;
                        try {
                            resourceLoader = factory.createResourceLoader(rootPath, path, name);
                        }
                        catch (IOException e) {
                            throw new XmlPullParserException(String.format("Failed to add resource root '%s' at path '%s'", name, path), reader, e);
                        }
                        specBuilder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec(resourceLoader, filterBuilder.create()));
                    }
                    return;
                }
                case 2: {
                    ModuleXmlParser.validateNamespace(reader);
                    String element = reader.getName();
                    if (!encountered.add(element)) {
                        throw ModuleXmlParser.unexpectedContent(reader);
                    }
                    switch (element) {
                        case "filter": {
                            ModuleXmlParser.parseFilterList(reader, filterBuilder);
                            continue block23;
                        }
                        case "conditions": {
                            ModuleXmlParser.parseConditions(reader, conditionBuilder);
                            continue block23;
                        }
                    }
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
            break;
        }
        throw ModuleXmlParser.unexpectedContent(reader);
    }

    private static void parseConditions(XmlPullParser reader, SystemPropertyConditionBuilder conditionBuilder) throws XmlPullParserException, IOException {
        if (!ModuleXmlParser.atLeast1_7(reader)) {
            throw ModuleXmlParser.unexpectedContent(reader);
        }
        ModuleXmlParser.assertNoAttributes(reader);
        block12: while (true) {
            int eventType = reader.nextTag();
            switch (eventType) {
                case 3: {
                    return;
                }
                case 2: {
                    ModuleXmlParser.validateNamespace(reader);
                    switch (reader.getName()) {
                        case "property-equal": {
                            ModuleXmlParser.parseConditionalProperty(reader, true, conditionBuilder);
                            continue block12;
                        }
                        case "property-not-equal": {
                            ModuleXmlParser.parseConditionalProperty(reader, false, conditionBuilder);
                            continue block12;
                        }
                    }
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
            break;
        }
        throw ModuleXmlParser.unexpectedContent(reader);
    }

    private static void parseConditionalProperty(XmlPullParser reader, boolean equal, SystemPropertyConditionBuilder builder) throws XmlPullParserException, IOException {
        String name = null;
        String value = null;
        HashSet<String> required = new HashSet<String>(Arrays.asList(A_NAME, A_VALUE));
        int count = reader.getAttributeCount();
        block8: for (int i = 0; i < count; ++i) {
            ModuleXmlParser.validateAttributeNamespace(reader, i);
            String attribute = reader.getAttributeName(i);
            required.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = reader.getAttributeValue(i);
                    continue block8;
                }
                case "value": {
                    value = reader.getAttributeValue(i);
                    continue block8;
                }
                default: {
                    throw ModuleXmlParser.unknownAttribute(reader, i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ModuleXmlParser.missingAttributes(reader, required);
        }
        builder.add(name, value, equal);
        ModuleXmlParser.parseNoContent(reader);
    }

    private static void parseFilterList(XmlPullParser reader, MultiplePathFilterBuilder builder) throws XmlPullParserException, IOException {
        ModuleXmlParser.assertNoAttributes(reader);
        block16: while (true) {
            int eventType = reader.nextTag();
            switch (eventType) {
                case 3: {
                    return;
                }
                case 2: {
                    ModuleXmlParser.validateNamespace(reader);
                    switch (reader.getName()) {
                        case "include": {
                            ModuleXmlParser.parsePath(reader, true, builder);
                            continue block16;
                        }
                        case "exclude": {
                            ModuleXmlParser.parsePath(reader, false, builder);
                            continue block16;
                        }
                        case "include-set": {
                            ModuleXmlParser.parseSet(reader, true, builder);
                            continue block16;
                        }
                        case "exclude-set": {
                            ModuleXmlParser.parseSet(reader, false, builder);
                            continue block16;
                        }
                    }
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
            break;
        }
        throw ModuleXmlParser.unexpectedContent(reader);
    }

    private static void parsePath(XmlPullParser reader, boolean include, MultiplePathFilterBuilder builder) throws XmlPullParserException, IOException {
        boolean literal;
        String path = null;
        HashSet<String> required = new HashSet<String>(LIST_A_PATH);
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            ModuleXmlParser.validateAttributeNamespace(reader, i);
            String attribute = reader.getAttributeName(i);
            required.remove(attribute);
            switch (attribute) {
                case "path": {
                    path = reader.getAttributeValue(i);
                    continue block6;
                }
                default: {
                    throw ModuleXmlParser.unknownAttribute(reader, i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ModuleXmlParser.missingAttributes(reader, required);
        }
        boolean bl = literal = path.indexOf(42) == -1 && path.indexOf(63) == -1;
        if (literal) {
            if (path.charAt(path.length() - 1) == '/') {
                builder.addFilter(PathFilters.isChildOf(path), include);
            } else {
                builder.addFilter(PathFilters.is(path), include);
            }
        } else {
            builder.addFilter(PathFilters.match(path), include);
        }
        ModuleXmlParser.parseNoContent(reader);
    }

    private static Set<String> parseSet(XmlPullParser reader) throws XmlPullParserException, IOException {
        ModuleXmlParser.assertNoAttributes(reader);
        HashSet<String> set = new HashSet<String>();
        while (true) {
            int eventType = reader.nextTag();
            block0 : switch (eventType) {
                case 3: {
                    return set;
                }
                case 2: {
                    ModuleXmlParser.validateNamespace(reader);
                    switch (reader.getName()) {
                        case "path": {
                            ModuleXmlParser.parsePathName(reader, set);
                            break block0;
                        }
                    }
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
        }
    }

    private static void parseSet(XmlPullParser reader, boolean include, MultiplePathFilterBuilder builder) throws XmlPullParserException, IOException {
        builder.addFilter(PathFilters.in(ModuleXmlParser.parseSet(reader)), include);
    }

    private static void parsePathName(XmlPullParser reader, Set<String> set) throws XmlPullParserException, IOException {
        String name = null;
        HashSet<String> required = new HashSet<String>(LIST_A_NAME);
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            ModuleXmlParser.validateAttributeNamespace(reader, i);
            String attribute = reader.getAttributeName(i);
            required.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = reader.getAttributeValue(i);
                    continue block6;
                }
                default: {
                    throw ModuleXmlParser.unknownAttribute(reader, i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ModuleXmlParser.missingAttributes(reader, required);
        }
        set.add(name);
        ModuleXmlParser.parseNoContent(reader);
    }

    private static void parseProperties(XmlPullParser reader, ModuleSpec.Builder specBuilder) throws XmlPullParserException, IOException {
        ModuleXmlParser.assertNoAttributes(reader);
        block10: while (true) {
            int eventType = reader.nextTag();
            switch (eventType) {
                case 3: {
                    return;
                }
                case 2: {
                    ModuleXmlParser.validateNamespace(reader);
                    switch (reader.getName()) {
                        case "property": {
                            ModuleXmlParser.parseProperty(reader, specBuilder);
                            continue block10;
                        }
                    }
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
            break;
        }
        throw ModuleXmlParser.unexpectedContent(reader);
    }

    private static void parseProperty(XmlPullParser reader, ModuleSpec.Builder specBuilder) throws XmlPullParserException, IOException {
        String name = null;
        String value = null;
        HashSet<String> required = new HashSet<String>(LIST_A_NAME);
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            ModuleXmlParser.validateAttributeNamespace(reader, i);
            String attribute = reader.getAttributeName(i);
            required.remove(attribute);
            switch (attribute) {
                case "name": {
                    name = reader.getAttributeValue(i);
                    continue block10;
                }
                case "value": {
                    value = reader.getAttributeValue(i);
                    continue block10;
                }
                default: {
                    throw ModuleXmlParser.unknownAttribute(reader, i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ModuleXmlParser.missingAttributes(reader, required);
        }
        specBuilder.addProperty(name, value == null ? "true" : value);
        if ("jboss.assertions".equals(name)) {
            try {
                specBuilder.setAssertionSetting(AssertionSetting.valueOf(value.toUpperCase(Locale.US)));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        ModuleXmlParser.parseNoContent(reader);
    }

    private static void parsePermissions(XmlPullParser reader, ModuleLoader moduleLoader, String moduleName, ModuleSpec.Builder specBuilder) throws XmlPullParserException, IOException {
        ModuleXmlParser.assertNoAttributes(reader);
        ArrayList<PermissionFactory> list = new ArrayList<PermissionFactory>();
        block10: while (true) {
            int eventType = reader.nextTag();
            switch (eventType) {
                case 3: {
                    specBuilder.setPermissionCollection(new FactoryPermissionCollection(list.toArray(new PermissionFactory[list.size()])));
                    return;
                }
                case 2: {
                    ModuleXmlParser.validateNamespace(reader);
                    switch (reader.getName()) {
                        case "grant": {
                            ModuleXmlParser.parseGrant(reader, moduleLoader, moduleName, list);
                            continue block10;
                        }
                    }
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
            }
            break;
        }
        throw ModuleXmlParser.unexpectedContent(reader);
    }

    private static void parseGrant(XmlPullParser reader, ModuleLoader moduleLoader, String moduleName, ArrayList<PermissionFactory> list) throws XmlPullParserException, IOException {
        String permission = null;
        String name = null;
        String actions = null;
        HashSet<String> required = new HashSet<String>(LIST_A_PERMISSION_A_NAME);
        int count = reader.getAttributeCount();
        block10: for (int i = 0; i < count; ++i) {
            ModuleXmlParser.validateAttributeNamespace(reader, i);
            String attribute = reader.getAttributeName(i);
            required.remove(attribute);
            switch (attribute) {
                case "permission": {
                    permission = reader.getAttributeValue(i);
                    continue block10;
                }
                case "name": {
                    name = reader.getAttributeValue(i);
                    continue block10;
                }
                case "actions": {
                    actions = reader.getAttributeValue(i);
                    continue block10;
                }
                default: {
                    throw ModuleXmlParser.unknownAttribute(reader, i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ModuleXmlParser.missingAttributes(reader, required);
        }
        ModuleXmlParser.expandName(moduleLoader, moduleName, list, permission, name, actions);
        ModuleXmlParser.parseNoContent(reader);
    }

    private static void expandName(ModuleLoader moduleLoader, String moduleName, ArrayList<PermissionFactory> list, String permission, String name, String actions) {
        String expandedName = PolicyExpander.expand(name);
        if (expandedName != null) {
            list.add(new ModularPermissionFactory(moduleLoader, moduleName, permission, expandedName, actions));
        }
    }

    private static void parseNoContent(XmlPullParser reader) throws XmlPullParserException, IOException {
        int eventType = reader.nextTag();
        switch (eventType) {
            case 3: {
                return;
            }
        }
        throw ModuleXmlParser.unexpectedContent(reader);
    }

    private static void parseEndDocument(XmlPullParser reader) throws XmlPullParserException, IOException {
        block5: while (true) {
            int eventType = reader.nextToken();
            switch (eventType) {
                case 1: {
                    return;
                }
                case 4: 
                case 5: {
                    if (reader.isWhitespace()) continue block5;
                    throw ModuleXmlParser.unexpectedContent(reader);
                }
                case 7: 
                case 9: {
                    continue block5;
                }
            }
            break;
        }
        throw ModuleXmlParser.unexpectedContent(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unzip(File src, File destDir) throws IOException {
        String absolutePath = destDir.getAbsolutePath();
        ZipFile zip = new ZipFile(src);
        try {
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                File fp = new File(absolutePath, PathUtils.canonicalize(PathUtils.relativize(entry.getName())));
                File parent = fp.getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                InputStream is = zip.getInputStream(entry);
                try {
                    FileOutputStream os = new FileOutputStream(fp);
                    try {
                        ModuleXmlParser.copy(is, os);
                    }
                    finally {
                        ModuleXmlParser.safeClose(os);
                    }
                }
                finally {
                    ModuleXmlParser.safeClose(is);
                }
            }
        }
        finally {
            ModuleXmlParser.safeClose(zip);
        }
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[16384];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        out.flush();
    }

    private static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    static class DefaultResourceRootFactory
    implements ResourceRootFactory {
        static final DefaultResourceRootFactory INSTANCE = new DefaultResourceRootFactory();

        private DefaultResourceRootFactory() {
        }

        @Override
        public ResourceLoader createResourceLoader(String rootPath, String loaderPath, String loaderName) throws IOException {
            File file;
            String loaderFileName = File.separatorChar == '/' ? loaderPath : loaderPath.replace('/', File.separatorChar);
            File loaderFile = new File(loaderFileName);
            if (loaderFile.isAbsolute()) {
                file = loaderFile;
            } else {
                String rootPathName = File.separatorChar == '/' ? rootPath : rootPath.replace('/', File.separatorChar);
                file = new File(rootPathName, loaderFileName);
            }
            if (file.isDirectory()) {
                return ResourceLoaders.createFileResourceLoader(loaderName, file);
            }
            JarFile jarFile = JDKSpecific.getJarFile(file, true);
            return ResourceLoaders.createJarResourceLoader(loaderName, jarFile);
        }
    }

    public static interface ResourceRootFactory {
        public ResourceLoader createResourceLoader(String var1, String var2, String var3) throws IOException;

        public static ResourceRootFactory getDefault() {
            return DefaultResourceRootFactory.INSTANCE;
        }
    }
}

