/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.IOException;
import java.lang.module.ModuleDescriptor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.IterableModuleFinder;
import org.jboss.modules.JavaSeDeps;
import org.jboss.modules.LocalDependencySpecBuilder;
import org.jboss.modules.LocalLoader;
import org.jboss.modules.ModuleClassLoaderAction;
import org.jboss.modules.ModuleDependencySpecBuilder;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.Resource;
import org.jboss.modules.URLConnectionResource;
import org.jboss.modules.Version;

public final class JDKModuleFinder
implements IterableModuleFinder {
    private final ModuleLayer layer = ModuleLayer.boot();
    private static final JDKModuleFinder INSTANCE = new JDKModuleFinder();

    private JDKModuleFinder() {
    }

    public static JDKModuleFinder getInstance() {
        return INSTANCE;
    }

    @Override
    public ModuleSpec findModule(String name, ModuleLoader delegateLoader) {
        Set<String> packages;
        Module module;
        if ("java.se".equals(name)) {
            ModuleSpec.Builder builder = ModuleSpec.build(name, false);
            for (DependencySpec dep : JavaSeDeps.list) {
                builder.addDependency(dep);
            }
            return builder.create();
        }
        if ("org.jboss.modules".equals(name)) {
            module = this.getClass().getModule();
            packages = module.isNamed() ? module.getPackages() : Set.of("org.jboss.modules", "org.jboss.modules.filter", "org.jboss.modules.log", "org.jboss.modules.management", "org.jboss.modules.maven", "org.jboss.modules.ref", "org.jboss.modules.security", "org.jboss.modules.xml");
        } else {
            Optional<Module> moduleOptional = this.layer.findModule(name);
            if (!moduleOptional.isPresent()) {
                return null;
            }
            module = moduleOptional.get();
            packages = module.getPackages();
        }
        ModuleSpec.Builder builder = ModuleSpec.build(name);
        ModuleDescriptor descriptor = module.getDescriptor();
        if (descriptor != null) {
            Optional<String> version = descriptor.rawVersion();
            if (version.isPresent()) {
                builder.setVersion(Version.parse(version.get()));
            }
            for (ModuleDescriptor.Requires require : descriptor.requires()) {
                Set<ModuleDescriptor.Requires.Modifier> modifiers = require.modifiers();
                builder.addDependency(new ModuleDependencySpecBuilder().setName(require.name()).setExport(modifiers.contains((Object)ModuleDescriptor.Requires.Modifier.TRANSITIVE)).setOptional(modifiers.contains((Object)ModuleDescriptor.Requires.Modifier.STATIC)).build());
            }
        }
        HashSet<String> paths = new HashSet<String>(packages.size());
        for (String pkg : packages) {
            paths.add(pkg.replace('.', '/'));
        }
        LocalDependencySpecBuilder depBuilder = new LocalDependencySpecBuilder();
        depBuilder.setLoaderPaths(paths);
        depBuilder.setExport(true);
        depBuilder.setLocalLoader(new JDKModuleLoader(module, packages));
        builder.addDependency(depBuilder.build());
        return builder.create();
    }

    public String toString() {
        return "JDK Module Finder";
    }

    @Override
    public Iterator<String> iterateModules(String baseName, boolean recursive) {
        Set<Module> moduleSet = this.layer.modules();
        ArrayList<String> nameList = new ArrayList<String>(moduleSet.size() + 1);
        Module ourModule = this.getClass().getModule();
        boolean foundUs = false;
        for (Module module : moduleSet) {
            if (module == ourModule) {
                foundUs = true;
            }
            nameList.add(module.getName());
        }
        if (!foundUs) {
            nameList.add("org.jboss.modules");
        }
        return nameList.iterator();
    }

    static class JDKModuleLoader
    implements LocalLoader {
        private final Module module;
        private final ClassLoader classLoader;
        private final Set<String> packages;

        JDKModuleLoader(Module module, Set<String> packages) {
            this.module = module;
            JDKModuleLoader.class.getModule().addReads(module);
            this.classLoader = AccessController.doPrivileged(new ModuleClassLoaderAction(module));
            this.packages = packages;
        }

        @Override
        public Class<?> loadClassLocal(String name, boolean resolve) {
            String nameDots = name.replace('/', '.');
            int idx = nameDots.lastIndexOf(46);
            if (idx == -1) {
                return null;
            }
            if (this.packages.contains(nameDots.substring(0, idx))) {
                try {
                    Class<?> clazz = this.classLoader.loadClass(nameDots);
                    if (clazz.getModule() != this.module) {
                        return null;
                    }
                    return clazz;
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            }
            return null;
        }

        @Override
        public Package loadPackageLocal(String name) {
            return this.packages.contains(name) ? this.classLoader.getDefinedPackage(name) : null;
        }

        @Override
        public List<Resource> loadResourceLocal(String name) {
            URL url;
            try {
                url = new URL("jrt:/" + this.module.getName() + "/" + name);
            }
            catch (MalformedURLException e) {
                return Collections.emptyList();
            }
            try {
                URLConnection connection = url.openConnection();
                connection.connect();
                return Collections.singletonList(new URLConnectionResource(connection));
            }
            catch (IOException e) {
                URL resource;
                String nameDots;
                int idx = name.lastIndexOf(47);
                if (idx != -1 && this.packages.contains(nameDots = name.substring(0, idx).replace('/', '.')) && (resource = this.classLoader.getResource(name)) != null) {
                    try {
                        URLConnection connection = resource.openConnection();
                        connection.connect();
                        return Collections.singletonList(new URLConnectionResource(connection));
                    }
                    catch (IOException e2) {
                        return Collections.emptyList();
                    }
                }
                return Collections.emptyList();
            }
        }
    }
}

