/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.reflect;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;

public final class Property {
    private final Class<?> declaringClass;
    private final String name;
    private final Method getter;
    private final Map<Class<?>, Method> setters;

    private Property(Class<?> declaringClass, String name, Method[] methods) {
        this.declaringClass = declaringClass;
        this.name = name;
        IdentityHashMap setters = new IdentityHashMap(0);
        Method getter = null;
        String capProperty = Character.toUpperCase(name.charAt(0)) + name.substring(1);
        String getName = "get" + capProperty;
        String isName = "is" + capProperty;
        String setName = "set" + capProperty;
        for (Method method : methods) {
            Class<?>[] paramTypes;
            String methodName = method.getName();
            if (methodName.equals(getName) || methodName.equals(isName)) {
                paramTypes = method.getParameterTypes();
                if (paramTypes.length != 0) continue;
                if (getter != null) {
                    throw new IllegalArgumentException("Ambiguous getter methods");
                }
                getter = method;
                continue;
            }
            if (!methodName.equals(setName) || (paramTypes = method.getParameterTypes()).length != 1) continue;
            setters.put(paramTypes[0], method);
        }
        this.getter = getter;
        if (setters.size() == 1) {
            Map.Entry entry = setters.entrySet().iterator().next();
            this.setters = Collections.singletonMap(entry.getKey(), entry.getValue());
        } else {
            this.setters = setters;
        }
    }

    private Property(Class<?> declaringClass, String name) {
        this(declaringClass, name, declaringClass.getMethods());
    }

    private Property(final Class<?> declaringClass, String name, AccessControlContext context) {
        this(declaringClass, name, AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                return declaringClass.getDeclaredMethods();
            }
        }, context));
    }

    public static Property getProperty(Class<?> declaringClass, String name) {
        return new Property(declaringClass, name);
    }

    public static Property getNonPublicProperty(Class<?> declaringClass, String name, AccessControlContext context) {
        return new Property(declaringClass, name, context);
    }

    public Object get(Object target) throws InvocationTargetException, IllegalAccessException {
        return this.getter.invoke(target, new Object[0]);
    }

    public void set(Object target, Object value) throws InvocationTargetException, IllegalAccessException {
        this.set(target, value, value.getClass());
    }

    public void set(Object target, Object value, Class<?> matchClass) throws InvocationTargetException, IllegalAccessException {
        int v;
        if (this.setters.size() == 1) {
            this.setters.values().iterator().next().invoke(target, value);
            return;
        }
        int i = 0;
        while ((v = this.trySet(target, value, matchClass, i++)) > 0) {
        }
        if (v == 0) {
            throw new IllegalArgumentException("No matching setter found for " + matchClass);
        }
    }

    private int trySet(Object target, Object value, Class<?> matchClass, int depth) throws InvocationTargetException, IllegalAccessException {
        if (depth == 0) {
            Method method = this.setters.get(matchClass);
            if (method != null) {
                method.invoke(target, value);
                return -1;
            }
            return 0;
        }
        int r = 0;
        --depth;
        Class<?> superClass = matchClass.getSuperclass();
        if (superClass != null) {
            int v = this.trySet(target, value, superClass, depth);
            if (v == -1) {
                return -1;
            }
            r = r + v + 1;
        }
        for (Class<?> interf : matchClass.getInterfaces()) {
            int v = this.trySet(target, value, interf, depth);
            if (v == -1) {
                return -1;
            }
            r = r + v + 1;
        }
        return r;
    }

    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    public String getName() {
        return this.name;
    }
}

