/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.reflect.Property;
import org.jboss.msc.service.BatchBuilderImpl;
import org.jboss.msc.service.BatchInjectionBuilder;
import org.jboss.msc.service.BatchServiceBuilderImpl;
import org.jboss.msc.service.FieldDelegatingInjectionSource;
import org.jboss.msc.service.FieldInjectionDestination;
import org.jboss.msc.service.InjectionDestination;
import org.jboss.msc.service.InjectionSource;
import org.jboss.msc.service.InjectorInjectionDestination;
import org.jboss.msc.service.MethodDelegatingInjectionSource;
import org.jboss.msc.service.MethodInjectionDestination;
import org.jboss.msc.service.MethodInjectionSource;
import org.jboss.msc.service.PropertyDelegatingInjectionSource;
import org.jboss.msc.service.PropertyInjectionDestination;
import org.jboss.msc.translate.Translator;
import org.jboss.msc.value.ClassOfValue;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.LookupFieldValue;
import org.jboss.msc.value.LookupMethodValue;
import org.jboss.msc.value.LookupPropertyValue;
import org.jboss.msc.value.Value;
import org.jboss.msc.value.Values;

final class BatchInjectionBuilderImpl
implements BatchInjectionBuilder {
    private final List<Translator<?, ?>> translators = new ArrayList();
    private final BatchServiceBuilderImpl<?> batchServiceBuilder;
    private final BatchBuilderImpl batchBuilder;
    private Value<?> target;
    private Value<?> injectionValue;
    private InjectionSource injectionSource;
    private InjectionDestination injectionDestination;

    BatchInjectionBuilderImpl(BatchServiceBuilderImpl<?> batchServiceBuilder, InjectionSource injectionSource, BatchBuilderImpl batchBuilder) {
        this.batchServiceBuilder = batchServiceBuilder;
        this.injectionSource = injectionSource;
        this.batchBuilder = batchBuilder;
        this.target = batchServiceBuilder.getServiceValue();
    }

    private static IllegalStateException alreadySpecified() {
        return new IllegalStateException("Injection destination already specified");
    }

    @Override
    public BatchInjectionBuilderImpl toProperty(String propertyName) {
        if (this.batchBuilder.isDone()) {
            throw BatchBuilderImpl.alreadyInstalled();
        }
        if (this.injectionDestination != null) {
            throw BatchInjectionBuilderImpl.alreadySpecified();
        }
        this.injectionDestination = new PropertyInjectionDestination(new LookupPropertyValue(new ClassOfValue(this.target), propertyName));
        this.batchServiceBuilder.getInjections().add(this);
        return this;
    }

    @Override
    public BatchInjectionBuilder toProperty(Property property) {
        if (this.batchBuilder.isDone()) {
            throw BatchBuilderImpl.alreadyInstalled();
        }
        if (this.injectionDestination != null) {
            throw BatchInjectionBuilderImpl.alreadySpecified();
        }
        this.injectionDestination = new PropertyInjectionDestination(new ImmediateValue<Property>(property));
        this.batchServiceBuilder.getInjections().add(this);
        return this;
    }

    @Override
    public BatchInjectionBuilder toPropertyValue(Value<Property> propertyValue) {
        if (this.batchBuilder.isDone()) {
            throw BatchBuilderImpl.alreadyInstalled();
        }
        if (this.injectionDestination != null) {
            throw BatchInjectionBuilderImpl.alreadySpecified();
        }
        if (this.batchBuilder == null) {
            throw new IllegalArgumentException("batchBuilder is null");
        }
        if (this.injectionDestination == null) {
            throw new IllegalArgumentException("injectionDestination is null");
        }
        this.injectionDestination = new PropertyInjectionDestination(propertyValue);
        this.batchServiceBuilder.getInjections().add(this);
        return this;
    }

    @Override
    public BatchInjectionBuilderImpl toMethod(String name, List<? extends Value<Class<?>>> parameterTypes, List<? extends Value<?>> parameterValues) {
        if (this.batchBuilder.isDone()) {
            throw BatchBuilderImpl.alreadyInstalled();
        }
        if (this.injectionDestination != null) {
            throw BatchInjectionBuilderImpl.alreadySpecified();
        }
        this.injectionDestination = new MethodInjectionDestination(new LookupMethodValue(new ClassOfValue(this.target), name, parameterTypes), this.target, parameterValues);
        this.batchServiceBuilder.getInjections().add(this);
        return this;
    }

    @Override
    public BatchInjectionBuilderImpl toMethodValue(Value<Method> methodValue, List<? extends Value<?>> parameterValues) {
        if (this.batchBuilder.isDone()) {
            throw BatchBuilderImpl.alreadyInstalled();
        }
        if (this.injectionDestination != null) {
            throw BatchInjectionBuilderImpl.alreadySpecified();
        }
        this.injectionDestination = new MethodInjectionDestination(methodValue, this.target, parameterValues);
        this.batchServiceBuilder.getInjections().add(this);
        return this;
    }

    @Override
    public BatchInjectionBuilderImpl toMethod(Method method, List<? extends Value<?>> parameterValues) {
        if (this.batchBuilder.isDone()) {
            throw BatchBuilderImpl.alreadyInstalled();
        }
        if (this.injectionDestination != null) {
            throw BatchInjectionBuilderImpl.alreadySpecified();
        }
        this.injectionDestination = new MethodInjectionDestination(Values.immediateValue(method), this.target, parameterValues);
        this.batchServiceBuilder.getInjections().add(this);
        return this;
    }

    @Override
    public BatchInjectionBuilderImpl toMethod(Method method, Value<?> targetValue, List<? extends Value<?>> parameterValues) {
        if (this.batchBuilder.isDone()) {
            throw BatchBuilderImpl.alreadyInstalled();
        }
        if (this.injectionDestination != null) {
            throw BatchInjectionBuilderImpl.alreadySpecified();
        }
        this.injectionDestination = new MethodInjectionDestination(Values.immediateValue(method), targetValue, parameterValues);
        this.batchServiceBuilder.getInjections().add(this);
        return this;
    }

    @Override
    public BatchInjectionBuilder toMethod(String name, Value<?> targetValue, List<? extends Value<Class<?>>> parameterTypes, List<? extends Value<?>> parameterValues) {
        if (this.batchBuilder.isDone()) {
            throw BatchBuilderImpl.alreadyInstalled();
        }
        if (this.injectionDestination != null) {
            throw BatchInjectionBuilderImpl.alreadySpecified();
        }
        this.injectionDestination = new MethodInjectionDestination(new LookupMethodValue(new ClassOfValue(targetValue), name, parameterTypes), targetValue, parameterValues);
        this.batchServiceBuilder.getInjections().add(this);
        return this;
    }

    @Override
    public BatchInjectionBuilder toMethodValue(Value<Method> methodValue, Value<?> targetValue, List<? extends Value<?>> parameterValues) {
        if (this.batchBuilder.isDone()) {
            throw BatchBuilderImpl.alreadyInstalled();
        }
        if (this.injectionDestination != null) {
            throw BatchInjectionBuilderImpl.alreadySpecified();
        }
        this.injectionDestination = new MethodInjectionDestination(methodValue, targetValue, parameterValues);
        this.batchServiceBuilder.getInjections().add(this);
        return this;
    }

    @Override
    public BatchInjectionBuilderImpl toMethod(String name) {
        if (this.batchBuilder.isDone()) {
            throw BatchBuilderImpl.alreadyInstalled();
        }
        if (this.injectionDestination != null) {
            throw BatchInjectionBuilderImpl.alreadySpecified();
        }
        this.injectionDestination = new MethodInjectionDestination(new LookupMethodValue(new ClassOfValue(this.target), name, 1), this.target, Collections.singletonList(Values.injectedValue()));
        this.batchServiceBuilder.getInjections().add(this);
        return this;
    }

    @Override
    public BatchInjectionBuilderImpl toMethod(String name, Value<?> targetValue) {
        if (this.batchBuilder.isDone()) {
            throw BatchBuilderImpl.alreadyInstalled();
        }
        if (this.injectionDestination != null) {
            throw BatchInjectionBuilderImpl.alreadySpecified();
        }
        this.injectionDestination = new MethodInjectionDestination(new LookupMethodValue(new ClassOfValue(targetValue), name, 1), targetValue, Collections.singletonList(Values.injectedValue()));
        this.batchServiceBuilder.getInjections().add(this);
        return this;
    }

    @Override
    public BatchInjectionBuilderImpl toField(String fieldName) {
        if (this.batchBuilder.isDone()) {
            throw BatchBuilderImpl.alreadyInstalled();
        }
        if (this.injectionDestination != null) {
            throw BatchInjectionBuilderImpl.alreadySpecified();
        }
        this.injectionDestination = new FieldInjectionDestination(new LookupFieldValue(new ClassOfValue(this.target), fieldName));
        this.batchServiceBuilder.getInjections().add(this);
        return this;
    }

    @Override
    public BatchInjectionBuilderImpl toField(Field field) {
        return this.toFieldValue(new ImmediateValue<Field>(field));
    }

    @Override
    public BatchInjectionBuilderImpl toFieldValue(Value<Field> fieldValue) {
        if (this.batchBuilder.isDone()) {
            throw BatchBuilderImpl.alreadyInstalled();
        }
        if (this.injectionDestination != null) {
            throw BatchInjectionBuilderImpl.alreadySpecified();
        }
        this.injectionDestination = new FieldInjectionDestination(fieldValue);
        this.batchServiceBuilder.getInjections().add(this);
        return this;
    }

    @Override
    public BatchInjectionBuilderImpl toInjector(Injector<?> injector) {
        if (this.batchBuilder.isDone()) {
            throw BatchBuilderImpl.alreadyInstalled();
        }
        if (this.injectionDestination != null) {
            throw BatchInjectionBuilderImpl.alreadySpecified();
        }
        this.injectionDestination = new InjectorInjectionDestination(injector);
        this.batchServiceBuilder.getInjections().add(this);
        return this;
    }

    @Override
    public BatchInjectionBuilderImpl fromProperty(String propertyName) {
        if (this.batchBuilder.isDone()) {
            throw BatchBuilderImpl.alreadyInstalled();
        }
        if (this.injectionDestination != null) {
            throw BatchInjectionBuilderImpl.alreadySpecified();
        }
        this.injectionSource = new PropertyDelegatingInjectionSource(this.injectionSource, propertyName);
        return this;
    }

    @Override
    public BatchInjectionBuilderImpl fromProperty(Property property) {
        return this.fromPropertyValue(new ImmediateValue<Property>(property));
    }

    @Override
    public BatchInjectionBuilderImpl fromPropertyValue(Value<Property> propertyValue) {
        if (this.batchBuilder.isDone()) {
            throw BatchBuilderImpl.alreadyInstalled();
        }
        if (this.injectionDestination != null) {
            throw BatchInjectionBuilderImpl.alreadySpecified();
        }
        this.injectionSource = new PropertyDelegatingInjectionSource(this.injectionSource, propertyValue);
        return this;
    }

    @Override
    public BatchInjectionBuilderImpl fromMethod(String name, List<? extends Value<Class<?>>> parameterTypes, List<? extends Value<?>> parameterValues) {
        if (this.batchBuilder.isDone()) {
            throw BatchBuilderImpl.alreadyInstalled();
        }
        this.injectionSource = new MethodDelegatingInjectionSource(this.injectionSource, name, parameterTypes, parameterValues);
        return this;
    }

    @Override
    public BatchInjectionBuilderImpl fromMethod(String name, Value<?> target, List<? extends Value<Class<?>>> parameterTypes, List<? extends Value<?>> parameterValues) {
        if (this.batchBuilder.isDone()) {
            throw BatchBuilderImpl.alreadyInstalled();
        }
        this.injectionSource = new MethodInjectionSource(new LookupMethodValue(new ClassOfValue(target), name, parameterTypes), target, parameterValues);
        return this;
    }

    @Override
    public BatchInjectionBuilderImpl fromMethod(String name) {
        if (this.batchBuilder.isDone()) {
            throw BatchBuilderImpl.alreadyInstalled();
        }
        this.injectionSource = new MethodDelegatingInjectionSource(this.injectionSource, name, Values.EMPTY_TYPE_LIST, Values.emptyList());
        return this;
    }

    @Override
    public BatchInjectionBuilderImpl fromMethod(String name, Value<?> targetValue) {
        if (this.batchBuilder.isDone()) {
            throw BatchBuilderImpl.alreadyInstalled();
        }
        this.injectionSource = new MethodInjectionSource(new LookupMethodValue(new ClassOfValue(targetValue), name, Values.EMPTY_TYPE_LIST), targetValue, Values.emptyList());
        return this;
    }

    @Override
    public BatchInjectionBuilderImpl fromMethod(Method method, List<? extends Value<?>> parameterValues) {
        return this.fromMethodValue(new ImmediateValue<Method>(method), (List)parameterValues);
    }

    @Override
    public BatchInjectionBuilderImpl fromMethod(Method method, Value<?> target, List<? extends Value<?>> parameterValues) {
        return this.fromMethodValue(new ImmediateValue<Method>(method), (Value)target, (List)parameterValues);
    }

    @Override
    public BatchInjectionBuilderImpl fromMethodValue(Value<Method> methodValue, List<? extends Value<?>> parameterValues) {
        if (this.batchBuilder.isDone()) {
            throw BatchBuilderImpl.alreadyInstalled();
        }
        this.injectionSource = new MethodDelegatingInjectionSource(this.injectionSource, methodValue, parameterValues);
        return this;
    }

    @Override
    public BatchInjectionBuilderImpl fromMethodValue(Value<Method> methodValue, Value<?> target, List<? extends Value<?>> parameterValues) {
        if (this.batchBuilder.isDone()) {
            throw BatchBuilderImpl.alreadyInstalled();
        }
        this.injectionSource = new MethodInjectionSource(methodValue, target, parameterValues);
        return this;
    }

    @Override
    public BatchInjectionBuilderImpl fromField(String fieldName) {
        if (this.batchBuilder.isDone()) {
            throw BatchBuilderImpl.alreadyInstalled();
        }
        this.injectionSource = new FieldDelegatingInjectionSource(this.injectionSource, fieldName);
        return this;
    }

    @Override
    public BatchInjectionBuilderImpl fromField(Field field) {
        return this.fromFieldValue(new ImmediateValue<Field>(field));
    }

    @Override
    public BatchInjectionBuilderImpl fromFieldValue(Value<Field> fieldValue) {
        if (this.batchBuilder.isDone()) {
            throw BatchBuilderImpl.alreadyInstalled();
        }
        this.injectionSource = new FieldDelegatingInjectionSource(this.injectionSource, fieldValue);
        return this;
    }

    InjectionSource getSource() {
        return this.injectionSource;
    }

    InjectionDestination getDestination() {
        return this.injectionDestination;
    }
}

