/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.msc.service.BatchBuilderImpl;
import org.jboss.msc.service.BatchInjectionBuilderImpl;
import org.jboss.msc.service.BatchServiceBuilder;
import org.jboss.msc.service.Location;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceInjectionSource;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ValueInjectionSource;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;

final class BatchServiceBuilderImpl<T>
implements BatchServiceBuilder<T> {
    private final BatchBuilderImpl batchBuilder;
    private final Value<? extends Service<T>> serviceValue;
    private final ServiceName serviceName;
    private final boolean ifNotExist;
    private Location location;
    private ServiceController.Mode initialMode;
    private final Set<ServiceName> aliases = new HashSet<ServiceName>(0);
    private final Set<ServiceName> dependencies = new HashSet<ServiceName>(0);
    private final List<ServiceListener<? super T>> listeners = new ArrayList<ServiceListener<? super T>>(0);
    private final List<BatchInjectionBuilderImpl> injectionItems = new ArrayList<BatchInjectionBuilderImpl>(0);
    boolean processed;
    boolean visited;
    BatchServiceBuilderImpl<?> prev;
    int i;
    ServiceBuilder<T> builder;

    BatchServiceBuilderImpl(BatchBuilderImpl batchBuilder, Value<? extends Service<T>> serviceValue, ServiceName serviceName, boolean ifNotExist) {
        if (batchBuilder == null) {
            throw new IllegalArgumentException("BatchBuilder can not be null");
        }
        this.batchBuilder = batchBuilder;
        if (serviceValue == null) {
            throw new IllegalArgumentException("ServiceValue can not be null");
        }
        this.serviceValue = serviceValue;
        if (serviceName == null) {
            throw new IllegalArgumentException("ServiceName can not be null");
        }
        this.serviceName = serviceName;
        this.ifNotExist = ifNotExist;
    }

    @Override
    public BatchServiceBuilder<T> addAliases(ServiceName ... aliases) {
        for (ServiceName alias : aliases) {
            if (alias.equals(this.serviceName)) continue;
            this.aliases.add(alias);
        }
        return this;
    }

    @Override
    public BatchServiceBuilderImpl<T> setLocation() {
        if (this.batchBuilder.isDone()) {
            throw BatchBuilderImpl.alreadyInstalled();
        }
        StackTraceElement element = new Throwable().getStackTrace()[1];
        String fileName = element.getFileName();
        int lineNumber = element.getLineNumber();
        return this.setLocation(new Location(fileName, lineNumber, -1, null));
    }

    @Override
    public BatchServiceBuilderImpl<T> setLocation(Location location) {
        if (this.batchBuilder.isDone()) {
            throw BatchBuilderImpl.alreadyInstalled();
        }
        this.location = location;
        return this;
    }

    @Override
    public BatchServiceBuilderImpl<T> setInitialMode(ServiceController.Mode mode) {
        if (this.batchBuilder.isDone()) {
            throw BatchBuilderImpl.alreadyInstalled();
        }
        this.initialMode = mode;
        return this;
    }

    @Override
    public BatchServiceBuilder<T> addDependencies(ServiceName ... newDependencies) {
        if (this.batchBuilder.isDone()) {
            throw BatchBuilderImpl.alreadyInstalled();
        }
        Set<ServiceName> dependencies = this.dependencies;
        for (ServiceName dependency : newDependencies) {
            if (this.serviceName.equals(dependency)) continue;
            dependencies.add(dependency);
        }
        return this;
    }

    @Override
    public BatchServiceBuilder<T> addDependencies(Iterable<ServiceName> newDependencies) {
        if (this.batchBuilder.isDone()) {
            throw BatchBuilderImpl.alreadyInstalled();
        }
        Set<ServiceName> dependencies = this.dependencies;
        for (ServiceName dependency : newDependencies) {
            if (this.serviceName.equals(dependency)) continue;
            dependencies.add(dependency);
        }
        return this;
    }

    @Override
    public BatchInjectionBuilderImpl addDependency(ServiceName dependency) {
        if (this.batchBuilder.isDone()) {
            throw BatchBuilderImpl.alreadyInstalled();
        }
        if (!this.serviceName.equals(dependency)) {
            this.dependencies.add(dependency);
        }
        return new BatchInjectionBuilderImpl(this, new ServiceInjectionSource(dependency), this.batchBuilder);
    }

    @Override
    public BatchInjectionBuilderImpl addInjectionValue(Value<?> value) {
        if (this.batchBuilder.isDone()) {
            throw BatchBuilderImpl.alreadyInstalled();
        }
        return new BatchInjectionBuilderImpl(this, new ValueInjectionSource(value), this.batchBuilder);
    }

    @Override
    public BatchInjectionBuilderImpl addInjection(Object value) {
        if (this.batchBuilder.isDone()) {
            throw BatchBuilderImpl.alreadyInstalled();
        }
        return new BatchInjectionBuilderImpl(this, new ValueInjectionSource(new ImmediateValue<Object>(value)), this.batchBuilder);
    }

    @Override
    public BatchServiceBuilderImpl<T> addListener(ServiceListener<? super T> listener) {
        if (this.batchBuilder.isDone()) {
            throw BatchBuilderImpl.alreadyInstalled();
        }
        this.listeners.add(listener);
        return this;
    }

    @Override
    public BatchServiceBuilderImpl<T> addListener(ServiceListener<? super T> ... serviceListeners) {
        if (this.batchBuilder.isDone()) {
            throw BatchBuilderImpl.alreadyInstalled();
        }
        for (ServiceListener<? super T> listener : serviceListeners) {
            List<ServiceListener<T>> listeners = this.listeners;
            listeners.add(listener);
        }
        return this;
    }

    @Override
    public BatchServiceBuilderImpl<T> addListener(Collection<? extends ServiceListener<? super T>> serviceListeners) {
        if (this.batchBuilder.isDone()) {
            throw BatchBuilderImpl.alreadyInstalled();
        }
        this.listeners.addAll(serviceListeners);
        return this;
    }

    Value<? extends Service<T>> getServiceValue() {
        return this.serviceValue;
    }

    ServiceName getName() {
        return this.serviceName;
    }

    ServiceName[] getAliases() {
        return this.aliases.toArray(new ServiceName[this.aliases.size()]);
    }

    ServiceName[] getDependencies() {
        return this.dependencies.toArray(new ServiceName[this.dependencies.size()]);
    }

    Iterable<? extends ServiceListener<? super T>> getListeners() {
        return this.listeners;
    }

    List<BatchInjectionBuilderImpl> getInjections() {
        return this.injectionItems;
    }

    ServiceController.Mode getInitialMode() {
        return this.initialMode;
    }

    Location getLocation() {
        return this.location;
    }

    boolean isIfNotExist() {
        return this.ifNotExist;
    }
}

