/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

public final class Location {
    private final String fileName;
    private final int lineNumber;
    private final int columnNumber;
    private final Location parentLocation;

    public Location(String fileName, int lineNumber, int columnNumber, Location parentLocation) {
        this.fileName = fileName;
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
        this.parentLocation = parentLocation;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public int hashCode() {
        int result = this.fileName != null ? this.fileName.hashCode() : 0;
        result = 31 * result + this.lineNumber;
        result = 31 * result + this.columnNumber;
        result = 31 * result + (this.parentLocation != null ? this.parentLocation.hashCode() : 0);
        return result;
    }

    public boolean equals(Object obj) {
        return obj instanceof Location && this.equals((Location)obj);
    }

    public boolean equals(Location obj) {
        return this == obj || obj != null && this.lineNumber == obj.lineNumber && this.columnNumber == obj.columnNumber && (this.fileName != null && this.fileName.equals(obj.fileName) || obj.fileName == null) && (this.parentLocation != null && this.parentLocation.equals(obj.parentLocation) || obj.parentLocation == null);
    }

    private void toString(StringBuilder b) {
        if (this.fileName == null) {
            b.append("<Unknown File>");
        } else {
            b.append(this.fileName);
        }
        if (this.lineNumber > 0) {
            b.append(" line ");
            b.append(this.lineNumber);
            if (this.columnNumber > 0) {
                b.append(", column ");
                b.append(this.columnNumber);
            }
        }
        if (this.parentLocation != null) {
            b.append("\n\tincluded from ");
            this.parentLocation.toString(b);
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        this.toString(b);
        return b.toString();
    }
}

