/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import org.jboss.msc.reflect.Property;
import org.jboss.msc.service.DelegatingInjectionSource;
import org.jboss.msc.service.InjectionSource;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainerImpl;
import org.jboss.msc.value.ClassOfValue;
import org.jboss.msc.value.LookupPropertyValue;
import org.jboss.msc.value.PropertyValue;
import org.jboss.msc.value.Value;

public class PropertyDelegatingInjectionSource
extends DelegatingInjectionSource {
    private final String propertyName;
    private final Value<Property> propertyValue;

    public PropertyDelegatingInjectionSource(InjectionSource delegate, String propertyName) {
        super(delegate);
        this.propertyName = propertyName;
        this.propertyValue = null;
    }

    public PropertyDelegatingInjectionSource(InjectionSource delegate, Value<Property> propertyValue) {
        super(delegate);
        this.propertyName = null;
        this.propertyValue = propertyValue;
    }

    @Override
    protected <T> Value<?> getValue(Value<?> delegateValue, Value<T> serviceValue, ServiceBuilder<T> serviceBuilder, ServiceContainerImpl container) {
        return new PropertyValue(this.getPropertyValue(delegateValue), delegateValue);
    }

    private Value<Property> getPropertyValue(Value<?> delegateValue) {
        if (this.propertyValue != null) {
            return this.propertyValue;
        }
        if (this.propertyName == null) {
            throw new IllegalStateException("Either property value or property name is required");
        }
        return new LookupPropertyValue(new ClassOfValue(delegateValue), this.propertyName);
    }
}

