/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.util.Collections;
import org.jboss.msc.service.InjectionSource;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainerImpl;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.ClassOfValue;
import org.jboss.msc.value.LookupGetMethodValue;
import org.jboss.msc.value.MethodValue;
import org.jboss.msc.value.Value;
import org.jboss.msc.value.Values;

final class PropertyInjectionSource
extends InjectionSource {
    private final ServiceName dependency;
    private final String propertySpec;

    PropertyInjectionSource(ServiceName dependency, String propertySpec) {
        this.dependency = dependency;
        this.propertySpec = propertySpec;
    }

    @Override
    protected <T> Value<?> getValue(Value<T> serviceValue, ServiceBuilder<T> serviceBuilder, ServiceContainerImpl registry) {
        String propertySpec = this.propertySpec;
        Value<Object> prevValue = registry.getService(this.dependency);
        int current = 0;
        int next = propertySpec.indexOf(46);
        while (current != -1) {
            String property = next == -1 ? propertySpec.substring(current) : propertySpec.substring(current, next);
            prevValue = Values.cached(new MethodValue(new LookupGetMethodValue(new ClassOfValue(prevValue), property), prevValue, Collections.emptyList()));
            current = next;
            next = propertySpec.indexOf(46, current + 1);
        }
        return prevValue;
    }
}

