/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.jboss.msc.ref.Reaper;
import org.jboss.msc.ref.Reference;
import org.jboss.msc.ref.WeakReference;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.BatchBuilderImpl;
import org.jboss.msc.service.BatchInjectionBuilderImpl;
import org.jboss.msc.service.BatchServiceBuilderImpl;
import org.jboss.msc.service.CircularDependencyException;
import org.jboss.msc.service.DuplicateServiceException;
import org.jboss.msc.service.MissingDependencyException;
import org.jboss.msc.service.ResolutionException;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceBuilderImpl;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceControllerImpl;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceNotFoundException;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.service.ValueInjection;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;

final class ServiceContainerImpl
implements ServiceContainer {
    final Object lock = new Object();
    final ServiceControllerImpl<ServiceContainer> root;
    private volatile Executor executor;
    private final ConcurrentMap<ServiceName, ServiceController<?>> registry = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServiceContainerImpl() {
        Set set;
        Set set2 = set = ShutdownHookHolder.containers;
        synchronized (set2) {
            boolean down = ShutdownHookHolder.down;
            ServiceBuilderImpl builder = new ServiceBuilderImpl(this, new ImmediateValue<1>(new Service<ServiceContainer>(){

                @Override
                public void start(StartContext context) throws StartException {
                }

                @Override
                public void stop(StopContext context) {
                }

                @Override
                public ServiceContainer getValue() throws IllegalStateException {
                    return ServiceContainerImpl.this;
                }
            }), null);
            this.root = ((ServiceBuilderImpl)builder.setInitialMode(down ? ServiceController.Mode.NEVER : ServiceController.Mode.AUTOMATIC)).create();
            if (!down) {
                set.add(new WeakReference<ServiceContainerImpl, Void>(this, null, new Reaper<ServiceContainerImpl, Void>(){

                    @Override
                    public void reap(Reference<ServiceContainerImpl, Void> reference) {
                        ShutdownHookHolder.containers.remove(reference);
                    }
                }));
            }
        }
    }

    public <T> ServiceBuilderImpl<T> buildService(Value<? extends Service<? extends T>> service) {
        return this.buildService(null, service);
    }

    public <T> ServiceBuilderImpl<T> buildService(ServiceName serviceName, Value<? extends Service<? extends T>> service) {
        ServiceBuilderImpl builder = new ServiceBuilderImpl(this, service, serviceName);
        builder.addDependency(this.root);
        return builder;
    }

    @Override
    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    @Override
    public void shutdown() {
        this.root.setMode(ServiceController.Mode.NEVER);
    }

    protected void finalize() throws Throwable {
        this.root.setMode(ServiceController.Mode.NEVER);
    }

    Executor getExecutor() {
        Executor executor = this.executor;
        return executor != null ? executor : ExecutorHolder.VALUE;
    }

    @Override
    public BatchBuilderImpl batchBuilder() {
        return new BatchBuilderImpl(this);
    }

    void install(BatchBuilderImpl serviceBatch) throws ServiceRegistryException {
        try {
            this.resolve(serviceBatch.getBatchServices());
        }
        catch (ResolutionException e) {
            throw new ServiceRegistryException("Failed to resolve dependencies", e);
        }
    }

    private void resolve(Map<ServiceName, BatchServiceBuilderImpl<?>> services) throws ServiceRegistryException {
        for (BatchServiceBuilderImpl<?> batchEntry : services.values()) {
            if (batchEntry.processed) continue;
            this.doResolve(batchEntry, services);
        }
    }

    private <T> void doResolve(BatchServiceBuilderImpl<T> entry, Map<ServiceName, BatchServiceBuilderImpl<?>> services) throws ServiceRegistryException {
        block0: while (entry != null) {
            Value<Service<T>> serviceValue = entry.getServiceValue();
            ServiceName name = entry.getName();
            ServiceBuilder<T> builder = entry.builder;
            if (builder == null) {
                entry.builder = this.buildService(name, serviceValue);
                builder = entry.builder;
            }
            ServiceName[] deps = entry.getDependencies();
            ServiceName[] aliases = entry.getAliases();
            while (entry.i < deps.length) {
                ServiceName dependencyName = deps[entry.i];
                ServiceController dependencyController = (ServiceController)this.registry.get(dependencyName);
                if (dependencyController == null) {
                    BatchServiceBuilderImpl<?> dependencyEntry = services.get(dependencyName);
                    if (dependencyEntry == null) {
                        throw new MissingDependencyException("Missing dependency: " + name + " depends on " + dependencyName + " which can not be found");
                    }
                    assert (dependencyEntry.prev == null);
                    dependencyEntry.prev = entry;
                    entry.visited = true;
                    entry = dependencyEntry;
                    if (!entry.visited) continue block0;
                    throw new CircularDependencyException("Circular dependency discovered: " + name);
                }
                builder.addDependency(dependencyController);
                ++entry.i;
            }
            builder.addListener(new ServiceUnregisterListener(name, aliases));
            for (ServiceListener<T> listener : entry.getListeners()) {
                builder.addListener(listener);
            }
            for (BatchInjectionBuilderImpl injection : entry.getInjections()) {
                builder.addValueInjection(this.valueInjection(serviceValue, builder, injection));
            }
            ServiceController.Mode initialMode = entry.getInitialMode();
            builder.setInitialMode(ServiceController.Mode.NEVER);
            ServiceController serviceController = builder.create();
            if (this.registry.putIfAbsent(name, serviceController) != null) {
                if (!entry.isIfNotExist()) {
                    throw new DuplicateServiceException("Duplicate service name provided: " + name);
                }
            } else {
                for (ServiceName alias : aliases) {
                    if (this.registry.putIfAbsent(alias, serviceController) == null) continue;
                    throw new DuplicateServiceException("Duplicate service name provided: " + alias);
                }
            }
            serviceController.setMode(initialMode == null ? ServiceController.Mode.AUTOMATIC : initialMode);
            entry.builder = null;
            BatchServiceBuilderImpl<?> prev = entry.prev;
            entry.prev = null;
            entry.processed = true;
            entry.visited = false;
            entry = prev;
        }
    }

    private <T> ValueInjection<T> valueInjection(Value<? extends Service<T>> serviceValue, ServiceBuilder<T> builder, BatchInjectionBuilderImpl injection) {
        return new ValueInjection(injection.getSource().getValue(serviceValue, builder, this), injection.getDestination().getInjector(serviceValue, builder, this));
    }

    @Override
    public ServiceController<?> getRequiredService(ServiceName serviceName) throws ServiceNotFoundException {
        ServiceController<?> controller = this.getService(serviceName);
        if (controller == null) {
            throw new ServiceNotFoundException("Service " + serviceName + " not found");
        }
        return controller;
    }

    @Override
    public ServiceController<?> getService(ServiceName serviceName) {
        return (ServiceController)this.registry.get(serviceName);
    }

    private class ServiceUnregisterListener
    extends AbstractServiceListener<Object> {
        private final ServiceName serviceName;
        private final ServiceName[] aliases;

        private ServiceUnregisterListener(ServiceName serviceName, ServiceName[] aliases) {
            this.serviceName = serviceName;
            this.aliases = aliases;
        }

        @Override
        public void serviceRemoved(ServiceController serviceController) {
            if (!ServiceContainerImpl.this.registry.remove(this.serviceName, serviceController)) {
                throw new RuntimeException("Removed service [" + this.serviceName + "] was not unregistered");
            }
            for (ServiceName alias : this.aliases) {
                if (ServiceContainerImpl.this.registry.remove(alias, serviceController)) continue;
                throw new RuntimeException("Removed service alias [" + alias + "] was not unregistered");
            }
        }
    }

    static final class LatchListener
    extends CountDownLatch
    implements ServiceListener<Object> {
        public LatchListener(int count) {
            super(count);
        }

        @Override
        public void listenerAdded(ServiceController<? extends Object> serviceController) {
            ServiceController.State state = serviceController.getState();
            if (state == ServiceController.State.DOWN || state == ServiceController.State.REMOVED) {
                this.countDown();
                serviceController.removeListener(this);
            }
        }

        @Override
        public void serviceStarting(ServiceController<? extends Object> serviceController) {
        }

        @Override
        public void serviceStarted(ServiceController<? extends Object> serviceController) {
        }

        @Override
        public void serviceFailed(ServiceController<? extends Object> serviceController, StartException reason) {
        }

        @Override
        public void serviceStopping(ServiceController<? extends Object> serviceController) {
        }

        @Override
        public void serviceStopped(ServiceController<? extends Object> serviceController) {
            this.countDown();
            serviceController.removeListener(this);
        }

        @Override
        public void serviceRemoved(ServiceController<? extends Object> serviceController) {
        }
    }

    private static final class ShutdownHookHolder {
        private static final Set<Reference<ServiceContainerImpl, Void>> containers;
        private static boolean down;

        private ShutdownHookHolder() {
        }

        static {
            down = false;
            containers = new HashSet<Reference<ServiceContainerImpl, Void>>();
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    Thread hook = new Thread(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            LatchListener listener;
                            Set set;
                            Set set2 = set = containers;
                            synchronized (set2) {
                                down = true;
                                listener = new LatchListener(set.size());
                                for (Reference containerRef : set) {
                                    ServiceContainerImpl container = (ServiceContainerImpl)containerRef.get();
                                    if (container == null) continue;
                                    ServiceControllerImpl<ServiceContainer> root = container.root;
                                    root.setMode(ServiceController.Mode.NEVER);
                                    root.addListener(listener);
                                }
                                set.clear();
                            }
                            while (true) {
                                try {
                                    if (!listener.await(10L, TimeUnit.SECONDS)) {
                                        System.err.println("Failed to shut down in 10 seconds; exiting");
                                        return;
                                    }
                                }
                                catch (InterruptedException interruptedException) {
                                    continue;
                                }
                                break;
                            }
                        }
                    });
                    hook.setDaemon(true);
                    Runtime.getRuntime().addShutdownHook(hook);
                    return null;
                }
            });
        }
    }

    private static final class ExecutorHolder {
        private static final Executor VALUE;

        private ExecutorHolder() {
        }

        static {
            ThreadPoolExecutor executor = new ThreadPoolExecutor(0, 1, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread thread = new Thread(r);
                    thread.setDaemon(true);
                    thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                        @Override
                        public void uncaughtException(Thread t, Throwable e) {
                            e.printStackTrace(System.err);
                        }
                    });
                    return thread;
                }
            });
            executor.allowCoreThreadTimeOut(true);
            executor.setCorePoolSize(1);
            VALUE = executor;
        }
    }
}

