/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.util.Arrays;
import java.util.concurrent.Executor;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.IdentityHashSet;
import org.jboss.msc.service.Location;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceContainerImpl;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.service.ValueInjection;
import org.jboss.msc.value.Value;

final class ServiceControllerImpl<S>
implements ServiceController<S> {
    private static final String ILLEGAL_CONTROLLER_STATE = "Illegal controller state";
    private static final String START_FAIL_EXCEPTION = "Start failed due to exception";
    private static final String SERVICE_REMOVED = "Service has been removed";
    private static final String SERVICE_NOT_AVAILABLE = "Service is not available";
    private static final ServiceListener<?>[] NO_LISTENERS = new ServiceListener[0];
    private final ServiceContainerImpl container;
    private final Value<? extends Service<? extends S>> serviceValue;
    private final Location location;
    private final ServiceControllerImpl<?>[] dependencies;
    private final ValueInjection<?>[] injections;
    private final IdentityHashSet<ServiceListener<? super S>> listeners = new IdentityHashSet(0);
    private final ServiceName serviceName;
    private StartException startException;
    private ServiceController.Mode mode = ServiceController.Mode.NEVER;
    private Substate state = Substate.DOWN;
    private int demandedByCount;
    private int upperCount;
    private int runningDependents;
    private int runningListeners;
    private final ServiceListener<Object> dependencyListener = new DependencyListener();

    ServiceControllerImpl(ServiceContainerImpl container, Value<? extends Service<? extends S>> serviceValue, Location location, ServiceControllerImpl<?>[] dependencies, ValueInjection<?>[] injections, ServiceName serviceName) {
        this.container = container;
        this.serviceValue = serviceValue;
        this.location = location;
        this.dependencies = dependencies;
        this.injections = injections;
        this.serviceName = serviceName;
        this.upperCount = -dependencies.length;
        for (ServiceControllerImpl<?> controller : dependencies) {
            controller.addListener(this.dependencyListener);
        }
    }

    @Override
    public ServiceContainer getServiceContainer() {
        return this.container;
    }

    @Override
    public ServiceController.State getState() {
        return this.state.getState();
    }

    @Override
    public S getValue() throws IllegalStateException {
        return (S)this.serviceValue.getValue().getValue();
    }

    @Override
    public ServiceName getName() {
        return this.serviceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(ServiceListener<? super S> listener) {
        assert (!this.lockHeld());
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            ++this.runningListeners;
            Substate state = this.state;
            if (state != Substate.REMOVED) {
                this.listeners.add(listener);
            }
        }
        this.invokeListener(listener, null);
    }

    private boolean lockHeld() {
        return Thread.holdsLock(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void invokeListener(ServiceListener<? super S> listener, ServiceController.State state) {
        assert (!this.lockHeld());
        try {
            if (state == null) {
                listener.listenerAdded(this);
                return;
            }
            switch (state) {
                case DOWN: {
                    listener.serviceStopped(this);
                    return;
                }
                case STARTING: {
                    listener.serviceStarting(this);
                    return;
                }
                case START_FAILED: {
                    listener.serviceFailed(this, this.startException);
                    return;
                }
                case UP: {
                    listener.serviceStarted(this);
                    return;
                }
                case STOPPING: {
                    listener.serviceStopping(this);
                    return;
                }
                case REMOVED: {
                    listener.serviceRemoved(this);
                    return;
                }
            }
            return;
        }
        catch (Throwable throwable) {
            return;
        }
        finally {
            this.doFinishListener(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(ServiceListener<? super S> listener) {
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove() throws IllegalStateException {
        ServiceListener<S>[] listeners;
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            if (this.state == Substate.DOWN) {
                if (this.runningListeners != 0) {
                    this.state = Substate.DOWN_REMOVING;
                    return;
                }
            } else {
                throw new IllegalStateException(ILLEGAL_CONTROLLER_STATE);
            }
            listeners = this.getListeners(0, Substate.REMOVED);
        }
        this.runListeners(listeners, ServiceController.State.REMOVED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartException getStartException() {
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            return this.startException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void retry() {
        ServiceListener<S>[] listeners;
        assert (!this.lockHeld());
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            if (this.state.getState() != ServiceController.State.START_FAILED) {
                return;
            }
            if (this.upperCount == 1) {
                assert (this.mode != ServiceController.Mode.NEVER);
            } else {
                this.state = Substate.START_FAILED_RETRY_PENDING;
                return;
            }
            listeners = this.getListeners(1, Substate.STARTING);
        }
        this.doStart(listeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceController.Mode getMode() {
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            return this.mode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMode(ServiceController.Mode newMode) {
        ServiceListener<S>[] listeners;
        Enum newState;
        block50: {
            assert (!this.lockHeld());
            newState = null;
            listeners = null;
            ServiceControllerImpl serviceControllerImpl = this;
            synchronized (serviceControllerImpl) {
                Substate state = this.state;
                if (state == Substate.REMOVED && newMode != ServiceController.Mode.NEVER) {
                    throw new IllegalStateException(SERVICE_REMOVED);
                }
                ServiceController.Mode oldMode = this.mode;
                this.mode = newMode;
                block2 : switch (oldMode) {
                    case NEVER: {
                        switch (newMode) {
                            case NEVER: {
                                return;
                            }
                            case ON_DEMAND: {
                                if (this.demandedByCount > 0) {
                                    ++this.upperCount;
                                }
                                if (state != Substate.DOWN || this.upperCount <= 0) break;
                                newState = Substate.STARTING;
                                listeners = this.getListeners(1, (Substate)newState);
                                break block2;
                            }
                            case AUTOMATIC: {
                                if (this.upperCount++ != 0 || state != Substate.DOWN) break;
                                newState = Substate.STARTING;
                                listeners = this.getListeners(1, (Substate)newState);
                                break block2;
                            }
                            case IMMEDIATE: {
                                this.doDemandParents();
                                if (this.upperCount++ != 0 || state != Substate.DOWN) break;
                                newState = Substate.STARTING;
                                listeners = this.getListeners(1, (Substate)newState);
                            }
                        }
                        break;
                    }
                    case ON_DEMAND: {
                        switch (newMode) {
                            case NEVER: {
                                if (this.demandedByCount > 0) {
                                    --this.upperCount;
                                }
                                if (state == Substate.UP) {
                                    newState = Substate.STOPPING;
                                    listeners = this.getListeners(1, (Substate)newState);
                                    break block2;
                                }
                                if (state.getState() != ServiceController.State.START_FAILED) break;
                                newState = Substate.DOWN;
                                listeners = this.getListeners(0, (Substate)newState);
                                break block2;
                            }
                            case ON_DEMAND: {
                                return;
                            }
                            case AUTOMATIC: {
                                if (this.demandedByCount == 0) {
                                    ++this.upperCount;
                                }
                                if (this.upperCount <= 0 || state != Substate.DOWN) break;
                                newState = Substate.STARTING;
                                listeners = this.getListeners(1, (Substate)newState);
                                break block2;
                            }
                            case IMMEDIATE: {
                                this.doDemandParents();
                                if (this.demandedByCount == 0) {
                                    ++this.upperCount;
                                }
                                if (this.upperCount <= 0 || state != Substate.DOWN) break;
                                newState = Substate.STARTING;
                                listeners = this.getListeners(1, (Substate)newState);
                            }
                        }
                        break;
                    }
                    case AUTOMATIC: {
                        switch (newMode) {
                            case NEVER: {
                                --this.upperCount;
                                if (state != Substate.UP) break;
                                newState = Substate.STOPPING;
                                listeners = this.getListeners(1, (Substate)newState);
                                break block2;
                            }
                            case ON_DEMAND: {
                                if (this.demandedByCount == 0) {
                                    --this.upperCount;
                                }
                                if (state != Substate.UP || this.upperCount != 0) break;
                                newState = Substate.STOPPING;
                                listeners = this.getListeners(1, (Substate)newState);
                                break block2;
                            }
                            case AUTOMATIC: {
                                return;
                            }
                            case IMMEDIATE: {
                                this.doDemandParents();
                            }
                        }
                        break;
                    }
                    case IMMEDIATE: {
                        switch (newMode) {
                            case NEVER: {
                                --this.upperCount;
                                if (state == Substate.UP) {
                                    newState = Substate.STOPPING;
                                    listeners = this.getListeners(1, (Substate)newState);
                                    break block2;
                                }
                                break block50;
                            }
                            case ON_DEMAND: {
                                if (this.demandedByCount == 0) {
                                    --this.upperCount;
                                }
                                if (state == Substate.UP && this.upperCount == 0) {
                                    newState = Substate.STOPPING;
                                    listeners = this.getListeners(1, (Substate)newState);
                                    break block2;
                                }
                                break block50;
                            }
                            case AUTOMATIC: {
                                this.doUndemandParents();
                                break block2;
                            }
                            case IMMEDIATE: {
                                return;
                            }
                        }
                    }
                }
            }
        }
        if (newState != null) {
            switch (1.$SwitchMap$org$jboss$msc$service$ServiceControllerImpl$Substate[newState.ordinal()]) {
                case 1: {
                    this.doStart(listeners);
                    break;
                }
                case 2: {
                    this.doStop(listeners);
                    break;
                }
                case 3: {
                    this.doStopComplete(listeners);
                }
            }
        }
    }

    ServiceListener<? super S>[] getListeners(int plusCount, Substate newState) {
        assert (this.lockHeld());
        IdentityHashSet<ServiceListener<S>> listeners = this.listeners;
        int size = listeners.size();
        this.runningListeners = size + plusCount;
        ServiceListener<?>[] listenersArray = listeners.toScatteredArray(NO_LISTENERS);
        this.state = newState;
        switch (newState) {
            case STARTING: 
            case DOWN: {
                this.startException = null;
                break;
            }
            case REMOVED: {
                ServiceListener<Object> dependencyListener = this.dependencyListener;
                for (ServiceControllerImpl<?> controller : this.dependencies) {
                    controller.removeListener(dependencyListener);
                }
                this.listeners.clear();
                Arrays.fill(this.dependencies, null);
                break;
            }
        }
        return listenersArray;
    }

    void runListeners(ServiceListener<? super S>[] listeners, ServiceController.State state) {
        assert (!this.lockHeld());
        Executor executor = this.container.getExecutor();
        for (ServiceListener<? super S> listener : listeners) {
            if (listener == null) continue;
            try {
                executor.execute(new ListenerTask(listener, state));
            }
            catch (RuntimeException e) {
                // empty catch block
            }
        }
    }

    private void doStart(ServiceListener<? super S>[] listeners) {
        try {
            assert (!this.lockHeld());
            Service<? extends S> service = this.serviceValue.getValue();
            if (service == null) {
                throw new IllegalStateException(SERVICE_NOT_AVAILABLE);
            }
            this.runListeners(listeners, ServiceController.State.STARTING);
            Executor executor = this.container.getExecutor();
            executor.execute(new StartTask(service));
        }
        catch (Throwable t) {
            this.doFail(new StartException(START_FAIL_EXCEPTION, t, this.location, this.serviceName));
        }
    }

    private <T> void doInject(ValueInjection<T> injection) {
        injection.getTarget().inject(injection.getSource().getValue());
    }

    private void doStartComplete(ServiceListener<? super S>[] listeners) {
        this.runListeners(listeners, ServiceController.State.UP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFinishListener(StartException e) {
        assert (!this.lockHeld());
        Enum newState = null;
        ServiceListener<S>[] listeners = null;
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            if (e != null) {
                this.startException = e;
            }
            if (--this.runningListeners == 0) {
                switch (this.state) {
                    case DOWN: {
                        if (this.upperCount <= 0 || this.mode == ServiceController.Mode.NEVER) break;
                        newState = Substate.STARTING;
                        listeners = this.getListeners(1, (Substate)newState);
                        break;
                    }
                    case DOWN_REMOVING: {
                        listeners = this.getListeners(0, Substate.REMOVED);
                        break;
                    }
                    case STARTING: {
                        if (this.startException != null) {
                            newState = Substate.START_FAILED;
                            listeners = this.getListeners(0, (Substate)newState);
                            break;
                        }
                        newState = Substate.UP;
                        listeners = this.getListeners(0, (Substate)newState);
                        break;
                    }
                    case START_FAILED: {
                        if (this.upperCount <= 0 || this.mode == ServiceController.Mode.NEVER) {
                            newState = Substate.DOWN;
                            listeners = this.getListeners(0, (Substate)newState);
                            break;
                        }
                        if (this.state != Substate.START_FAILED_RETRY_PENDING) break;
                        newState = Substate.STARTING;
                        listeners = this.getListeners(1, (Substate)newState);
                        break;
                    }
                    case UP: {
                        if (this.upperCount > 0 && this.mode != ServiceController.Mode.NEVER) break;
                        newState = Substate.STOPPING;
                        listeners = this.getListeners(1, (Substate)newState);
                        break;
                    }
                    case STOPPING: {
                        newState = Substate.DOWN;
                        listeners = this.getListeners(0, (Substate)newState);
                        break;
                    }
                }
            }
        }
        if (newState != null) {
            switch (1.$SwitchMap$org$jboss$msc$service$ServiceControllerImpl$Substate[newState.ordinal()]) {
                case 1: {
                    this.doStart(listeners);
                    break;
                }
                case 7: {
                    this.doStartComplete(listeners);
                    break;
                }
                case 2: {
                    this.doStop(listeners);
                    break;
                }
                case 3: {
                    this.doStopComplete(listeners);
                    break;
                }
                case 4: {
                    this.runListeners(listeners, ServiceController.State.REMOVED);
                    break;
                }
                case 6: {
                    this.runListeners(listeners, ServiceController.State.START_FAILED);
                }
            }
        }
    }

    private void doFail(StartException e) {
        assert (this.lockHeld());
        assert (this.state == Substate.STARTING);
        this.state = Substate.START_FAILED;
        this.startException = e;
    }

    private void doStop(ServiceListener<? super S>[] listeners) {
        assert (this.lockHeld());
        assert (this.state == Substate.UP);
        try {
            Service<? extends S> service = this.serviceValue.getValue();
            if (service == null) {
                throw new IllegalStateException(SERVICE_NOT_AVAILABLE);
            }
            this.runListeners(listeners, ServiceController.State.STOPPING);
            Executor executor = this.container.getExecutor();
            executor.execute(new StopTask(service));
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private void doStopComplete(ServiceListener<? super S>[] listeners) {
        this.runListeners(listeners, ServiceController.State.DOWN);
    }

    private void doDemandParents() {
        assert (this.lockHeld());
        for (ServiceControllerImpl<?> dependency : this.dependencies) {
            dependency.addDemand();
        }
    }

    private void doUndemandParents() {
        assert (this.lockHeld());
        for (ServiceControllerImpl<?> dependency : this.dependencies) {
            dependency.removeDemand();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDemand() {
        ServiceListener<S>[] listeners;
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            int cnt = this.demandedByCount++;
            if (cnt != 0 || this.mode != ServiceController.Mode.ON_DEMAND) {
                return;
            }
            if (this.upperCount++ != 0 || this.state != Substate.DOWN || this.runningListeners != 0) {
                return;
            }
            listeners = this.getListeners(1, Substate.STARTING);
        }
        if (listeners != null) {
            this.doStart(listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDemand() {
        ServiceListener<S>[] listeners;
        boolean stop;
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            int cnt = --this.demandedByCount;
            if (cnt != 0 || this.mode != ServiceController.Mode.ON_DEMAND) {
                return;
            }
            if (--this.upperCount != 0 || this.runningListeners != 0) {
                return;
            }
            if (this.state == Substate.UP) {
                stop = true;
                listeners = this.getListeners(1, Substate.STOPPING);
            } else if (this.state.getState() == ServiceController.State.START_FAILED) {
                stop = false;
                listeners = this.getListeners(0, Substate.DOWN);
            } else {
                return;
            }
        }
        if (stop) {
            this.doStop(listeners);
        } else {
            this.doStopComplete(listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dependentStarted() {
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            ++this.runningDependents;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dependentStopped() {
        ServiceListener<S>[] listeners;
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            if (--this.runningDependents != 0) {
                return;
            }
            if (this.state != Substate.STOPPING || this.runningListeners != 0) {
                return;
            }
            listeners = this.getListeners(0, Substate.DOWN);
        }
        this.doStopComplete(listeners);
    }

    private class DependencyListener
    extends AbstractServiceListener<Object> {
        private DependencyListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void listenerAdded(ServiceController<? extends Object> serviceController) {
            ServiceListener<S>[] listeners = null;
            if (serviceController.getState() == ServiceController.State.UP) {
                ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
                synchronized (serviceControllerImpl) {
                    if (++ServiceControllerImpl.this.upperCount == 1 && ServiceControllerImpl.this.mode != ServiceController.Mode.NEVER && ServiceControllerImpl.this.runningListeners == 0 && ServiceControllerImpl.this.state == Substate.DOWN) {
                        listeners = ServiceControllerImpl.this.getListeners(1, Substate.STARTING);
                    }
                }
                if (listeners != null) {
                    ServiceControllerImpl.this.doStart(listeners);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void serviceStarted(ServiceController<? extends Object> serviceController) {
            ServiceListener<S>[] listeners = null;
            ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
            synchronized (serviceControllerImpl) {
                if (++ServiceControllerImpl.this.upperCount == 1 && ServiceControllerImpl.this.mode != ServiceController.Mode.NEVER && ServiceControllerImpl.this.runningListeners == 0 && ServiceControllerImpl.this.state == Substate.DOWN) {
                    listeners = ServiceControllerImpl.this.getListeners(1, Substate.STARTING);
                }
            }
            if (listeners != null) {
                ServiceControllerImpl.this.doStart(listeners);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void serviceStopping(ServiceController<? extends Object> serviceController) {
            ServiceListener<S>[] listeners = null;
            ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
            synchronized (serviceControllerImpl) {
                if ((--ServiceControllerImpl.this.upperCount == 0 || ServiceControllerImpl.this.mode == ServiceController.Mode.NEVER) && ServiceControllerImpl.this.runningListeners == 0 && ServiceControllerImpl.this.state == Substate.UP) {
                    listeners = ServiceControllerImpl.this.getListeners(1, Substate.STOPPING);
                }
            }
            if (listeners != null) {
                ServiceControllerImpl.this.doStop(listeners);
            }
        }
    }

    private class ListenerTask
    implements Runnable {
        private final ServiceListener<? super S> listener;
        private final ServiceController.State state;

        ListenerTask(ServiceListener<? super S> listener, ServiceController.State state) {
            this.listener = listener;
            this.state = state;
        }

        @Override
        public void run() {
            assert (!ServiceControllerImpl.this.lockHeld());
            ServiceControllerImpl.this.invokeListener(this.listener, this.state);
        }
    }

    private class StopTask
    implements Runnable {
        private final Service<?> service;

        public StopTask(Service<?> service) {
            this.service = service;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            assert (!ServiceControllerImpl.this.lockHeld());
            StopContextImpl context = new StopContextImpl();
            try {
                this.service.stop(context);
                ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
                synchronized (serviceControllerImpl) {
                    if (context.state == ContextState.SYNC) {
                        context.state = ContextState.COMPLETE;
                        for (ValueInjection injection : ServiceControllerImpl.this.injections) {
                            injection.getTarget().uninject();
                        }
                        ServiceControllerImpl.this.doFinishListener(null);
                    }
                }
            }
            catch (Throwable t) {
                ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
                synchronized (serviceControllerImpl) {
                    ContextState oldState = context.state;
                    if (oldState == ContextState.SYNC || oldState == ContextState.ASYNC) {
                        context.state = ContextState.FAILED;
                        for (ValueInjection injection : ServiceControllerImpl.this.injections) {
                            injection.getTarget().uninject();
                        }
                        ServiceControllerImpl.this.doFinishListener(null);
                    }
                }
            }
        }
    }

    private class StartTask
    implements Runnable {
        private final Service<?> service;

        public StartTask(Service<?> service) {
            this.service = service;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            assert (!ServiceControllerImpl.this.lockHeld());
            StartContextImpl context = new StartContextImpl();
            try {
                int i;
                ValueInjection[] injections = ServiceControllerImpl.this.injections;
                int injectionsLength = injections.length;
                boolean ok = false;
                try {
                    for (i = 0; i < injectionsLength; ++i) {
                        ValueInjection injection = injections[i];
                        ServiceControllerImpl.this.doInject(injection);
                    }
                    ok = true;
                }
                finally {
                    if (!ok) {
                        while (i >= 0) {
                            injections[i].getTarget().uninject();
                            --i;
                        }
                    }
                }
                this.service.start(context);
                ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
                synchronized (serviceControllerImpl) {
                    if (context.state == ContextState.SYNC) {
                        context.state = ContextState.COMPLETE;
                        ServiceControllerImpl.this.doFinishListener(null);
                    }
                }
            }
            catch (StartException e) {
                e.setServiceName(ServiceControllerImpl.this.serviceName);
                ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
                synchronized (serviceControllerImpl) {
                    ContextState oldState = context.state;
                    if (oldState == ContextState.SYNC || oldState == ContextState.ASYNC) {
                        context.state = ContextState.FAILED;
                        ServiceControllerImpl.this.doFinishListener(e);
                    }
                }
            }
            catch (Throwable t) {
                ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
                synchronized (serviceControllerImpl) {
                    ContextState oldState = context.state;
                    if (oldState == ContextState.SYNC || oldState == ContextState.ASYNC) {
                        context.state = ContextState.FAILED;
                        ServiceControllerImpl.this.startException = new StartException("Failed to start service", t, ServiceControllerImpl.this.location, ServiceControllerImpl.this.serviceName);
                        ServiceControllerImpl.this.doFinishListener(null);
                    }
                }
            }
        }
    }

    static enum Substate {
        DOWN(ServiceController.State.DOWN),
        DOWN_REMOVING(ServiceController.State.DOWN),
        STARTING(ServiceController.State.STARTING),
        START_FAILED(ServiceController.State.START_FAILED),
        START_FAILED_RETRY_PENDING(ServiceController.State.START_FAILED),
        UP(ServiceController.State.UP),
        STOPPING(ServiceController.State.STOPPING),
        REMOVED(ServiceController.State.REMOVED);

        private final ServiceController.State state;

        private Substate(ServiceController.State state) {
            this.state = state;
        }

        public ServiceController.State getState() {
            return this.state;
        }
    }

    private class StopContextImpl
    implements StopContext {
        private ContextState state = ContextState.SYNC;

        private StopContextImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void asynchronous() throws IllegalStateException {
            ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
            synchronized (serviceControllerImpl) {
                if (this.state != ContextState.SYNC) {
                    throw new IllegalStateException(ServiceControllerImpl.ILLEGAL_CONTROLLER_STATE);
                }
                this.state = ContextState.ASYNC;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void complete() throws IllegalStateException {
            ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
            synchronized (serviceControllerImpl) {
                if (this.state == ContextState.ASYNC) {
                    this.state = ContextState.COMPLETE;
                    for (ValueInjection injection : ServiceControllerImpl.this.injections) {
                        injection.getTarget().uninject();
                    }
                } else {
                    throw new IllegalStateException(ServiceControllerImpl.ILLEGAL_CONTROLLER_STATE);
                }
                ServiceControllerImpl.this.doFinishListener(null);
            }
        }

        @Override
        public ServiceController<?> getController() {
            return ServiceControllerImpl.this;
        }
    }

    private class StartContextImpl
    implements StartContext {
        private ContextState state = ContextState.SYNC;

        private StartContextImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void failed(StartException reason) throws IllegalStateException {
            ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
            synchronized (serviceControllerImpl) {
                if (this.state != ContextState.ASYNC) {
                    throw new IllegalStateException(ServiceControllerImpl.ILLEGAL_CONTROLLER_STATE);
                }
                this.state = ContextState.FAILED;
                ServiceControllerImpl.this.doFinishListener(reason);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void asynchronous() throws IllegalStateException {
            ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
            synchronized (serviceControllerImpl) {
                if (this.state != ContextState.SYNC) {
                    throw new IllegalStateException(ServiceControllerImpl.ILLEGAL_CONTROLLER_STATE);
                }
                this.state = ContextState.ASYNC;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void complete() throws IllegalStateException {
            ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
            synchronized (serviceControllerImpl) {
                if (this.state != ContextState.ASYNC) {
                    throw new IllegalStateException(ServiceControllerImpl.ILLEGAL_CONTROLLER_STATE);
                }
                this.state = ContextState.COMPLETE;
                ServiceControllerImpl.this.doFinishListener(null);
            }
        }

        @Override
        public ServiceController<?> getController() {
            return ServiceControllerImpl.this;
        }
    }

    static enum ContextState {
        SYNC,
        ASYNC,
        COMPLETE,
        FAILED;

    }
}

