/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.ServiceController;

public final class ServiceUtils {
    private ServiceUtils() {
    }

    public static void undeployAll(Runnable completeTask, ServiceController<?> ... controllers) {
        ServiceUtils.undeployAll(completeTask, Arrays.asList(controllers));
    }

    public static void undeployAll(final Runnable completeTask, List<ServiceController<?>> controllers) {
        final AtomicInteger cnt = new AtomicInteger(controllers.size());
        AbstractServiceListener<Object> listener = new AbstractServiceListener<Object>(){

            @Override
            public void listenerAdded(ServiceController<? extends Object> serviceController) {
                serviceController.setMode(ServiceController.Mode.NEVER);
            }

            @Override
            public void serviceStopped(ServiceController<? extends Object> serviceController) {
                serviceController.remove();
            }

            @Override
            public void serviceRemoved(ServiceController<? extends Object> serviceController) {
                if (cnt.decrementAndGet() == 0) {
                    completeTask.run();
                }
            }
        };
        for (ServiceController<?> controller : controllers) {
            controller.addListener(listener);
        }
    }
}

