/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.services;

import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.Value;

public final class MBeanService
implements Service<Void> {
    private final Value<? extends MBeanServer> mbeanServer;
    private final Value<?> value;
    private final ObjectName objectName;
    public static ServiceName JBOSS_JMX = ServiceName.JBOSS.append("jmx");
    public static ServiceName JBOSS_JMX_MBEAN = JBOSS_JMX.append("mbean");
    public static ServiceName JBOSS_JMX_MBEANSERVER = JBOSS_JMX.append("mbeanServer");

    public MBeanService(Value<? extends MBeanServer> mbeanServer, Value<?> value, ObjectName objectName) {
        this.mbeanServer = mbeanServer;
        this.value = value;
        this.objectName = objectName;
    }

    @Override
    public void start(StartContext context) throws StartException {
        try {
            this.mbeanServer.getValue().registerMBean(this.value.getValue(), this.objectName);
        }
        catch (Exception e) {
            throw new StartException(e);
        }
    }

    @Override
    public void stop(StopContext context) {
        try {
            this.mbeanServer.getValue().unregisterMBean(this.objectName);
        }
        catch (JMException jMException) {
            // empty catch block
        }
    }

    @Override
    public Void getValue() throws IllegalStateException {
        return null;
    }
}

