/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.services;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;

public final class VFSMountService
implements Service<Void> {
    private final String path;
    private final TempFileProvider tempFileProvider;
    private final boolean exploded;
    private volatile Closeable handle;

    public VFSMountService(String path, TempFileProvider tempFileProvider, boolean exploded) {
        this.path = path;
        this.tempFileProvider = tempFileProvider;
        this.exploded = exploded;
    }

    @Override
    public void start(StartContext context) throws StartException {
        try {
            VirtualFile virtualFile = VFS.getChild((String)this.path);
            File file = virtualFile.getPhysicalFile();
            if (file.isDirectory()) {
                this.handle = null;
                return;
            }
            this.handle = this.exploded ? VFS.mountZipExpanded((VirtualFile)virtualFile, (VirtualFile)virtualFile, (TempFileProvider)this.tempFileProvider) : VFS.mountZip((VirtualFile)virtualFile, (VirtualFile)virtualFile, (TempFileProvider)this.tempFileProvider);
        }
        catch (IOException e) {
            throw new StartException(e);
        }
    }

    @Override
    public void stop(StopContext context) {
        VFSUtils.safeClose((Closeable)this.handle);
        this.handle = null;
    }

    @Override
    public Void getValue() throws IllegalStateException {
        return null;
    }
}

