/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.services.http;

import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.util.concurrent.Executor;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.inject.SetMethodInjector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;
import org.jboss.msc.value.Values;

public final class HttpServerService
implements Service<HttpServer> {
    private HttpServer realServer;
    private HttpServer server;
    private Executor executor;
    private int stopDelay = 5;
    private int backlog = 0;
    private InetSocketAddress bindAddress;
    public static final Value<Method> EXECUTOR_SETTER = Values.getSetterMethod("executor", Executor.class);
    public final Injector<Executor> executorInjector = new SetMethodInjector<Executor>(new ImmediateValue<HttpServerService>(this), EXECUTOR_SETTER);

    public synchronized Executor getExecutor() {
        return this.executor;
    }

    public synchronized void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public synchronized int getStopDelay() {
        return this.stopDelay;
    }

    public synchronized void setStopDelay(int stopDelay) {
        if (stopDelay < 0) {
            throw new IllegalArgumentException("Bad value for stop delay (must be >0)");
        }
        this.stopDelay = stopDelay;
    }

    @Override
    public synchronized void start(StartContext context) throws StartException {
        HttpServer server;
        Executor executor = this.executor;
        try {
            server = HttpServer.create();
            server.setExecutor(executor);
            server.bind(this.bindAddress, this.backlog);
            server.start();
        }
        catch (IOException e) {
            throw new StartException("Failed to start web server", e);
        }
        this.server = new HttpServerWrapper(server);
        this.realServer = server;
    }

    @Override
    public synchronized void stop(StopContext context) {
        this.realServer.stop(this.stopDelay);
    }

    public synchronized int getBacklog() {
        return this.backlog;
    }

    public synchronized void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    public synchronized InetSocketAddress getBindAddress() {
        return this.bindAddress;
    }

    public synchronized void setBindAddress(InetSocketAddress bindAddress) {
        this.bindAddress = bindAddress;
    }

    @Override
    public synchronized HttpServer getValue() throws IllegalStateException {
        HttpServer server = this.server;
        if (server == null) {
            throw new IllegalStateException("Not started");
        }
        return server;
    }

    private class HttpServerWrapper
    extends HttpServer {
        private final HttpServer delegate;

        private HttpServerWrapper(HttpServer delegate) {
            this.delegate = delegate;
        }

        @Override
        public HttpContext createContext(String s, HttpHandler httpHandler) {
            return this.delegate.createContext(s, httpHandler);
        }

        @Override
        public HttpContext createContext(String s) {
            return this.delegate.createContext(s);
        }

        @Override
        public void removeContext(String s) throws IllegalArgumentException {
            throw new UnsupportedOperationException("remove context by path");
        }

        @Override
        public void removeContext(HttpContext httpContext) {
            this.delegate.removeContext(httpContext);
        }

        @Override
        public InetSocketAddress getAddress() {
            return this.delegate.getAddress();
        }

        @Override
        public void bind(InetSocketAddress inetSocketAddress, int i) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void start() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setExecutor(Executor executor) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Executor getExecutor() {
            return this.delegate.getExecutor();
        }

        @Override
        public void stop(int i) {
            throw new UnsupportedOperationException();
        }
    }
}

