/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.inject;

import java.lang.reflect.Field;
import org.jboss.msc.inject.InjectionException;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.inject.InjectorLogger;
import org.jboss.msc.value.Value;

public final class FieldInjector<T>
implements Injector<T> {
    private final Value<?> target;
    private final Value<Field> fieldValue;

    public FieldInjector(Value<?> target, Value<Field> fieldValue) {
        this.target = target;
        this.fieldValue = fieldValue;
    }

    @Override
    public void inject(T value) {
        try {
            this.fieldValue.getValue().set(this.target.getValue(), value);
        }
        catch (Exception e) {
            throw new InjectionException("Failed to inject value into field", e);
        }
    }

    @Override
    public void uninject() {
        try {
            this.fieldValue.getValue().set(this.target.getValue(), null);
        }
        catch (Throwable throwable) {
            InjectorLogger.INSTANCE.uninjectFailed(throwable, this.fieldValue);
        }
    }
}

